/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.infra.gateway.core.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class EncoderUtil {
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_SHA_1 = "SHA-1";
    public static final String ALGORITHM_SHA_256 = "SHA-256";
    public static final String ALGORITHM__SHA_384 = "SHA-384";
    public static final String ALGORITHM_SHA_512 = "SHA-512";

    public static String EncoderByAlgorithm(String key) {
        return EncoderUtil.EncoderByAlgorithm(key, ALGORITHM_SHA_256);
    }

    public static String EncoderByAlgorithm(String key, String algorithm) {
        String cacheKey;
        try {
            MessageDigest mDigest = MessageDigest.getInstance(algorithm);
            mDigest.update(key.getBytes());
            cacheKey = EncoderUtil.bytesToHexString(mDigest.digest());
        }
        catch (NoSuchAlgorithmException var4) {
            cacheKey = String.valueOf(key.hashCode());
        }
        return cacheKey;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String md5(String s) {
        String MD5 = ALGORITHM_MD5;
        try {
            MessageDigest digest = MessageDigest.getInstance(ALGORITHM_MD5);
            digest.update(s.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte aMessageDigest : messageDigest) {
                String h = Integer.toHexString(0xFF & aMessageDigest);
                while (h.length() < 2) {
                    h = "0" + h;
                }
                hexString.append(h);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }
}

