/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.infra.gateway.core.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;

public class SafeStringUtils {
    private SharedPreferences mSharedPreferences;
    private static SafeStringUtils INSTANCE;
    private Context mContext;
    public static final String SP_NAME = "gateway_core";

    private SafeStringUtils(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public static synchronized SafeStringUtils getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new SafeStringUtils(context);
        }
        return INSTANCE;
    }

    public void saveString(String key, String data) {
        if (this.mContext == null) {
            return;
        }
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = this.getSharedPreferences(this.mContext);
        }
        if (this.mSharedPreferences == null) {
            return;
        }
        try {
            this.mSharedPreferences.edit().putString(key, data).apply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getString(String key) {
        if (this.mContext == null) {
            return "";
        }
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = this.getSharedPreferences(this.mContext);
        }
        if (this.mSharedPreferences == null) {
            return "";
        }
        try {
            return this.mSharedPreferences.getString(key, "");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void saveLong(String key, long data) {
        if (this.mContext == null) {
            return;
        }
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = this.getSharedPreferences(this.mContext);
        }
        if (this.mSharedPreferences == null) {
            return;
        }
        try {
            this.mSharedPreferences.edit().putLong(key, data).apply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getLong(String key) {
        if (this.mContext == null) {
            return -1L;
        }
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = this.getSharedPreferences(this.mContext);
        }
        if (this.mSharedPreferences == null) {
            return -1L;
        }
        try {
            return this.mSharedPreferences.getLong(key, 0L);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public void saveInt(String key, int data) {
        if (this.mContext == null) {
            return;
        }
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = this.getSharedPreferences(this.mContext);
        }
        if (this.mSharedPreferences == null) {
            return;
        }
        try {
            this.mSharedPreferences.edit().putInt(key, data).apply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getInt(String key) {
        if (this.mContext == null) {
            return -1;
        }
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = this.getSharedPreferences(this.mContext);
        }
        if (this.mSharedPreferences == null) {
            return -1;
        }
        try {
            return this.mSharedPreferences.getInt(key, 0);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private SharedPreferences getSharedPreferences(Context context) {
        if (Build.VERSION.SDK_INT < 24) {
            if (this.mSharedPreferences != null) {
                return this.mSharedPreferences;
            }
            if (context == null) {
                return null;
            }
            try {
                this.mSharedPreferences = context.getSharedPreferences(SP_NAME, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.mSharedPreferences;
        }
        try {
            this.mSharedPreferences = context.getSharedPreferences(SP_NAME, 0);
            return this.mSharedPreferences;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

