/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.okhttp3;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.HttpException;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.util.ContentLengthInputStream;
import com.bumptech.glide.util.Preconditions;
import com.transsion.athenacust.AthenaCust;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpStreamFetcher
implements DataFetcher<InputStream>,
Callback {
    private static final String TAG = "OkHttpFetcher";
    private final Call.Factory client;
    private final GlideUrl url;
    private InputStream stream;
    private ResponseBody responseBody;
    private DataFetcher.DataCallback<? super InputStream> callback;
    private volatile Call call;
    long id = 0L;

    public OkHttpStreamFetcher(Call.Factory client, GlideUrl url) {
        this.client = client;
        this.url = url;
    }

    public void loadData(@NonNull Priority priority, @NonNull DataFetcher.DataCallback<? super InputStream> callback) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url.toStringUrl());
        for (Map.Entry headerEntry : this.url.getHeaders().entrySet()) {
            String key = (String)headerEntry.getKey();
            requestBuilder.addHeader(key, (String)headerEntry.getValue());
        }
        requestBuilder.addHeader("Accept-Encoding", "identity");
        Request request = requestBuilder.build();
        this.callback = callback;
        this.call = this.client.newCall(request);
        this.call.enqueue((Callback)this);
        this.id = System.currentTimeMillis();
        Bundle bundle = new Bundle();
        bundle.putInt("type", 1);
        bundle.putLong("id", this.id);
        bundle.putString("url", request.url().toString());
        new AthenaCust("imgup_begin", 1061).trackCommon(bundle, null).submit();
    }

    public void onFailure(@NonNull Call call, @NonNull IOException e) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"OkHttp failed to obtain result", (Throwable)e);
        }
        Bundle bundle = new Bundle();
        bundle.putInt("type", 1);
        bundle.putLong("id", this.id);
        bundle.putString("url", call.request().url().toString());
        bundle.putString("result", e.getMessage());
        new AthenaCust("imgup_result", 1061).trackCommon(bundle, null).submit();
        this.callback.onLoadFailed((Exception)e);
    }

    public void onResponse(@NonNull Call call, @NonNull Response response) {
        this.responseBody = response.body();
        Bundle bundle = new Bundle();
        bundle.putInt("type", 1);
        bundle.putLong("id", this.id);
        bundle.putString("url", call.request().url().toString());
        if (response.isSuccessful()) {
            long contentLength = ((ResponseBody)Preconditions.checkNotNull((Object)this.responseBody)).contentLength();
            this.stream = ContentLengthInputStream.obtain((InputStream)this.responseBody.byteStream(), (long)contentLength);
            this.callback.onDataReady((Object)this.stream);
            bundle.putString("result", "success");
            long length = contentLength;
            try {
                if (contentLength == -1L) {
                    length = response.body().contentLength();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            bundle.putLong("length", length);
        } else {
            this.callback.onLoadFailed((Exception)new HttpException(response.message(), response.code()));
            bundle.putString("result", response.message() + " " + response.code());
        }
        new AthenaCust("imgup_result", 1061).trackCommon(bundle, null).submit();
    }

    public void cleanup() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.responseBody != null) {
            this.responseBody.close();
        }
        this.callback = null;
    }

    public void cancel() {
        Call local = this.call;
        if (local != null) {
            local.cancel();
        }
    }

    @NonNull
    public Class<InputStream> getDataClass() {
        return InputStream.class;
    }

    @NonNull
    public DataSource getDataSource() {
        return DataSource.REMOTE;
    }
}

