/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.http.impl;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.transsion.http.impl.IHttpCallback;
import com.transsion.http.log.Console;
import com.transsion.http.log.LogInterface;
import com.transsion.http.util.CheckUtil;
import java.io.IOException;

public abstract class HttpCallbackImpl
implements IHttpCallback {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String UTF8_BOM = "\ufeff";
    private Handler a;
    private boolean b;
    private boolean c;
    private Looper d;

    public HttpCallbackImpl() {
        this(null);
    }

    public HttpCallbackImpl(Looper looper) {
        if (looper == null) {
            looper = Looper.myLooper();
        }
        this(looper, false);
    }

    public HttpCallbackImpl(boolean bl) {
        Looper looper = bl ? null : Looper.myLooper();
        this(looper, bl);
    }

    private HttpCallbackImpl(Looper looper, boolean bl) {
        this.d = null;
        if (!bl) {
            CheckUtil.asserts(looper != null, "use looper thread, must call Looper.prepare() first!");
            HttpCallbackImpl httpCallbackImpl = this;
            httpCallbackImpl.d = looper;
            httpCallbackImpl.a = new a(this, looper);
        } else {
            CheckUtil.asserts(looper == null, "use pool thread, looper should be null!");
            HttpCallbackImpl httpCallbackImpl = this;
            httpCallbackImpl.d = null;
            httpCallbackImpl.a = null;
        }
        this.c = bl;
    }

    @Override
    public void setUseSyncMode(boolean bl) {
        if (!bl && this.d == null) {
            bl = true;
            Console.log.w("HttpCallbackImpl", "Current thread has not called Looper.prepare(). Forcing synchronous mode.");
        }
        if (!bl && this.a == null) {
            HttpCallbackImpl httpCallbackImpl = this;
            this.a = new a(httpCallbackImpl, httpCallbackImpl.d);
        } else if (bl && this.a != null) {
            this.a = null;
        }
        this.b = bl;
    }

    @Override
    public boolean getUseSyncMode() {
        return this.b;
    }

    @Override
    public boolean getUsePoolThread() {
        return this.c;
    }

    @Override
    public void setUsePoolThread(boolean bl) {
        if (bl) {
            HttpCallbackImpl httpCallbackImpl = this;
            httpCallbackImpl.d = null;
            httpCallbackImpl.a = null;
        }
        this.c = bl;
    }

    public abstract void onSuccess(int var1, byte[] var2);

    public void onSuccess(int n2, byte[] byArray, String string) {
    }

    public abstract void onFailure(int var1, byte[] var2, Throwable var3);

    @Override
    public void sendSuccessMessage(int n2, byte[] byArray) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        objectArray[1] = byArray;
        objectArray2.b(objectArray2.a(0, objectArray2));
    }

    @Override
    public void sendSuccessMessage(int n2, byte[] byArray, String string) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        objectArray[1] = byArray;
        objectArray[2] = string;
        objectArray2.b(objectArray2.a(0, objectArray2));
    }

    @Override
    public void sendFailureMessage(int n2, byte[] byArray, Throwable throwable) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        objectArray[1] = byArray;
        objectArray[2] = throwable;
        objectArray2.b(objectArray2.a(1, objectArray2));
    }

    @Override
    public void sendStartMessage() {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(2, null));
    }

    @Override
    public void sendFinishMessage() {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(3, null));
    }

    @Override
    public void sendRetryMessage(int n2) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        objectArray2.b(objectArray2.a(5, objectArray2));
    }

    @Override
    public void sendPauseMessage() {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(7, null));
    }

    @Override
    public void sendProgressMessage(long l2, long l3) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = l2;
        objectArray[1] = l3;
        objectArray2.b(objectArray2.a(4, objectArray2));
    }

    @Override
    public final void sendCancelMessage() {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(6, null));
    }

    protected void a(Runnable runnable) {
        if (runnable != null) {
            if (!this.getUseSyncMode() && (this = this.a) != null) {
                this.post(runnable);
            } else {
                runnable.run();
            }
        }
    }

    protected Message a(int n2, Object object) {
        return Message.obtain((Handler)this.a, (int)n2, (Object)object);
    }

    protected void b(Message message) {
        if (!this.getUseSyncMode() && this.a != null) {
            if (!Thread.currentThread().isInterrupted()) {
                CheckUtil.asserts(this.a != null, "handler should not be null!");
                this.a.sendMessage(message);
            }
        } else {
            this.a(message);
        }
    }

    /*
     * Exception decompiling
     */
    protected void a(Message var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 24[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void sendResponseMessage(int n2, byte[] byArray) {
        if (!Thread.currentThread().isInterrupted()) {
            if (n2 >= 300) {
                this.sendFailureMessage(n2, byArray, new IOException());
            } else {
                this.sendSuccessMessage(n2, byArray);
            }
        }
    }

    @Override
    public void sendResponseMessage(int n2, byte[] byArray, String string) {
        if (!Thread.currentThread().isInterrupted()) {
            if (n2 >= 300) {
                this.sendFailureMessage(n2, byArray, new IOException());
            } else {
                this.sendSuccessMessage(n2, byArray, string);
            }
        }
    }

    public void onStart() {
    }

    public void onFinish() {
    }

    public void onCancel() {
        Console.log.d("HttpCallbackImpl", "Request got cancelled");
    }

    public void onRetry(int n2) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        Console.log.d("HttpCallbackImpl", String.format("Request retry no. %d", objectArray2));
    }

    public void onProgress(long l2, long l3) {
        LogInterface logInterface = Console.log;
        String string = "HttpCallbackImpl";
        String string2 = "Progress %d from %d (%2.0f%%)";
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = l2;
        objectArray[1] = l3;
        int n2 = 2;
        Double d2 = l3 > 0L ? (double)l2 * 1.0 / (double)l3 * 100.0 : -1.0;
        objectArray2[n2] = d2;
        logInterface.v(string, String.format(string2, objectArray2));
    }

    public void onPause() {
        Console.log.d("HttpCallbackImpl", "Request got onPaused");
    }

    public void onUserException(Throwable throwable) {
        Console.log.e("HttpCallbackImpl", "User-space exception detected!", throwable);
        throw new RuntimeException(throwable);
    }

    private static class a
    extends Handler {
        private final HttpCallbackImpl a;

        a(HttpCallbackImpl httpCallbackImpl, Looper looper) {
            super(looper);
            this.a = httpCallbackImpl;
        }

        public void handleMessage(Message message) {
            this.a.a(message);
        }
    }
}

