/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.http.util;

import android.util.Log;
import com.transsion.http.a.o;
import com.transsion.http.util.Pools;
import com.transsion.http.util.b;
import com.transsion.http.util.c;
import java.util.List;

public final class FactoryPools {
    private static final String TAG = "FactoryPools";
    private static final int DEFAULT_POOL_SIZE = 20;
    private static final Resetter<Object> EMPTY_RESETTER = new com.transsion.http.util.a();

    private FactoryPools() {
    }

    public static <T extends Poolable> Pools.Pool<T> simple(int n2, Factory<T> factory) {
        return FactoryPools.build(new Pools.SimplePool(n2), factory);
    }

    public static <T extends Poolable> Pools.Pool<T> threadSafe(int n2, Factory<T> factory) {
        return FactoryPools.build(new Pools.SynchronizedPool(n2), factory);
    }

    public static <T> Pools.Pool<List<T>> threadSafeList() {
        return FactoryPools.threadSafeList(20);
    }

    public static <T> Pools.Pool<List<T>> threadSafeList(int n2) {
        return FactoryPools.build(new Pools.SynchronizedPool(n2), new b(), new c());
    }

    private static <T extends Poolable> Pools.Pool<T> build(Pools.Pool<T> pool, Factory<T> factory) {
        return FactoryPools.build(pool, factory, EMPTY_RESETTER);
    }

    private static <T> Pools.Pool<T> build(Pools.Pool<T> pool, Factory<T> factory, Resetter<T> resetter) {
        return new a<T>(pool, factory, resetter);
    }

    private static <T> Resetter<T> emptyResetter() {
        return EMPTY_RESETTER;
    }

    private static final class a<T>
    implements Pools.Pool<T> {
        private final Factory<T> a;
        private final Resetter<T> b;
        private final Pools.Pool<T> c;

        a(Pools.Pool<T> pool, Factory<T> factory, Resetter<T> resetter) {
            this.c = pool;
            this.a = factory;
            this.b = resetter;
        }

        @Override
        public T acquire() {
            T t = this.c.acquire();
            if (t == null) {
                t = this.a.create();
                if (Log.isLoggable((String)FactoryPools.TAG, (int)2)) {
                    Log.v((String)FactoryPools.TAG, (String)("Created new " + t.getClass()));
                }
            }
            if (t instanceof Poolable) {
                ((Poolable)t).getVerifier().a(false);
            }
            return t;
        }

        @Override
        public boolean release(T t) {
            if (t instanceof Poolable) {
                ((Poolable)t).getVerifier().a(true);
            }
            a a2 = this;
            a2.b.reset(t);
            return a2.c.release(t);
        }
    }

    public static interface Poolable {
        public o getVerifier();
    }

    public static interface Resetter<T> {
        public void reset(T var1);
    }

    public static interface Factory<T> {
        public T create();
    }
}

