/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.http.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageUtil {
    public static byte[] bitmapToByte(Bitmap object) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (object == null) {
            return null;
        }
        Bitmap bitmap = object;
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public static Bitmap byteToBitmap(byte[] byArray) {
        return byArray != null && byArray.length != 0 ? BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length) : null;
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        return drawable == null ? null : ((BitmapDrawable)drawable).getBitmap();
    }

    public static Drawable bitmapToDrawable(Bitmap bitmap) {
        BitmapDrawable bitmapDrawable;
        if (bitmap == null) {
            bitmap = null;
            bitmapDrawable = bitmap;
        } else {
            BitmapDrawable bitmapDrawable2;
            bitmapDrawable = bitmapDrawable2;
            bitmapDrawable2 = new BitmapDrawable(bitmap);
        }
        return bitmapDrawable;
    }

    public static byte[] drawableToByte(Drawable drawable) {
        return ImageUtil.bitmapToByte(ImageUtil.drawableToBitmap(drawable));
    }

    public static Drawable byteToDrawable(byte[] byArray) {
        return ImageUtil.bitmapToDrawable(ImageUtil.byteToBitmap(byArray));
    }

    public static Bitmap scaleImageTo(Bitmap bitmap, int n2, int n3) {
        return ImageUtil.scaleImage(bitmap, (float)n2 / (float)bitmap.getWidth(), (float)n3 / (float)bitmap.getHeight());
    }

    public static Bitmap scaleImage(Bitmap bitmap, float f2, float f3) {
        Matrix matrix;
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = bitmap;
        bitmap = matrix;
        bitmap();
        matrix.postScale(f2, f3);
        int n2 = bitmap2.getWidth();
        int n3 = bitmap2.getHeight();
        return Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n2, (int)n3, (Matrix)bitmap, (boolean)true);
    }

    private static void closeInputStream(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException occurred. ", iOException);
        }
    }
}

