/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.http.util;

public final class Pools {
    private Pools() {
    }

    public static class SynchronizedPool<T>
    extends SimplePool<T> {
        private final Object mLock = new Object();

        public SynchronizedPool(int n2) {
            super(n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T acquire() {
            SynchronizedPool synchronizedPool = object;
            Object object = synchronizedPool.mLock;
            synchronized (object) {
                return super.acquire();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean release(T t) {
            SynchronizedPool synchronizedPool = object;
            Object object = ((SynchronizedPool)object).mLock;
            synchronized (object) {
                return super.release(t);
            }
        }
    }

    public static class SimplePool<T>
    implements Pool<T> {
        private final Object[] mPool;
        private int mPoolSize;

        public SimplePool(int n2) {
            if (n2 > 0) {
                this.mPool = new Object[n2];
                return;
            }
            throw new IllegalArgumentException("The max pool size must be > 0");
        }

        private boolean isInPool(T t) {
            for (int i2 = 0; i2 < this.mPoolSize; ++i2) {
                if (this.mPool[i2] != t) continue;
                return true;
            }
            return false;
        }

        @Override
        public T acquire() {
            int n2 = this.mPoolSize;
            if (n2 > 0) {
                int n3 = n2 - 1;
                Object[] objectArray = this.mPool;
                objectArray[n3] = null;
                this.mPoolSize = n2 - 1;
                return (T)this.mPool[n3];
            }
            return null;
        }

        @Override
        public boolean release(T t) {
            if (!this.isInPool(t)) {
                int n2 = this.mPoolSize;
                Object[] objectArray = this.mPool;
                if (n2 < this.mPool.length) {
                    objectArray[n2] = t;
                    this.mPoolSize = n2 + 1;
                    return true;
                }
                return false;
            }
            throw new IllegalStateException("Already in the pool!");
        }
    }

    public static interface Pool<T> {
        public T acquire();

        public boolean release(T var1);
    }
}

