/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.http.util;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.transsion.core.utils.Commutil;
import java.io.File;
import java.io.IOException;

public final class StorageUtils {
    private static final String EXTERNAL_STORAGE_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    private static final String INDIVIDUAL_DIR_NAME = "ad-images";

    private StorageUtils() {
    }

    public static File getCacheDirectory(Context context) {
        return StorageUtils.getCacheDirectory(context, true);
    }

    public static File getCacheDirectory(Context object, boolean bl) {
        String string;
        File file;
        block7: {
            file = null;
            try {
                string = Environment.getExternalStorageState();
                break block7;
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            }
            catch (NullPointerException nullPointerException) {}
            string = "";
        }
        if (bl && "mounted".equals(string) && StorageUtils.hasExternalStoragePermission(object)) {
            file = StorageUtils.getExternalCacheDir(object);
        }
        if (!(file != null && (file.exists() || file.mkdirs()) || (file = Commutil.getExternalCacheDir((Context)object.getApplicationContext())) != null && file.exists())) {
            file = object.getFilesDir();
        }
        if (file == null || !file.exists()) {
            file = object.getCacheDir();
        }
        if (file == null) {
            File file2;
            object = "/data/data/" + object.getPackageName() + "/cache/";
            Log.w((String)"error", (String)("Can't define system cache directory! '%s' will be used." + (String)object));
            file = file2;
            file2 = new File((String)object);
        }
        return file;
    }

    public static File getIndividualCacheDirectory(Context context) {
        return StorageUtils.getIndividualCacheDirectory(context, INDIVIDUAL_DIR_NAME);
    }

    public static File getIndividualCacheDirectory(Context object, String string) {
        File file;
        object = StorageUtils.getCacheDirectory(object);
        File file2 = file;
        if (!new File((File)object, string).exists() && !file2.mkdir()) {
            file2 = object;
        }
        return file2;
    }

    public static File getOwnCacheDirectory(Context context, String string) {
        File file = null;
        if ("mounted".equals(Environment.getExternalStorageState()) && StorageUtils.hasExternalStoragePermission(context)) {
            File file2;
            file = file2;
            file2 = new File(Environment.getExternalStorageDirectory(), string);
        }
        if (file == null || !file.exists() && !file.mkdirs()) {
            file = context.getCacheDir();
        }
        return file;
    }

    public static File getOwnCacheDirectory(Context context, String string, boolean bl) {
        File file = null;
        if (bl && "mounted".equals(Environment.getExternalStorageState()) && StorageUtils.hasExternalStoragePermission(context)) {
            File file2;
            file = file2;
            file2 = new File(Environment.getExternalStorageDirectory(), string);
        }
        if (!(file != null && (file.exists() || file.mkdirs()) || (file = Commutil.getExternalCacheDir((Context)context.getApplicationContext())) != null && file.exists())) {
            file = context.getCacheDir();
        }
        return file;
    }

    public static File getOwnCacheDirectory(Context context) {
        File file = context.getFilesDir();
        if (file == null || !file.exists()) {
            file = context.getCacheDir();
        }
        return file;
    }

    private static File getExternalCacheDir(Context context) {
        File file;
        File file2;
        File file3 = file2;
        file2 = new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data");
        File file4 = file;
        if (!new File(new File(new File(file3, context.getPackageName()), "files"), "images").exists()) {
            if (!file4.mkdirs()) {
                Log.w((String)"error", (String)"Unable to create external cache directory");
                return null;
            }
            try {
                new File(file4, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                Log.i((String)"error", (String)"Can't create \".nomedia\" file in application external cache directory");
            }
        }
        return file4;
    }

    private static boolean hasExternalStoragePermission(Context context) {
        return context.checkCallingOrSelfPermission(EXTERNAL_STORAGE_PERMISSION) == 0;
    }
}

