/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.http2.util;

import com.transsion.http2.util.StringBuilderPool;
import com.transsion.http2.util.StringUtils;
import com.transsion.http2.util.Utf8UrlEncoder;
import h2.h2.h2.h20.h2;
import h2.h2.h2.h8;
import h3.h2.h5.h2.h28.h19;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class HttpUtils {
    public static final String ACCEPT_ALL_HEADER_VALUE = "*/*";
    public static final String GZIP_DEFLATE = h19.h9 + "," + h19.h7;
    public static byte[] h2 = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(StandardCharsets.US_ASCII);

    public static String hostHeader(h2 h210) {
        h2 h211 = h210;
        String string = h211.h4;
        int n2 = h211.h5;
        if (n2 != -1 && n2 != h210.h4()) {
            string = string + ":" + n2;
        }
        return string;
    }

    public static String originHeader(h2 h210) {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.stringBuilder();
        String string = h210.h10 ? "https://" : "http://";
        stringBuilder.append(string).append(h210.h4);
        if (h210.h3() != h210.h4()) {
            stringBuilder.append(':').append(h210.h5);
        }
        return stringBuilder.toString();
    }

    public static Charset extractContentTypeCharsetAttribute(String string) {
        return (string = HttpUtils.h2(string, "charset=")) != null ? Charset.forName(string) : null;
    }

    public static String extractContentTypeBoundaryAttribute(String string) {
        return HttpUtils.h2(string, "boundary=");
    }

    public static String h2(String string, String string2) {
        if (string == null) {
            return null;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2;
            int n3 = string2.length();
            if (!string.regionMatches(true, i2, string2, 0, n3)) continue;
            for (n2 = i2 + string2.length(); n2 < string.length(); ++n2) {
                char c2 = string.charAt(n2);
                i2 = c2;
                if (c2 != ' ' && i2 != 39 && i2 != 34) break;
            }
            if (n2 == string.length()) break;
            for (i2 = n2 + 1; i2 < string.length(); ++i2) {
                char c3 = string.charAt(i2);
                n3 = c3;
                if (c3 == ' ' || n3 == 39 || n3 == 34 || n3 == 59) break;
            }
            return string.substring(n2, i2);
        }
        return null;
    }

    public static byte[] computeMultipartBoundary() {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        int n2 = threadLocalRandom.nextInt(11) + 30;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = h2[threadLocalRandom.nextInt(h2.length)];
        }
        return byArray;
    }

    public static String patchContentTypeWithBoundaryAttribute(CharSequence charSequence, byte[] byArray) {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.stringBuilder().append(charSequence);
        if (charSequence.length() != 0) {
            CharSequence charSequence2 = charSequence;
            if (charSequence2.charAt(charSequence2.length() - 1) != ';') {
                stringBuilder.append(';');
            }
        }
        return stringBuilder.append(' ').append("boundary=").append(new String(byArray, StandardCharsets.US_ASCII)).toString();
    }

    /*
     * Loose catch block
     */
    public static ByteBuffer urlEncodeFormParams(List<h8> object, Charset charset) {
        List<h8> list = object;
        object = StringBuilderPool.DEFAULT.stringBuilder();
        for (h8 h82 : list) {
            block10: {
                String string;
                block11: {
                    String string2 = h82.h2;
                    string = h82.h3;
                    if (charset.equals(StandardCharsets.UTF_8)) {
                        Utf8UrlEncoder.encodeAndAppendFormElement((StringBuilder)object, string2);
                    } else {
                        ((StringBuilder)object).append(URLEncoder.encode(string2, charset.name()));
                    }
                    break block11;
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                if (string != null) {
                    ((StringBuilder)object).append('=');
                    if (charset.equals(StandardCharsets.UTF_8)) {
                        Utf8UrlEncoder.encodeAndAppendFormElement((StringBuilder)object, string);
                    } else {
                        ((StringBuilder)object).append(URLEncoder.encode(string, charset.name()));
                    }
                    break block10;
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }
            ((StringBuilder)object).append('&');
        }
        Object object2 = object;
        ((StringBuilder)object2).setLength(((StringBuilder)object2).length() - 1);
        return StringUtils.charSequence2ByteBuffer((CharSequence)object2, StandardCharsets.US_ASCII);
    }

    public static CharSequence filterOutBrotliFromAcceptEncoding(String string) {
        if (string.endsWith(", br")) {
            String string2 = string;
            return string2.subSequence(0, string2.length() - 4);
        }
        return string;
    }
}

