/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.http2.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.Supplier;

public final class MessageDigestUtils {
    public static final ThreadLocal<MessageDigest> h2 = ThreadLocal.withInitial(new Supplier<MessageDigest>(){

        @Override
        public Object get() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("MD5 not supported on this platform");
            }
        }
    });
    public static final ThreadLocal<MessageDigest> h3 = ThreadLocal.withInitial(new Supplier<MessageDigest>(){

        @Override
        public Object get() {
            try {
                return MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("SHA1 not supported on this platform");
            }
        }
    });

    public static MessageDigest pooledMd5MessageDigest() {
        MessageDigest messageDigest = h2.get();
        messageDigest.reset();
        return messageDigest;
    }

    public static MessageDigest pooledSha1MessageDigest() {
        MessageDigest messageDigest = h3.get();
        messageDigest.reset();
        return messageDigest;
    }
}

