/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.http2.util;

import com.transsion.http2.util.StringBuilderPool;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public final class StringUtils {
    public static ByteBuffer charSequence2ByteBuffer(CharSequence charSequence, Charset charset) {
        return charset.encode(CharBuffer.wrap(charSequence));
    }

    public static byte[] byteBuffer2ByteArray(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static byte[] charSequence2Bytes(CharSequence charSequence, Charset charset) {
        return StringUtils.byteBuffer2ByteArray(StringUtils.charSequence2ByteBuffer(charSequence, charset));
    }

    public static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.stringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(Integer.toHexString((by & 0xF0) >>> 4));
            stringBuilder.append(Integer.toHexString(by & 0xF));
        }
        return stringBuilder.toString();
    }

    public static void appendBase16(StringBuilder stringBuilder, byte[] byArray) {
        int n2 = 16;
        int n3 = byArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = byArray[i2] & 0xFF;
            int n5 = n4 / n2 % n2 + 48;
            if (n5 > 57) {
                n5 = n5 - 48 - 10 + 97;
            }
            stringBuilder.append((char)n5);
            n4 = n4 % n2 + 48;
            if (n4 > 57) {
                n4 = n4 - 48 - 10 + 97;
            }
            stringBuilder.append((char)n4);
        }
    }

    public static String stackTrace2String(Throwable object) {
        StringWriter stringWriter;
        Throwable throwable = object;
        object = stringWriter;
        stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)object, true));
        return ((StringWriter)object).toString();
    }
}

