/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import h3.h2.h3.h10;
import h3.h2.h3.h11;
import h3.h2.h3.h15;
import h3.h2.h3.h17;
import h3.h2.h3.h2;
import h3.h2.h3.h34;
import h3.h2.h3.h35;
import h3.h2.h3.h8;
import h3.h2.h3.h9;
import h3.h2.h7.h20;
import h3.h2.h7.h23;
import h3.h2.h7.h33.h19;
import h3.h2.h7.h33.h33;

public abstract class AbstractByteBufAllocator
implements h11 {
    public static final int DEFAULT_INITIAL_CAPACITY = 256;
    public static final int DEFAULT_MAX_CAPACITY = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_COMPONENTS = 16;
    public static final int CALCULATE_THRESHOLD = 0x400000;
    private final boolean directByDefault;
    private final h10 emptyBuf;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static h10 toLeakAwareBuffer(h10 h102) {
        h10 h103;
        int n2 = h20.h9.ordinal();
        if (n2 != 1) {
            h8 h82;
            if (n2 != 2 && n2 != 3) return h102;
            h23<h10> h232 = h2.h12.h2(h102);
            if (h232 == null) return h102;
            h103 = h82;
            h82 = new h8(h102, h232);
            return h103;
        } else {
            h34 h342;
            h23<h10> h233 = h2.h12.h2(h102);
            if (h233 == null) return h102;
            h103 = h342;
            h10 h104 = h102;
            h342 = new h34(h104, h104, h233);
        }
        return h103;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static h15 toLeakAwareBuffer(h15 h152) {
        h15 h153;
        int n2 = h20.h9.ordinal();
        if (n2 != 1) {
            h9 h92;
            if (n2 != 2 && n2 != 3) return h152;
            h23<h10> h232 = h2.h12.h2(h152);
            if (h232 == null) return h152;
            h153 = h92;
            h92 = new h9(h152, h232);
            return h153;
        } else {
            h35 h352;
            h23<h10> h233 = h2.h12.h2(h152);
            if (h233 == null) return h152;
            h153 = h352;
            h352 = new h35(h152, h233);
        }
        return h153;
    }

    public AbstractByteBufAllocator() {
        this(false);
    }

    public AbstractByteBufAllocator(boolean bl) {
        h17 h172;
        bl = bl && h19.h5();
        AbstractByteBufAllocator abstractByteBufAllocator = this;
        abstractByteBufAllocator.directByDefault = bl;
        h17 h173 = h172;
        h172 = new h17(this);
        abstractByteBufAllocator.emptyBuf = h173;
    }

    private static void validate(int n2, int n3) {
        int n4 = n2;
        h2.h2.h2.h13.h11.h2.h3(n4, "initialCapacity");
        if (n4 <= n3) {
            return;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n2;
        objectArray[1] = n3;
        throw new IllegalArgumentException(String.format("initialCapacity: %d (expected: not greater than maxCapacity(%d)", objectArray2));
    }

    static {
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "toLeakAwareBuffer";
        h20.h2(AbstractByteBufAllocator.class, stringArray2);
    }

    public h10 buffer() {
        if (this.directByDefault) {
            return this.directBuffer();
        }
        return this.heapBuffer();
    }

    @Override
    public h10 buffer(int n2) {
        if (this.directByDefault) {
            return this.directBuffer(n2);
        }
        return this.heapBuffer(n2);
    }

    @Override
    public h10 buffer(int n2, int n3) {
        if (this.directByDefault) {
            return this.directBuffer(n2, n3);
        }
        return this.heapBuffer(n2, n3);
    }

    public h10 ioBuffer() {
        if (!h19.h5() && !this.isDirectBufferPooled()) {
            return this.heapBuffer(256);
        }
        return this.directBuffer(256);
    }

    @Override
    public h10 ioBuffer(int n2) {
        if (!h19.h5() && !this.isDirectBufferPooled()) {
            return this.heapBuffer(n2);
        }
        return this.directBuffer(n2);
    }

    public h10 ioBuffer(int n2, int n3) {
        if (!h19.h5() && !this.isDirectBufferPooled()) {
            return this.heapBuffer(n2, n3);
        }
        return this.directBuffer(n2, n3);
    }

    public h10 heapBuffer() {
        return this.heapBuffer(256, Integer.MAX_VALUE);
    }

    @Override
    public h10 heapBuffer(int n2) {
        return this.heapBuffer(n2, Integer.MAX_VALUE);
    }

    @Override
    public h10 heapBuffer(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return this.emptyBuf;
        }
        int n4 = n2;
        AbstractByteBufAllocator.validate(n4, n3);
        return this.newHeapBuffer(n4, n3);
    }

    public h10 directBuffer() {
        return this.directBuffer(256, Integer.MAX_VALUE);
    }

    @Override
    public h10 directBuffer(int n2) {
        return this.directBuffer(n2, Integer.MAX_VALUE);
    }

    public h10 directBuffer(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return this.emptyBuf;
        }
        int n4 = n2;
        AbstractByteBufAllocator.validate(n4, n3);
        return this.newDirectBuffer(n4, n3);
    }

    public h15 compositeBuffer() {
        if (this.directByDefault) {
            return this.compositeDirectBuffer();
        }
        return this.compositeHeapBuffer();
    }

    @Override
    public h15 compositeBuffer(int n2) {
        if (this.directByDefault) {
            return this.compositeDirectBuffer(n2);
        }
        return this.compositeHeapBuffer(n2);
    }

    public h15 compositeHeapBuffer() {
        return this.compositeHeapBuffer(16);
    }

    public h15 compositeHeapBuffer(int n2) {
        return AbstractByteBufAllocator.toLeakAwareBuffer(new h15(this, false, n2, 0));
    }

    public h15 compositeDirectBuffer() {
        return this.compositeDirectBuffer(16);
    }

    public h15 compositeDirectBuffer(int n2) {
        return AbstractByteBufAllocator.toLeakAwareBuffer(new h15(this, true, n2, 0));
    }

    public abstract h10 newHeapBuffer(int var1, int var2);

    public abstract h10 newDirectBuffer(int var1, int var2);

    public String toString() {
        return h33.h2(this) + "(directByDefault: " + this.directByDefault + ')';
    }

    @Override
    public int calculateNewCapacity(int n2, int n3) {
        int n4 = n2;
        h2.h2.h2.h13.h11.h2.h3(n4, "minNewCapacity");
        if (n4 <= n3) {
            int n5;
            if (n2 == 0x400000) {
                return 0x400000;
            }
            if (n2 > 0x400000) {
                int n6 = n2 / 0x400000 * 0x400000;
                if (n6 <= n3 - 0x400000) {
                    n3 = n6 + 0x400000;
                }
                return n3;
            }
            for (n5 = 64; n5 < n2; n5 <<= 1) {
            }
            return Math.min(n5, n3);
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n2;
        objectArray[1] = n3;
        throw new IllegalArgumentException(String.format("minNewCapacity: %d (expected: not greater than maxCapacity(%d)", objectArray2));
    }

    @Override
    public abstract /* synthetic */ boolean isDirectBufferPooled();
}

