/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import h2.h2.h2.h13.h11.h2;
import h3.h2.h3.b;
import h3.h2.h3.d;
import h3.h2.h3.f;
import h3.h2.h3.g;
import h3.h2.h3.h;
import h3.h2.h3.h10;
import h3.h2.h3.h11;
import h3.h2.h3.h18;
import h3.h2.h3.h22;
import h3.h2.h3.h24;
import h3.h2.h3.h25;
import h3.h2.h3.h26;
import h3.h2.h7.h32.h15;
import h3.h2.h7.h32.h19;
import h3.h2.h7.h32.h21;
import h3.h2.h7.h33.b.h5;
import h3.h2.h7.h33.b.h6;
import h3.h2.h7.h33.h33;
import h3.h2.h7.h33.h34;
import h3.h2.h7.h33.h35;
import io.netty.buffer.AbstractByteBufAllocator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PooledByteBufAllocator
extends AbstractByteBufAllocator {
    private static final h5 logger;
    private static final int DEFAULT_NUM_HEAP_ARENA;
    private static final int DEFAULT_NUM_DIRECT_ARENA;
    private static final int DEFAULT_PAGE_SIZE;
    private static final int DEFAULT_MAX_ORDER;
    private static final int DEFAULT_SMALL_CACHE_SIZE;
    private static final int DEFAULT_NORMAL_CACHE_SIZE;
    private static final int DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
    private static final int DEFAULT_CACHE_TRIM_INTERVAL;
    private static final long DEFAULT_CACHE_TRIM_INTERVAL_MILLIS;
    private static final boolean DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    private static final int DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT;
    public static final int DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK;
    private static final int MIN_PAGE_SIZE = 4096;
    private static final int MAX_CHUNK_SIZE = 0x40000000;
    public static final PooledByteBufAllocator DEFAULT;
    public static final /* synthetic */ boolean $assertionsDisabled;
    private final Runnable trimTask;
    private final h18<byte[]>[] heapArenas;
    private final h18<ByteBuffer>[] directArenas;
    private final int smallCacheSize;
    private final int normalCacheSize;
    private final List<Object> heapArenaMetrics;
    private final List<Object> directArenaMetrics;
    private final h3 threadCache;
    private final int chunkSize;
    private final h26 metric;

    public PooledByteBufAllocator() {
        this(false);
    }

    public PooledByteBufAllocator(boolean bl) {
        int n2 = DEFAULT_NUM_DIRECT_ARENA;
        int n3 = DEFAULT_PAGE_SIZE;
        int n4 = DEFAULT_MAX_ORDER;
        this(bl, DEFAULT_NUM_HEAP_ARENA, n2, n3, n4);
    }

    public PooledByteBufAllocator(int n2, int n3, int n4, int n5) {
        this(false, n2, n3, n4, n5);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl, int n2, int n3, int n4, int n5) {
        int n6 = DEFAULT_SMALL_CACHE_SIZE;
        int n7 = DEFAULT_NORMAL_CACHE_SIZE;
        this(bl, n2, n3, n4, n5, 0, n6, n7);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        boolean bl2 = DEFAULT_USE_CACHE_FOR_ALL_THREADS;
        n6 = DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT;
        this(bl, n2, n3, n4, n5, n7, n8, bl2, n6);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        this(bl, n2, n3, n4, n5, n7, n8, bl2);
    }

    public PooledByteBufAllocator(boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        int n8 = DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT;
        this(bl, n2, n3, n4, n5, n6, n7, bl2, n8);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2, int n9) {
        this(bl, n2, n3, n4, n5, n7, n8, bl2, n9);
    }

    /*
     * WARNING - void declaration
     */
    public PooledByteBufAllocator(boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2, int n8) {
        void arrayList3;
        int h18Array;
        void arrayList2;
        void var4_10;
        int n9;
        int h39;
        void var8_17;
        void var9_18;
        void v0 = var9_18;
        super(bl);
        this.trimTask = new Runnable(){

            @Override
            public void run() {
                PooledByteBufAllocator.this.trimCurrentThreadCache();
            }
        };
        this.threadCache = new h3((boolean)var8_17);
        this.smallCacheSize = h39;
        this.normalCacheSize = n9;
        this.chunkSize = PooledByteBufAllocator.validateAndCalculateChunkSize((int)var4_10, (int)arrayList2);
        h2.h3(h18Array, "nHeapArena");
        h2.h3((int)arrayList3, "nDirectArena");
        h2.h3((int)v0, "directMemoryCacheAlignment");
        if (v0 > 0 && !PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported()) {
            throw new IllegalArgumentException("directMemoryCacheAlignment is not supported");
        }
        void v1 = var9_18;
        if ((v1 & -v1) == var9_18) {
            h26 h262;
            int h263 = PooledByteBufAllocator.validateAndCalculatePageShifts((int)var4_10);
            if (h18Array > 0) {
                ArrayList<h18.h3> arrayList;
                h18<T>[] h18Array2 = PooledByteBufAllocator.newArenaArray(h18Array);
                this.heapArenas = h18Array2;
                ArrayList<h18.h3> h211 = arrayList;
                arrayList = new ArrayList<h18.h3>(h18Array2.length);
                for (h18Array = 0; h18Array < this.heapArenas.length; ++h18Array) {
                    h18.h3 h38;
                    h18.h3 h310 = h38;
                    PooledByteBufAllocator pooledByteBufAllocator = this;
                    n9 = pooledByteBufAllocator.chunkSize;
                    h310(pooledByteBufAllocator, (int)var4_10, h263, n9, (int)var9_18);
                    this.heapArenas[h18Array] = h310;
                    h211.add(h38);
                }
                this.heapArenaMetrics = Collections.unmodifiableList(h211);
            } else {
                PooledByteBufAllocator pooledByteBufAllocator = this;
                pooledByteBufAllocator.heapArenas = null;
                pooledByteBufAllocator.heapArenaMetrics = Collections.emptyList();
            }
            if (arrayList3 > 0) {
                ArrayList<h18.h2> arrayList;
                h18<T>[] i2 = PooledByteBufAllocator.newArenaArray((int)arrayList3);
                this.directArenas = i2;
                ArrayList<h18.h2> arrayList4 = arrayList;
                arrayList = new ArrayList<h18.h2>(i2.length);
                for (int i3 = 0; i3 < this.directArenas.length; ++i3) {
                    h18.h2 h210;
                    h18.h2 h211 = h210;
                    PooledByteBufAllocator pooledByteBufAllocator = this;
                    h39 = pooledByteBufAllocator.chunkSize;
                    h211(pooledByteBufAllocator, (int)var4_10, h263, h39, (int)var9_18);
                    this.directArenas[i3] = h211;
                    arrayList4.add(h210);
                }
                this.directArenaMetrics = Collections.unmodifiableList(arrayList4);
            } else {
                PooledByteBufAllocator pooledByteBufAllocator = this;
                pooledByteBufAllocator.directArenas = null;
                pooledByteBufAllocator.directArenaMetrics = Collections.emptyList();
            }
            h26 h264 = h262;
            h262 = new h26(this);
            this.metric = h264;
            return;
        }
        throw new IllegalArgumentException("directMemoryCacheAlignment: " + (int)var9_18 + " (expected: power of two)");
    }

    private static <T> h18<T>[] newArenaArray(int n2) {
        return new h18[n2];
    }

    private static int validateAndCalculatePageShifts(int n2) {
        if (n2 >= 4096) {
            int n3 = n2;
            if ((n3 & n3 - 1) == 0) {
                return 31 - Integer.numberOfLeadingZeros(n2);
            }
            throw new IllegalArgumentException("pageSize: " + n2 + " (expected: power of 2)");
        }
        throw new IllegalArgumentException("pageSize: " + n2 + " (expected: " + 4096 + ")");
    }

    private static int validateAndCalculateChunkSize(int n2, int n3) {
        if (n3 <= 14) {
            int n4 = n2;
            for (int i2 = n3; i2 > 0; --i2) {
                if (n4 <= 0x20000000) {
                    n4 <<= 1;
                    continue;
                }
                Object[] objectArray = new Object[3];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = n2;
                objectArray[1] = n3;
                objectArray[2] = 0x40000000;
                throw new IllegalArgumentException(String.format("pageSize (%d) << maxOrder (%d) must not exceed %d", objectArray2));
            }
            return n4;
        }
        throw new IllegalArgumentException("maxOrder: " + n3 + " (expected: 0-14)");
    }

    public static int defaultNumHeapArena() {
        return DEFAULT_NUM_HEAP_ARENA;
    }

    public static int defaultNumDirectArena() {
        return DEFAULT_NUM_DIRECT_ARENA;
    }

    public static int defaultPageSize() {
        return DEFAULT_PAGE_SIZE;
    }

    public static int defaultMaxOrder() {
        return DEFAULT_MAX_ORDER;
    }

    public static boolean defaultUseCacheForAllThreads() {
        return DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    }

    public static boolean defaultPreferDirect() {
        return h3.h2.h7.h33.h19.h9;
    }

    @Deprecated
    public static int defaultTinyCacheSize() {
        return 0;
    }

    public static int defaultSmallCacheSize() {
        return DEFAULT_SMALL_CACHE_SIZE;
    }

    public static int defaultNormalCacheSize() {
        return DEFAULT_NORMAL_CACHE_SIZE;
    }

    public static boolean isDirectMemoryCacheAlignmentSupported() {
        return h3.h2.h7.h33.h19.h5();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static long usedMemory(h18<?>[] h18Array) {
        if (h18Array == null) {
            return -1L;
        }
        long l2 = 0L;
        int n2 = h18Array.length;
        int n3 = 0;
        while (n3 < n2) {
            h18<?> h182 = h18Array[n3];
            long l3 = h182.h31.h2();
            // MONITORENTER : h182
            for (int i2 = 0; i2 < h182.h27.size(); ++i2) {
                Iterator iterator = h182.h27.get(i2).iterator();
                while (iterator.hasNext()) {
                    l3 += (long)((h22)iterator.next()).h2();
                }
            }
            // MONITOREXIT : h182
            if ((l2 += Math.max(0L, l3)) < 0L) {
                return Long.MAX_VALUE;
            }
            ++n3;
        }
        return l2;
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : h182
                throw throwable;
            }
        }
    }

    static {
        int n2;
        boolean bl;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        $assertionsDisabled = PooledByteBufAllocator.class.desiredAssertionStatus() ^ true;
        logger = h6.h2(PooledByteBufAllocator.class.getName());
        int n8 = h34.h2("io.netty.allocator.pageSize", 8192);
        Object var1_1 = null;
        try {
            PooledByteBufAllocator.validateAndCalculatePageShifts(n8);
        }
        catch (Throwable throwable) {
            n8 = 8192;
        }
        DEFAULT_PAGE_SIZE = n8;
        n8 = h34.h2("io.netty.allocator.maxOrder", 11);
        Object var2_3 = null;
        try {
            PooledByteBufAllocator.validateAndCalculateChunkSize(DEFAULT_PAGE_SIZE, n8);
        }
        catch (Throwable throwable) {
            n8 = 11;
        }
        DEFAULT_MAX_ORDER = n8;
        Runtime runtime = Runtime.getRuntime();
        int n9 = DEFAULT_PAGE_SIZE;
        int n10 = n9 << n8;
        long l2 = h3.h2.h7.h18.h2() * 2;
        long l3 = n10;
        DEFAULT_NUM_HEAP_ARENA = n7 = Math.max(0, h34.h2("io.netty.allocator.numHeapArenas", (int)Math.min(l2, runtime.maxMemory() / l3 / 2L / 3L)));
        DEFAULT_NUM_DIRECT_ARENA = n10 = Math.max(0, h34.h2("io.netty.allocator.numDirectArenas", (int)Math.min(l2, h3.h2.h7.h33.h19.h19 / l3 / 2L / 3L)));
        DEFAULT_SMALL_CACHE_SIZE = n6 = h34.h2("io.netty.allocator.smallCacheSize", 256);
        DEFAULT_NORMAL_CACHE_SIZE = n5 = h34.h2("io.netty.allocator.normalCacheSize", 64);
        DEFAULT_MAX_CACHED_BUFFER_CAPACITY = n4 = h34.h2("io.netty.allocator.maxCachedBufferCapacity", 32768);
        DEFAULT_CACHE_TRIM_INTERVAL = n3 = h34.h2("io.netty.allocator.cacheTrimInterval", 8192);
        if (h34.h2("io.netty.allocation.cacheTrimIntervalMillis")) {
            logger.warn("-Dio.netty.allocation.cacheTrimIntervalMillis is deprecated, use -Dio.netty.allocator.cacheTrimIntervalMillis");
            DEFAULT_CACHE_TRIM_INTERVAL_MILLIS = h34.h2("io.netty.allocator.cacheTrimIntervalMillis") ? h34.h2("io.netty.allocator.cacheTrimIntervalMillis", 0L) : h34.h2("io.netty.allocation.cacheTrimIntervalMillis", 0L);
        } else {
            DEFAULT_CACHE_TRIM_INTERVAL_MILLIS = h34.h2("io.netty.allocator.cacheTrimIntervalMillis", 0L);
        }
        DEFAULT_USE_CACHE_FOR_ALL_THREADS = bl = h34.h2("io.netty.allocator.useCacheForAllThreads", true);
        DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT = h34.h2("io.netty.allocator.directMemoryCacheAlignment", 0);
        DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK = n2 = h34.h2("io.netty.allocator.maxCachedByteBuffersPerChunk", 1023);
        h5 h52 = logger;
        if (h52.isDebugEnabled()) {
            h52.debug("-Dio.netty.allocator.numHeapArenas: {}", (Object)n7);
            h52.debug("-Dio.netty.allocator.numDirectArenas: {}", (Object)n10);
            if (var1_1 == null) {
                h52.debug("-Dio.netty.allocator.pageSize: {}", (Object)n9);
            } else {
                h52.debug("-Dio.netty.allocator.pageSize: {}", (Object)n9, (Object)var1_1);
            }
            if (var2_3 == null) {
                h52.debug("-Dio.netty.allocator.maxOrder: {}", (Object)n8);
            } else {
                h52.debug("-Dio.netty.allocator.maxOrder: {}", (Object)n8, (Object)var2_3);
            }
            h5 h53 = h52;
            h52.debug("-Dio.netty.allocator.chunkSize: {}", (Object)(n9 << n8));
            h52.debug("-Dio.netty.allocator.smallCacheSize: {}", (Object)n6);
            h52.debug("-Dio.netty.allocator.normalCacheSize: {}", (Object)n5);
            h52.debug("-Dio.netty.allocator.maxCachedBufferCapacity: {}", (Object)n4);
            h53.debug("-Dio.netty.allocator.cacheTrimInterval: {}", (Object)n3);
            h53.debug("-Dio.netty.allocator.cacheTrimIntervalMillis: {}", (Object)DEFAULT_CACHE_TRIM_INTERVAL_MILLIS);
            h52.debug("-Dio.netty.allocator.useCacheForAllThreads: {}", (Object)bl);
            h52.debug("-Dio.netty.allocator.maxCachedByteBuffersPerChunk: {}", (Object)n2);
        }
        DEFAULT = new PooledByteBufAllocator(h3.h2.h7.h33.h19.h9);
    }

    @Override
    public h10 newHeapBuffer(int n2, int n3) {
        Object object = (h24)((PooledByteBufAllocator)((Object)h252)).threadCache.h2();
        h18<byte[]> h182 = ((h24)object).h2;
        if (h182 != null) {
            h18<byte[]> h183 = h182;
            h25<byte[]> h252 = h183.h4(n3);
            h183.h2((h24)object, h252, n2);
            object = h252;
        } else if (h3.h2.h7.h33.h19.h5()) {
            g g2;
            object = g2;
            g2 = new g((h11)((Object)h252), n2, n3);
        } else {
            d d2;
            object = d2;
            d2 = new d((h11)((Object)h252), n2, n3);
        }
        return AbstractByteBufAllocator.toLeakAwareBuffer((h10)object);
    }

    @Override
    public h10 newDirectBuffer(int n2, int n3) {
        Object object = (h24)((PooledByteBufAllocator)((Object)h252)).threadCache.h2();
        h18<ByteBuffer> h182 = ((h24)object).h3;
        if (h182 != null) {
            h18<ByteBuffer> h183 = h182;
            h25<ByteBuffer> h252 = h183.h4(n3);
            h183.h2((h24)object, h252, n2);
            object = h252;
        } else if (h3.h2.h7.h33.h19.h5()) {
            if (h3.h2.h7.h33.h19.h17) {
                h h38;
                object = h38;
                h38 = new h((h11)((Object)h252), n2, n3);
            } else {
                f f2;
                object = f2;
                f2 = new f((h11)((Object)h252), n2, n3);
            }
        } else {
            b b2;
            object = b2;
            b2 = new b((h11)((Object)h252), n2, n3);
        }
        return AbstractByteBufAllocator.toLeakAwareBuffer((h10)object);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return this.directArenas != null;
    }

    @Deprecated
    public boolean hasThreadLocalCache() {
        return this.threadCache.h4();
    }

    @Deprecated
    public void freeThreadLocalCache() {
        h3 h38 = this.threadCache;
        h38.getClass();
        h38.h3(h3.h2.h7.h33.h10.h3());
    }

    public h26 metric() {
        return this.metric;
    }

    @Deprecated
    public int numHeapArenas() {
        return this.heapArenaMetrics.size();
    }

    @Deprecated
    public int numDirectArenas() {
        return this.directArenaMetrics.size();
    }

    @Deprecated
    public List<Object> heapArenas() {
        return this.heapArenaMetrics;
    }

    @Deprecated
    public List<Object> directArenas() {
        return this.directArenaMetrics;
    }

    @Deprecated
    public int numThreadLocalCaches() {
        h18<Object>[] h18Array = this.heapArenas;
        if (this.heapArenas == null) {
            h18Array = this.directArenas;
        }
        if (h18Array == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = h18Array.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += h18Array[i2].h35.get();
        }
        return n2;
    }

    @Deprecated
    public int tinyCacheSize() {
        return 0;
    }

    @Deprecated
    public int smallCacheSize() {
        return this.smallCacheSize;
    }

    @Deprecated
    public int normalCacheSize() {
        return this.normalCacheSize;
    }

    @Deprecated
    public final int chunkSize() {
        return this.chunkSize;
    }

    public final long usedHeapMemory() {
        return PooledByteBufAllocator.usedMemory(this.heapArenas);
    }

    public final long usedDirectMemory() {
        return PooledByteBufAllocator.usedMemory(this.directArenas);
    }

    public final h24 threadCache() {
        h24 h242 = (h24)((PooledByteBufAllocator)((Object)h242)).threadCache.h2();
        if (!$assertionsDisabled && h242 == null) {
            throw new AssertionError();
        }
        return h242;
    }

    public boolean trimCurrentThreadCache() {
        Object object = ((PooledByteBufAllocator)object).threadCache;
        object.getClass();
        h3.h2.h7.h33.h10 h102 = h3.h2.h7.h33.h10.h3();
        if (h102 == null || (object = h102.h2(((h19)object).h2)) == h3.h2.h7.h33.h10.h15) {
            object = null;
        }
        object = (h24)object;
        if (object != null) {
            Object object2 = object;
            h24.h2(((h24)object2).h5);
            h24.h2(((h24)object2).h7);
            h24.h2(((h24)object2).h4);
            h24.h2(((h24)object2).h6);
            return true;
        }
        return false;
    }

    public String dumpStats() {
        int n2;
        h18<Object>[] h18Array;
        h18<byte[]>[] h18Array2 = h18Array3.heapArenas;
        int n3 = h18Array3.heapArenas == null ? 0 : h18Array2.length;
        StringBuilder stringBuilder = new StringBuilder(512).append(n3).append(" heap arena(s):").append(h33.h2);
        if (n3 > 0) {
            h18Array = h18Array3.heapArenas;
            n2 = h18Array3.heapArenas.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(h18Array[i2]);
            }
        }
        h18Array = h18Array3.directArenas;
        int n4 = h18Array3.directArenas == null ? 0 : h18Array.length;
        stringBuilder.append(n4).append(" direct arena(s):").append(h33.h2);
        if (n4 > 0) {
            h18<ByteBuffer>[] h18Array3 = h18Array3.directArenas;
            n4 = h18Array3.directArenas.length;
            for (n2 = 0; n2 < n4; ++n2) {
                stringBuilder.append(h18Array3[n2]);
            }
        }
        return stringBuilder.toString();
    }

    public final class h3
    extends h19<h24> {
        public final boolean h4;

        public h3(boolean bl) {
            this.h4 = bl;
        }

        @Override
        public void h2(Object object) throws Exception {
            ((h24)object).h2(false);
        }

        @Override
        public Object h3() throws Exception {
            h3 h38 = this;
            synchronized (h38) {
                Object object;
                block16: {
                    block15: {
                        h24 h242;
                        h18<ByteBuffer> h182;
                        h18<byte[]> h183;
                        block14: {
                            h24 h243;
                            h183 = h38.h2(h38.PooledByteBufAllocator.this.heapArenas);
                            h182 = h38.h2(h38.PooledByteBufAllocator.this.directArenas);
                            object = Thread.currentThread();
                            if (h38.h4) break block14;
                            if (object instanceof h21) break block14;
                            h3 h39 = this;
                            object = h243;
                            h243 = new h24(h183, h182, 0, 0, 0, 0);
                            // ** MonitorExit[v2] (shouldn't be in output)
                            break block16;
                        }
                        object = h242;
                        h18<byte[]> h184 = h183;
                        h18<ByteBuffer> h185 = h182;
                        h3 h310 = this;
                        h3 h311 = h310;
                        int n2 = h310.PooledByteBufAllocator.this.smallCacheSize;
                        h242 = new h24(h184, h185, n2, h311.PooledByteBufAllocator.this.normalCacheSize, DEFAULT_MAX_CACHED_BUFFER_CAPACITY, DEFAULT_CACHE_TRIM_INTERVAL);
                        if (DEFAULT_CACHE_TRIM_INTERVAL_MILLIS <= 0L) break block15;
                        h15 h152 = h35.h2.h2();
                        if (h152 == null) break block15;
                        h152.scheduleAtFixedRate(PooledByteBufAllocator.this.trimTask, DEFAULT_CACHE_TRIM_INTERVAL_MILLIS, DEFAULT_CACHE_TRIM_INTERVAL_MILLIS, TimeUnit.MILLISECONDS);
                    }
                    // ** MonitorExit[this] (shouldn't be in output)
                }
                return object;
            }
        }

        public final <T> h18<T> h2(h18<T>[] h18Array) {
            if (h18Array != null && h18Array.length != 0) {
                Object object = h18Array[0];
                for (int i2 = 1; i2 < h18Array.length; ++i2) {
                    Object object2 = h18Array[i2];
                    if (((h18)object2).h35.get() >= ((h18)object).h35.get()) {
                        object2 = object;
                    }
                    object = object2;
                }
                return object;
            }
            return null;
        }
    }
}

