/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import h3.h2.h7.h20;
import h3.h2.h7.h25;
import h3.h2.h7.h26;
import h3.h2.h7.h33.b.h5;
import h3.h2.h7.h33.b.h6;
import h3.h2.h7.h33.h33;
import io.netty.util.ReferenceCounted;
import java.security.AccessController;

public final class ReferenceCountUtil {
    private static final h5 logger = h6.h2(ReferenceCountUtil.class.getName());

    public static <T> T retain(T t2) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).retain();
        }
        return t2;
    }

    public static <T> T retain(T t2, int n2) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).retain(n2);
        }
        return t2;
    }

    public static <T> T touch(T t2) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).touch();
        }
        return t2;
    }

    public static <T> T touch(T t2, Object object) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).touch(object);
        }
        return t2;
    }

    public static boolean release(Object object) {
        if (object instanceof ReferenceCounted) {
            return ((ReferenceCounted)object).release();
        }
        return false;
    }

    public static boolean release(Object object, int n2) {
        if (object instanceof ReferenceCounted) {
            return ((ReferenceCounted)object).release(n2);
        }
        return false;
    }

    public static void safeRelease(Object object) {
        try {
            ReferenceCountUtil.release(object);
        }
        catch (Throwable throwable) {
            logger.warn("Failed to release a message: {}", object, (Object)throwable);
        }
    }

    public static void safeRelease(Object object, int n2) {
        block2: {
            try {
                ReferenceCountUtil.release(object, n2);
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block2;
                Object[] objectArray = new Object[3];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = object;
                objectArray[1] = n2;
                objectArray[2] = throwable;
                logger.warn("Failed to release a message: {} (decrement: {})", objectArray2);
            }
        }
    }

    @Deprecated
    public static <T> T releaseLater(T t2) {
        return ReferenceCountUtil.releaseLater(t2, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static <T> T releaseLater(T t2, int n2) {
        h2 h210;
        if (!(t2 instanceof ReferenceCounted)) return t2;
        Thread thread = Thread.currentThread();
        h2 h211 = h210;
        h210 = new h2((ReferenceCounted)t2, n2);
        Object object = "thread";
        if (thread == null) throw new NullPointerException((String)object);
        if (!thread.isAlive()) throw new IllegalArgumentException("thread must be alive.");
        h26.h4.add(new h26.h2(thread, h211, true));
        if (!h26.h6.compareAndSet(false, true)) return t2;
        object = h26.h3.newThread(h26.h5);
        AccessController.doPrivileged(new h25((Thread)object));
        ((Thread)object).start();
        return t2;
    }

    public static int refCnt(Object object) {
        return object instanceof ReferenceCounted ? ((ReferenceCounted)object).refCnt() : -1;
    }

    private ReferenceCountUtil() {
    }

    static {
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "touch";
        h20.h2(ReferenceCountUtil.class, stringArray2);
    }

    public static final class h2
    implements Runnable {
        public final ReferenceCounted h4;
        public final int h5;

        public h2(ReferenceCounted referenceCounted, int n2) {
            this.h4 = referenceCounted;
            this.h5 = n2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                if (!this.h4.release(this.h5)) {
                    logger.warn("Non-zero refCnt: {}", (Object)this);
                    return;
                }
                logger.debug("Released: {}", (Object)this);
                return;
            }
            catch (Exception exception) {
                logger.warn("Failed to release an object: {}", (Object)this.h4, (Object)exception);
            }
        }

        public String toString() {
            return h33.h2(this.h4) + ".release(" + this.h5 + ") refCnt: " + this.h4.refCnt();
        }
    }
}

