package com.transsin.networkmonitor

/**
 * @Author:huangxiushuo
 * @Date: 2023-05-24 16:28
 * @Description:
 */
object ErrorCode {
    const val CODE_UNKNOWN = 480
    const val MSG_UNKNOWN = "Unknown"
    const val MSG_FAKE_NETWORK = "Fake Network"
    const val MSG_NETWORK_DISCONNECT = "Network disconnect"
    const val CODE_CONNECT_FAILED = 101
    const val CODE_REQUEST_FAILED = 102
    const val CODE_RESPONSE_FAILED = 103
    const val CODE_CALL_FAILED = 104
    /** 未知主机异常，例如域名解析失败等  */
    const val CODE_UNKNOWN_HOST = 1005
    /** 无法到达主机异常，例如网络中断等  */
    const val CODE_NO_ROUTE_TO_HOST = 1006
    /** 协议异常，例如不支持的协议等  */
    const val CODE_PROTOCOL_ERROR = 1007
    /** 网络超时  */
    const val CODE_SOCKET_TIME_OUT = 1008
    /** SSL握手异常  */
    const val CODE_SSL_HANDSHAKE_ERROR = 1009
    const val CODE_NETWORK_DISCONNECT = 1010
    const val CODE_CONNECT_ERROR = 1011
    const val CODE_NO_NETWORK = 1020
    const val CODE_FAKE_NETWORK = 1021
    const val CODE_BIND_EXCEPTION = 1010
    const val CODE_PORT_UNREACHABLE_EXCEPTION  = 1012
    const val CODE_CONNECT_TIMEOUT_EXCEPTION = 1013
    const val CODE_SSL_KEY_EXCEPTION = 1014
    const val CODE_SSL_PEER_UNVERIFIED_EXCEPTION = 1015
    const val CODE_SSL_PROTOCOL_EXCEPTION = 1016
    const val CODE_FILE_SYSTEM_EXCEPTION = 1017
    const val CODE_OBJECT_STREAM_EXCEPTION = 1018
    const val CODE_ASYNCHRONOUS_CLOSE_EXCEPTION = 1019
    const val CODE_MALFORMED_INPUT_EXCEPTION = 1043
    const val CODE_UNMAPPABLE_CHARACTER_EXCEPTION = 1044
    const val CODE_JAR_EXCEPTION = 1022
    const val CODE_CHAR_CONVERSION_EXCEPTION = 1023
    const val CODE_BASE64_DATA_EXCEPTION = 1024
    const val CODE_CONNECTION_SHUTDOWN_EXCEPTION = 1025
    const val CODE_EOF_EXCEPTION = 1027
    const val CODE_FILE_DESCRIPTOR_DETACHED_EXCEPTION = 1028
    const val CODE_FILE_LOCK_INTERRUPTION_EXCEPTION = 1029
    const val CODE_FILE_NOT_FOUND_EXCEPTION = 1030
    const val CODE_HTTP_RETRY_EXCEPTION = 1031
    const val CODE_INVALID_PROPERTIES_FORMAT_EXCEPTION = 1033
    const val CODE_MALFORMED_JSON_EXCEPTION = 1034
    const val CODE_MALFORMED_URL_EXCEPTION = 1035
    const val CODE_STREAM_RESET_EXCEPTION = 1037
    const val CODE_SYNC_FAILED_EXCEPTION = 1038
    const val CODE_UTF_DATA_FORMAT_EXCEPTION = 1039
    const val CODE_UNKNOWN_SERVICE_EXCEPTION = 1040
    const val CODE_UNSUPPORTED_ENCODING_EXCEPTION = 1042
}