package com.transsin.networkmonitor

import android.app.Application
import android.content.Context
import android.net.ConnectivityManager
import android.net.ConnectivityManager.NetworkCallback
import android.net.Network
import android.net.NetworkCapabilities
import android.net.NetworkRequest
import android.os.Build
import android.os.SystemClock
import com.transsin.networkmonitor.Consts.APP_ID
import com.transsin.networkmonitor.Consts.CHANNEL
import com.transsion.ga.AthenaAnalytics

/**
 * @Author:huangxiushuo
 * @Date: 2023-05-17 10:46
 * @Description:
 */
object NetworkMonitor {


    internal var isTest: Boolean = false
    internal var isNetworkConnected: Boolean = false
    internal var isFakeNetwork: Boolean = false
    internal var isNetInitDone: Boolean = false
    internal var initStartTime: Long = 0

    /**
     * NetworkMonitor初始化方法
     * @param application
     * @param hosts 需要监控的域名
     * @param isTest 是否测试
     */
    @JvmStatic
    fun init(application: Application, hosts: Array<String> = arrayOf(), isTest: Boolean = false) {
        this.isTest = isTest
        AthenaAnalytics.init(application, CHANNEL, APP_ID, isTest, false)
//        AthenaAnalytics.setTest(isTest)
        HostMatcher.setHosts(hosts)
        registerNetworkCallback(application)
        initStartTime = SystemClock.uptimeMillis()
    }

    @JvmStatic
    fun init(application: Application, isTest: Boolean = false) {
        this.init(application, arrayOf(), isTest)
    }

    private fun registerNetworkCallback(context: Context) {
        val connectivityManager =
            context.getSystemService(Context.CONNECTIVITY_SERVICE) as? ConnectivityManager ?: return
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            val request = NetworkRequest.Builder().build()
            connectivityManager.registerNetworkCallback(request, object : NetworkCallback() {
                override fun onCapabilitiesChanged(
                    network: Network,
                    networkCapabilities: NetworkCapabilities
                ) {
                    super.onCapabilitiesChanged(network, networkCapabilities)
                    val isNetworkValid =
                        networkCapabilities.hasCapability(NetworkCapabilities.NET_CAPABILITY_VALIDATED)
                    isNetworkConnected =
                        networkCapabilities.hasCapability(NetworkCapabilities.NET_CAPABILITY_INTERNET)
                    isFakeNetwork = isNetworkConnected && !isNetworkValid
                    isNetInitDone = true
                    Utils.LOG.d(
                        Utils.GLOBAL_TAG,
                        "isNetworkConnected : ${isNetworkConnected},  isFakeNetwork : $isFakeNetwork"
                    )
                }

                override fun onAvailable(network: Network) {
                    super.onAvailable(network)
                    Utils.LOG.d(Utils.GLOBAL_TAG, "onAvailable : ${network}")
                }

                override fun onUnavailable() {
                    super.onUnavailable()
                    Utils.LOG.d(Utils.GLOBAL_TAG, "onUnavailable")
                }

                override fun onBlockedStatusChanged(network: Network, blocked: Boolean) {
                    super.onBlockedStatusChanged(network, blocked)
                    Utils.LOG.d(Utils.GLOBAL_TAG, "onBlockedStatusChanged")
                }

                override fun onLost(network: Network) {
                    super.onLost(network)
                    Utils.LOG.d(Utils.GLOBAL_TAG, "onLost")
                    isNetworkConnected = false
                }

                override fun onLosing(network: Network, maxMsToLive: Int) {
                    super.onLosing(network, maxMsToLive)
                    Utils.LOG.d(Utils.GLOBAL_TAG, "onLosing")
                    isNetworkConnected = false
                }
            })
        }
    }

}