/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor;

import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import androidx.core.os.BundleKt;
import com.transsin.networkmonitor.MonitorData;
import com.transsin.networkmonitor.stat.DataMonitorHelper;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\n\u0010\n\u001a\u00020\b*\u00020\t\u001a\u000e\u0010\u000b\u001a\u00020\t*\u00060\fj\u0002`\r\u001a\n\u0010\u000e\u001a\u00020\b*\u00020\u0006\u00a8\u0006\u000f"}, d2={"realtime", "", "realtimeDiff", "time", "asBundle", "Landroid/os/Bundle;", "Lcom/transsin/networkmonitor/MonitorData;", "printErrEvent", "", "", "printEvent", "shortMsg", "Ljava/lang/Exception;", "Lkotlin/Exception;", "track", "lib-networkmonitor_release"})
public final class ExtensionKt {
    public static final void printEvent(@NotNull String $this$printEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$printEvent, (String)"<this>");
        Log.d((String)"NetworkMonitor", (String)("=======/ " + $this$printEvent + " /======="));
    }

    public static final void printErrEvent(@NotNull String $this$printErrEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$printErrEvent, (String)"<this>");
        Log.e((String)"NetworkMonitor", (String)("=======/ " + $this$printErrEvent + " /======="));
    }

    @NotNull
    public static final Bundle asBundle(@NotNull MonitorData $this$asBundle) {
        Intrinsics.checkNotNullParameter((Object)$this$asBundle, (String)"<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"usage", (Object)$this$asBundle.getUsage()), TuplesKt.to((Object)"time", (Object)("" + $this$asBundle.getDnsTime() + '|' + $this$asBundle.getTcpTime() + '|' + $this$asBundle.getSslTime() + '|' + $this$asBundle.getSendTime() + '|' + $this$asBundle.getReqTime() + '|' + $this$asBundle.getServerTime() + '|' + $this$asBundle.getWaitTime() + '|' + $this$asBundle.getRecTime())), TuplesKt.to((Object)"cdn", (Object)("" + $this$asBundle.getCdnDownTime() + '|' + $this$asBundle.getCdnReqTime() + '|' + $this$asBundle.getCdnSpeed() + '|' + $this$asBundle.getCdnProvider())), TuplesKt.to((Object)"http", (Object)($this$asBundle.getTlsVersion() + '|' + $this$asBundle.getProtocol() + '|' + $this$asBundle.getRequestDowngrade() + '|' + $this$asBundle.getContentEncoding())), TuplesKt.to((Object)"size", (Object)("" + $this$asBundle.getReqBodySize() + '|' + $this$asBundle.getResBodySize())), TuplesKt.to((Object)"httplib", (Object)$this$asBundle.getHttpType()), TuplesKt.to((Object)"server_api", (Object)$this$asBundle.getServerApi()), TuplesKt.to((Object)"error_code", (Object)$this$asBundle.getErrorCode()), TuplesKt.to((Object)"error_msg", (Object)$this$asBundle.getErrorMsg()), TuplesKt.to((Object)"channel", (Object)$this$asBundle.getChannel()), TuplesKt.to((Object)"call_id", (Object)$this$asBundle.getCallId()), TuplesKt.to((Object)"call_result_code", (Object)$this$asBundle.getCallResultCode()), TuplesKt.to((Object)"complete_api", (Object)$this$asBundle.getCompleteApi()), TuplesKt.to((Object)"ip_address", (Object)$this$asBundle.getIpAddr()), TuplesKt.to((Object)"country", (Object)$this$asBundle.getCountry()), TuplesKt.to((Object)"host", (Object)$this$asBundle.getHost()), TuplesKt.to((Object)"is_offline", (Object)$this$asBundle.getOfflineAd()), TuplesKt.to((Object)"compare_tag", (Object)$this$asBundle.getCompareTag()), TuplesKt.to((Object)"step", (Object)$this$asBundle.getStep())};
        return BundleKt.bundleOf((Pair[])pairArray);
    }

    public static final void track(@NotNull MonitorData $this$track) {
        Intrinsics.checkNotNullParameter((Object)$this$track, (String)"<this>");
        Log.d((String)"NetworkMonitor", (String)$this$track.toString());
        String event = "process";
        DataMonitorHelper.INSTANCE.commitNetworkStat(event, ExtensionKt.asBundle($this$track));
    }

    @NotNull
    public static final String shortMsg(@NotNull Exception $this$shortMsg) {
        Intrinsics.checkNotNullParameter((Object)$this$shortMsg, (String)"<this>");
        if ($this$shortMsg.getMessage() == null) {
            return "";
        }
        String string = $this$shortMsg.getMessage();
        Intrinsics.checkNotNull((Object)string);
        int endIndex = Integer.min(string.length(), 200);
        String string2 = $this$shortMsg.getMessage();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = string2.substring(0, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string3;
    }

    public static final long realtime() {
        return SystemClock.elapsedRealtime();
    }

    public static final long realtimeDiff(long time) {
        return ExtensionKt.realtime() - time;
    }
}

