/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor.stat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import com.shalltry.aisearch.core.utils.LogUtil;
import com.transsin.networkmonitor.Utils;
import com.transsin.networkmonitor.stat.DataMonitorFactory;
import com.transsin.networkmonitor.stat.IMonitor;
import com.transsin.networkmonitor.stat.MonitorType;
import com.transsin.util.GlobalUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u001c\u0010\u0011\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u001c\u0010\u0012\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J;\u0010\u0013\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0007J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/transsin/networkmonitor/stat/DataMonitorHelper;", "", "()V", "TAG", "", "mFirebaseMonitor", "Lcom/transsin/networkmonitor/stat/IMonitor;", "mInit", "Ljava/util/concurrent/atomic/AtomicBoolean;", "mRealDataMonitor", "monitorType", "Lcom/transsin/networkmonitor/stat/MonitorType;", "commitBootStat", "", "event", "bundle", "Landroid/os/Bundle;", "commitCustomStat", "commitNetworkStat", "commitStat", "rate", "", "type", "(Ljava/lang/String;Landroid/os/Bundle;Ljava/lang/Integer;Ljava/lang/Integer;)V", "init", "context", "Landroid/content/Context;", "appId", "isReport", "", "setDefaultRate", "lib-networkmonitor_release"})
public final class DataMonitorHelper {
    @NotNull
    public static final DataMonitorHelper INSTANCE = new DataMonitorHelper();
    @NotNull
    public static final String TAG = "netInspect:DataMonitorHelper";
    @NotNull
    private static MonitorType monitorType = MonitorType.FIREBASE_MONITOR;
    @NotNull
    private static AtomicBoolean mInit = new AtomicBoolean(false);
    @Nullable
    private static IMonitor mFirebaseMonitor;
    @Nullable
    private static IMonitor mRealDataMonitor;

    private DataMonitorHelper() {
    }

    @SuppressLint(value={"MissingPermission"})
    public final void init(@NotNull Context context, @NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        try {
            String string = context.getPackageName();
            if (string == null) {
                string = "";
            }
            GlobalUtils.INSTANCE.setPkgName(string);
            GlobalUtils.INSTANCE.setContext(context);
            if (mInit.compareAndSet(false, true)) {
                mFirebaseMonitor = DataMonitorFactory.INSTANCE.create(context, appId, MonitorType.FIREBASE_MONITOR);
                mRealDataMonitor = DataMonitorFactory.INSTANCE.create(context, appId, MonitorType.REAL_DATA_MONITOR);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public final void commitNetworkStat(@Nullable String event, @Nullable Bundle bundle) {
        int rate = GlobalUtils.INSTANCE.getConfigData().getNetworkRate();
        int type = GlobalUtils.INSTANCE.getConfigData().getNetworkChannel();
        this.commitStat(event, bundle, rate, type);
    }

    public static /* synthetic */ void commitNetworkStat$default(DataMonitorHelper dataMonitorHelper, String string, Bundle bundle, int n, Object object) {
        if ((n & 2) != 0) {
            bundle = new Bundle();
        }
        dataMonitorHelper.commitNetworkStat(string, bundle);
    }

    public final void commitBootStat(@Nullable String event, @Nullable Bundle bundle) {
        int rate = GlobalUtils.INSTANCE.getConfigData().getBootRate();
        int type = GlobalUtils.INSTANCE.getConfigData().getBootChannel();
        this.commitStat(event, bundle, rate, type);
    }

    public static /* synthetic */ void commitBootStat$default(DataMonitorHelper dataMonitorHelper, String string, Bundle bundle, int n, Object object) {
        if ((n & 2) != 0) {
            bundle = new Bundle();
        }
        dataMonitorHelper.commitBootStat(string, bundle);
    }

    public final void commitCustomStat(@Nullable String event, @Nullable Bundle bundle) {
        int rate = GlobalUtils.INSTANCE.getConfigData().getCustomRate();
        int type = GlobalUtils.INSTANCE.getConfigData().getCustomChannel();
        this.commitStat(event, bundle, rate, type);
    }

    public static /* synthetic */ void commitCustomStat$default(DataMonitorHelper dataMonitorHelper, String string, Bundle bundle, int n, Object object) {
        if ((n & 2) != 0) {
            bundle = new Bundle();
        }
        dataMonitorHelper.commitCustomStat(string, bundle);
    }

    private final void commitStat(String event, Bundle bundle, Integer rate, Integer type) {
        try {
            CharSequence charSequence = event;
            if (charSequence == null || charSequence.length() == 0) {
                return;
            }
            Bundle bundle2 = bundle;
            if (bundle2 != null) {
                bundle2.putInt("net", GlobalUtils.INSTANCE.getCurrentNet());
            }
            Bundle bundle3 = bundle;
            if (bundle3 != null) {
                bundle3.putString("vn", Utils.getVersionName());
            }
            Bundle bundle4 = bundle;
            if (bundle4 != null) {
                bundle4.putString("pkg", GlobalUtils.INSTANCE.getPkgName());
            }
            LogUtil.INSTANCE.d(TAG, "event=" + event + " , bundle =" + bundle);
            Integer n = rate;
            if (!this.isReport(n != null ? n : 0)) {
                LogUtil.e$default((LogUtil)LogUtil.INSTANCE, (String)TAG, (String)("rate = " + rate + ", discard."), null, (int)4, null);
                return;
            }
            Integer n2 = type;
            int n3 = 1;
            if (n2 != null && n2 == n3) {
                IMonitor iMonitor = mFirebaseMonitor;
                if (iMonitor != null) {
                    iMonitor.commitStat(event, bundle);
                }
            } else {
                IMonitor iMonitor = mRealDataMonitor;
                if (iMonitor != null) {
                    iMonitor.commitStat(event, bundle);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static /* synthetic */ void commitStat$default(DataMonitorHelper dataMonitorHelper, String string, Bundle bundle, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            bundle = new Bundle();
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 2;
        }
        dataMonitorHelper.commitStat(string, bundle, n, n2);
    }

    public final boolean isReport(int rate) {
        int randomValue = Random.Default.nextInt(1, 1001);
        LogUtil.INSTANCE.d(TAG, "rate = " + rate + ", randomValue=" + randomValue + '.');
        return randomValue <= rate;
    }

    public final void setDefaultRate(int rate) {
        GlobalUtils.INSTANCE.setDefaultRate(rate);
    }
}

