package com.transsin.networkmonitor

import android.os.ParcelFileDescriptor
import android.util.Base64DataException
import android.util.MalformedJsonException
import okhttp3.internal.http2.ConnectionShutdownException
import okhttp3.internal.http2.StreamResetException
import org.apache.http.conn.ConnectTimeoutException
import org.chromium.net.NetworkException
import java.io.*
import java.net.*
import java.nio.channels.AsynchronousCloseException
import java.nio.channels.FileLockInterruptionException
import java.nio.charset.MalformedInputException
import java.nio.charset.UnmappableCharacterException
import java.util.*
import java.util.jar.JarException
import javax.net.ssl.SSLHandshakeException
import javax.net.ssl.SSLKeyException
import javax.net.ssl.SSLPeerUnverifiedException
import javax.net.ssl.SSLProtocolException

/**
 * @Author lihao
 * @Time 2024/3/8 10:30
 * @Company Transsion
 * desc
 */
object CodeUtil {
    fun fetchCode(httpCode: Int, ioe: IOException?): Int {
        var code = httpCode
        if (httpCode == ErrorCode.CODE_UNKNOWN) {
            code = when (ioe) {
                is SocketTimeoutException -> ErrorCode.CODE_SOCKET_TIME_OUT
                is UnknownHostException -> ErrorCode.CODE_UNKNOWN_HOST
                is NoRouteToHostException -> ErrorCode.CODE_NO_ROUTE_TO_HOST
                is ProtocolException -> ErrorCode.CODE_PROTOCOL_ERROR
                is SSLHandshakeException -> ErrorCode.CODE_SSL_HANDSHAKE_ERROR
                is ConnectException -> ErrorCode.CODE_CONNECT_ERROR
                is BindException -> ErrorCode.CODE_BIND_EXCEPTION
                is PortUnreachableException -> ErrorCode.CODE_PORT_UNREACHABLE_EXCEPTION
                is ConnectTimeoutException -> ErrorCode.CODE_CONNECT_TIMEOUT_EXCEPTION
                is SSLKeyException -> ErrorCode.CODE_SSL_KEY_EXCEPTION
                is SSLPeerUnverifiedException -> ErrorCode.CODE_SSL_PEER_UNVERIFIED_EXCEPTION
                is SSLProtocolException -> ErrorCode.CODE_SSL_PROTOCOL_EXCEPTION
                is FileSystemException -> ErrorCode.CODE_FILE_SYSTEM_EXCEPTION
                is ObjectStreamException -> ErrorCode.CODE_OBJECT_STREAM_EXCEPTION
                is AsynchronousCloseException -> ErrorCode.CODE_ASYNCHRONOUS_CLOSE_EXCEPTION
                is MalformedInputException -> ErrorCode.CODE_MALFORMED_INPUT_EXCEPTION
                is UnmappableCharacterException -> ErrorCode.CODE_UNMAPPABLE_CHARACTER_EXCEPTION
                is JarException -> ErrorCode.CODE_JAR_EXCEPTION
                is CharConversionException -> ErrorCode.CODE_CHAR_CONVERSION_EXCEPTION
                is Base64DataException -> ErrorCode.CODE_BASE64_DATA_EXCEPTION
                is ConnectionShutdownException -> ErrorCode.CODE_CONNECTION_SHUTDOWN_EXCEPTION
                is EOFException -> ErrorCode.CODE_EOF_EXCEPTION
                is ParcelFileDescriptor.FileDescriptorDetachedException -> ErrorCode.CODE_FILE_DESCRIPTOR_DETACHED_EXCEPTION
                is FileLockInterruptionException -> ErrorCode.CODE_FILE_LOCK_INTERRUPTION_EXCEPTION
                is FileNotFoundException -> ErrorCode.CODE_FILE_NOT_FOUND_EXCEPTION
                is HttpRetryException -> ErrorCode.CODE_HTTP_RETRY_EXCEPTION
                is InvalidPropertiesFormatException -> ErrorCode.CODE_INVALID_PROPERTIES_FORMAT_EXCEPTION
                is MalformedJsonException -> ErrorCode.CODE_MALFORMED_JSON_EXCEPTION
                is MalformedURLException -> ErrorCode.CODE_MALFORMED_URL_EXCEPTION
                is StreamResetException -> ErrorCode.CODE_STREAM_RESET_EXCEPTION
                is SyncFailedException -> ErrorCode.CODE_SYNC_FAILED_EXCEPTION
                is UTFDataFormatException -> ErrorCode.CODE_UTF_DATA_FORMAT_EXCEPTION
                is UnknownServiceException -> ErrorCode.CODE_UNKNOWN_SERVICE_EXCEPTION
                is UnsupportedEncodingException -> ErrorCode.CODE_UNSUPPORTED_ENCODING_EXCEPTION
                else -> {
                    if (ioe?.message == "Canceled"){
                        ErrorCode.CODE_CANCEL
                    }else{
                        ErrorCode.CODE_UNKNOWN
                    }
                }
            }
        }
        return code
    }

    fun fetchCronetException(httpCode: Int, ioe: NetworkException?, isCancel: Boolean): Int {
        var code = httpCode
        if (httpCode == ErrorCode.CODE_UNKNOWN) {
            code = when (ioe?.errorCode) {
                NetworkException.ERROR_HOSTNAME_NOT_RESOLVED -> ErrorCode.CODE_UNKNOWN_HOST
                NetworkException.ERROR_INTERNET_DISCONNECTED -> ErrorCode.CODE_NO_NETWORK
                NetworkException.ERROR_TIMED_OUT -> ErrorCode.CODE_SOCKET_TIME_OUT
                NetworkException.ERROR_CONNECTION_TIMED_OUT -> ErrorCode.CODE_CONNECT_TIMEOUT_EXCEPTION
                NetworkException.ERROR_NETWORK_CHANGED -> ErrorCode.CODE_NETWORK_CHANGED
                NetworkException.ERROR_CONNECTION_CLOSED -> ErrorCode.CODE_CONNECT_CLOSED
                NetworkException.ERROR_CONNECTION_REFUSED -> ErrorCode.CODE_CONNECT_REFUSED
                NetworkException.ERROR_CONNECTION_RESET -> ErrorCode.CODE_CONNECT_RESET
                NetworkException.ERROR_ADDRESS_UNREACHABLE -> ErrorCode.CODE_NO_ROUTE_TO_HOST
                NetworkException.ERROR_QUIC_PROTOCOL_FAILED -> ErrorCode.CODE_PROTOCOL_ERROR
                else -> {
                    if (isCancel) {
                        ErrorCode.CODE_CANCEL
                    } else {
                        ErrorCode.CODE_UNKNOWN
                    }
                }
            }
        }
        return code
    }
}