package com.transsin.networkmonitor.stat

import android.annotation.SuppressLint
import android.content.Context
import android.os.Bundle
import com.google.gson.Gson
import com.google.gson.JsonObject
import com.shalltry.aisearch.core.utils.LogUtil
import com.transsin.networkmonitor.Utils
import com.transsin.util.GlobalUtils
import org.json.JSONObject
import java.util.concurrent.atomic.AtomicBoolean
import kotlin.random.Random

object DataMonitorHelper {

    const val TAG = "netInspect:DataMonitorHelper"
    private var monitorType = MonitorType.FIREBASE_MONITOR

    private var mInit = AtomicBoolean(false)

    private var mFirebaseMonitor: IMonitor? = null
    private var mRealDataMonitor: IMonitor? = null


    @SuppressLint("MissingPermission")
    fun init(context: Context, appId: String) {
        try {
            GlobalUtils.pkgName = context.packageName ?: ""
            GlobalUtils.context = context
            if (mInit.compareAndSet(false, true)) {
                mFirebaseMonitor = DataMonitorFactory.create(context, appId, MonitorType.FIREBASE_MONITOR)
                mRealDataMonitor = DataMonitorFactory.create(context, appId, MonitorType.REAL_DATA_MONITOR)
            }
        } catch (t: Throwable) {
            t.printStackTrace()
        }
    }

    fun commitNetworkStat(event: String?, bundle: Bundle? = Bundle()) {
        val rate = GlobalUtils.configData.networkRate
        val type = GlobalUtils.configData.networkChannel
        commitStat(event, bundle, rate, type)
    }

    fun commitBootStat(event: String?, bundle: Bundle? = Bundle()) {
        val rate = GlobalUtils.configData.bootRate
        val type = GlobalUtils.configData.bootChannel
        commitStat(event, bundle, rate, type)
    }

    fun commitCustomStat(event: String?, bundle: Bundle? = Bundle()) {
        val rate = GlobalUtils.configData.customRate
        val type = GlobalUtils.configData.customChannel
        commitStat(event, bundle, rate, type)
    }

    private fun commitStat(event: String?, bundle: Bundle? = Bundle(), rate: Int? = 0, type: Int? = 2) {
        try {
            if (event.isNullOrEmpty()) {
                return
            }
            bundle?.putInt("net", GlobalUtils.currentNet)
            bundle?.putString("vn", Utils.getVersionName())
            bundle?.putString("pkg", GlobalUtils.pkgName)
            LogUtil.d(TAG, "event=$event , bundle =${bundle.toString()}")
            if (!isReport(rate ?: 0)) {
                LogUtil.e(TAG, "rate = ${rate}, discard.")
                return
            }
            if (type == 1) {
                mFirebaseMonitor?.commitStat(event, bundle)
            } else {
                mRealDataMonitor?.commitStat(event, bundle)
            }
        } catch (t: Throwable) {
            t.printStackTrace()
        }
    }

    //根据rate是否需要上报
    fun isReport(rate: Int): Boolean {
        // 生成一个 1 到 1000 之间的随机整数
        val randomValue = Random.nextInt(1, 1001)
        LogUtil.d(TAG, "rate = ${rate}, randomValue=$randomValue.")
        // 返回随机数是否小于等于 rate 的结果
        return randomValue <= rate
    }

    fun setDefaultRate(rate: Int) {
        GlobalUtils.defaultRate = rate
    }

}