package com.transsin.networkmonitor;

import static com.transsin.networkmonitor.Consts.NORMAL;
import static com.transsin.networkmonitor.Utils.GLOBAL_TAG;

import android.util.Log;

import okhttp3.Call;
import okhttp3.EventListener;

/**
 * @Author:huangxiushuo
 * @Date: 2023-05-25 19:51
 * @Description:
 */
public class MonitorFactory implements EventListener.Factory {

    private EventListener.Factory factory;

    private int usage = NORMAL;

    private boolean notReportData = false;

    /**
     * notReportCancel开启时，errorCode是CODE_CANCEL时不上报
     */
    private boolean notReportCancel = false;

    /**
     * notReportNoNetwork开启时，errorCode是MSG_NETWORK_DISCONNECT时不上报
     */
    private boolean notReportNoNetwork = false;

    private boolean cronetFilter = false;

    private String abTag;

    private String channel = "All";

    public MonitorFactory() {
    }

    public MonitorFactory(EventListener.Factory factory) {
        this.factory = factory;
    }

    public MonitorFactory(EventListener.Factory factory, int usage, boolean notReportData) {
        this.factory = factory;
        this.usage = usage;
        this.notReportData = notReportData;
    }

    public MonitorFactory(EventListener.Factory factory, int usage, boolean notReportData, String channel) {
        this.factory = factory;
        this.usage = usage;
        this.notReportData = notReportData;
        this.channel = channel;
    }

    public MonitorFactory(EventListener.Factory factory, int usage, boolean notReportData, String channel, boolean notReportCancel) {
        this.factory = factory;
        this.usage = usage;
        this.notReportData = notReportData;
        this.channel = channel;
        this.notReportCancel = notReportCancel;
    }


    public MonitorFactory(EventListener.Factory factory, int usage, boolean notReportData,
                          String channel, boolean notReportCancel, boolean notReportNoNetwork) {
        this.factory = factory;
        this.usage = usage;
        this.notReportData = notReportData;
        this.channel = channel;
        this.notReportCancel = notReportCancel;
        this.notReportNoNetwork = notReportNoNetwork;
    }

    @Override
    public EventListener create(Call call) {
        EventListener eventListener = null;
        if (factory != null) {
            eventListener = factory.create(call);
        }
        String host = call.request().url().host();
        if (HostMatcher.noHosts() || HostMatcher.match(host)) {
            Log.d(GLOBAL_TAG, "==== MonitorFactory host : ${host} matches ====");
            return new MonitorEventListener(eventListener, usage, notReportData, channel, cronetFilter, abTag, notReportCancel, notReportNoNetwork);
        } else {
            Log.d(GLOBAL_TAG, "==== MonitorFactory host : ${host} does not matche ====");
            return eventListener == null ? EventListener.NONE : eventListener;
        }
    }

    /**
     * 设置是否开启Cronet过滤Okhttp请求的上报。
     *
     * @param cronetFilter true过滤，false不过滤。
     */
    public void setCronetFilter(boolean cronetFilter) {
        this.cronetFilter = cronetFilter;
    }

    /**
     * 业务方设置AB的标识字段。
     *
     * @param abTag
     */
    public void setABTag(String abTag) {
        this.abTag = abTag;
    }

}
