package com.transsin.networkmonitor

import com.transsin.networkmonitor.MonitorHelper.getEventListener
import okhttp3.Interceptor.Chain
import okhttp3.Request

/**
 * 网络监控的辅助工具类
 * 回调EventLister的自定义方法，上报官方的EventListener不支持的信息。
 * @see getEventListener
 * 3.xx中我们可以通过RealInterceptorChain的eventListener()方法获取
 * 4.xx中源码修改RealInterceptorChain，没有eventListener()的方法
 * 所以统一通过反射获取call中的eventListener
 */
object MonitorHelper {

    /**
     * 更新request信息
     */
    fun updateRequest(chain: Chain, buildRequest: Request) {
        getEventListener(chain)?.onRequestUpdate(buildRequest)
    }

    /**
     * 执行降级请求的回调
     */
    fun downgrade(chain: Chain, buildRequest: Request, errorCode: Int) {
        getEventListener(chain)?.onDowngrade(buildRequest, errorCode)
    }

    /**
     * 反射获取Okhttp的EventListener
     */
    private fun getEventListener(chain: Chain): NetWorkListener? {
        return ReflectionUtil.getField(chain.call(), "eventListener") as? NetWorkListener
    }
}