package com.transsin.networkmonitor

import androidx.core.os.bundleOf
import com.transsin.networkmonitor.stat.DataMonitorHelper

/**
 * @Author lihao
 * @Time 2024/2/28 14:58
 * @Company Transsion
 * desc
 */

object TrackUtil {

    /**
     * 业务方上报错误信息
     * usage 使用场景 0：API请求， 1：CDN
     * url 请求的api或cdn地址
     * message 错误信息
     */
    fun trackErrorMessage(usage: Int, url: String, message: String) {
        DataMonitorHelper.commitCustomStat(Consts.MSG_EVENT, bundleOf(
            "usage" to usage,
            "server_api" to url,
            "error_msg" to message
        ))
    }

    /**
     * 上报异常信息
     * @param type 错误场景 1.构建网络AB库异常
     * @param message 异常信息
     */
    fun trackException(type: Int, message: String) {
        DataMonitorHelper.commitCustomStat(Consts.THROWABLE_EVENT, bundleOf(
            "type" to type,
            "exception_msg" to message
        ))
    }
}

