package com.transsin.networkmonitor;

import static androidx.core.content.ContextCompat.getSystemService;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.LocaleList;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;

import com.transsin.util.GlobalUtils;

import java.lang.reflect.Method;
import java.util.Locale;

/**
 * @Author:huangxiushuo
 * @Date: 2023-05-17 10:23
 * @Description:
 */
public class Utils {
    public static final String GLOBAL_TAG = "NetworkMonitor";

    private static String mcc = "";

    private static String versionName = "";
   /* public static ObjectLogUtils LOG = new ObjectLogUtils.Builder().setGlobalTag(GLOBAL_TAG)
            .setLogHeadSwitch(true)
            .setBorderSwitch(false)
            .create();*/

    /**
     * 获取国家
     */
    public static String getCountry() {
        String country = "";
        try {
            @SuppressLint("PrivateApi")
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Method get = systemProperties.getMethod("get", String.class, String.class);
            country = (String) get.invoke(systemProperties, "persist.sys.oobe_country", "unknown");
        } catch (Exception e) {
           // Log.d(Log.getStackTraceString(e));
        }

        if (TextUtils.isEmpty(country) || "unknown".equals(country)) {
            country = getLocale().getCountry();
        }
        return country;
    }

    public static String getMcc() {
        try {
            if (!TextUtils.isEmpty(mcc)) {
                return mcc;
            }
            Context context = GlobalUtils.INSTANCE.getContext();
            if (context == null) {
                return mcc;
            }
            TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);

            // 获取网络运营商信息
            String networkOperator = telephonyManager.getNetworkOperator();

            // 检查 networkOperator 的有效性，并提取 MCC
            if (networkOperator != null && networkOperator.length() >= 3) {
                mcc = networkOperator.substring(0, 3);
            }
        } catch (Throwable t) {
            t.printStackTrace();
        }
        return mcc;
    }



    private static Locale getLocale() {
        Locale locale;
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                locale = LocaleList.getDefault().get(0);
            } else {
                locale = Locale.getDefault();
            }
        } catch (Exception e) {
            locale = Locale.getDefault();
            Log.d("Utils", Log.getStackTraceString(e));
        }

        return locale;
    }

    public static String getVersionName() {
        try {
            if (!TextUtils.isEmpty(versionName)) {
                return versionName;
            }
            Context context = GlobalUtils.INSTANCE.getContext();
            if (context != null) {
                PackageManager packageManager = context.getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
                versionName = packageInfo.versionName;
            }
        } catch (Throwable e) {
            e.printStackTrace();
            versionName = "";
        }
        return versionName;
    }
}