package com.transsin.networkmonitor.config

import com.shalltry.aisearch.core.WorkMode
import com.shalltry.aisearch.core.config.model.GlobalData
import com.shalltry.aisearch.core.utils.LogUtil
import com.transsin.util.GlobalUtils
import java.io.BufferedReader
import java.io.InputStreamReader
import java.net.HttpURLConnection
import java.net.URL

object NetworkConfigLoader {

    const val TAG = "netInspect:ConfigLoader"

    fun loadConfig(): String {
        var result = ""
        var conn: HttpURLConnection? = null
        try {
            val fileName = GlobalUtils.pkgName?.replace(".", "-") ?: ""
            val cdnUrl = if (NetworkConfigManager.mIsTest) {
                "https://fecdn.trasre.com/infoeyes-sample-rate-test/${fileName}.json"
            } else {
                "https://fecdn.trasre.com/infoeyes-sample-rate/${fileName}.json"
            }
            LogUtil.d(TAG, "cdnUrl:$cdnUrl")
            conn = URL(cdnUrl).openConnection() as HttpURLConnection
            conn.requestMethod = "GET"
            conn.connectTimeout = 30000
            conn.readTimeout = 30000
            val code = conn.responseCode
            if (code == HttpURLConnection.HTTP_OK) {
                val isr = BufferedReader(InputStreamReader(conn.inputStream))
                var inputLine: String?
                val response = StringBuilder()
                while ((isr.readLine().also { inputLine = it }) != null) {
                    response.append(inputLine)
                }
                result = response.toString()
                isr.close()
            } else {
                LogUtil.e(TAG, "loadConfig fail code:$code")
            }
        } catch (t: Throwable) {
            LogUtil.e(TAG, "loadConfig fail:$t")
        } finally {
            try {
                conn?.disconnect()
            } catch (t: Throwable) {

            }
        }
        LogUtil.d(TAG, "loadConfig result:$result")
        return result
    }
}