package com.transsin.networkmonitor.config.broadcast

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.util.Log
import com.transsin.networkmonitor.config.NetworkConfigManager


class NetworkUpdateCDNBroadcastReceiver: BroadcastReceiver() {
    override fun onReceive(context: Context?, intent: Intent?) {
        try {
            val action = intent?.action
            when (action) {
                UPDATE_CDN_ACTION -> {
                    val configStr = intent.getStringExtra("config") ?: ""
                    NetworkConfigManager.updateConfig(configStr)
                }
            }
        } catch (t: Throwable) {
            Log.e("NetworkUpdateCDN", "onReceive fail:$t")
        }
    }
    companion object {
        const val UPDATE_CDN_ACTION = "com.transsin.networkmonitor.config.broadcast.UPDATE_CDN_ACTION"
    }
}