package com.transsin.networkmonitor

import android.os.SystemClock
import android.util.Log
import androidx.core.os.bundleOf
import com.transsin.networkmonitor.stat.DataMonitorHelper
import com.transsin.util.GlobalUtils
import java.lang.Integer.min

/**
 * @Author:huangxiushuo
 * @Date: 2023-05-23 14:06
 * @Description:extensions
 */

fun String.printEvent() {
    Log.d(Utils.GLOBAL_TAG, "=======/ $this /=======")
}

fun String.printErrEvent() {
    Log.e(Utils.GLOBAL_TAG, "=======/ $this /=======")
}

fun MonitorData.asBundle() = bundleOf(
    "usage" to usage,
    //dnsTime|tcpTime|sslTime|sendTime|reqTime|serverTime|waitTime|recTime
    "time" to "${dnsTime}|${tcpTime}|${sslTime}|${sendTime}|${reqTime}|${serverTime}|${waitTime}|${recTime}",
    //cdn_down_time|cdnReqTime|cdnSpeed|cdnProvider
    "cdn" to "${cdnDownTime}|${cdnReqTime}|${cdnSpeed}|${cdnProvider}",
    //tls_versionTLS|protocol|request_downgrade|content_encoding
    "http" to "${tlsVersion}|${protocol}|${requestDowngrade}|${contentEncoding}",
    //req_body_size|res_body_size
    "size" to "${reqBodySize}|${resBodySize}",
    "httplib" to httpType,
    "server_api" to serverApi,
    "error_code" to errorCode,
    "error_msg" to errorMsg,
    "channel" to channel,
    "call_id" to callId,
    "call_result_code" to callResultCode,
    "complete_api" to completeApi,
    "ip_address" to ipAddr,
    "country" to country,
    "host" to host,
    "is_offline" to offlineAd,
    "compare_tag" to compareTag,
    "step" to step,
)

fun MonitorData.track() {
    Log.d(Utils.GLOBAL_TAG, this.toString())
    var event = Consts.EVENT
    DataMonitorHelper.commitNetworkStat(event, this.asBundle())
}

fun Exception.shortMsg(): String {
    this.message ?: return ""
    val endIndex = min(this.message!!.length, 200)
    return this.message!!.substring(0, endIndex)
}

fun realtime(): Long {
    return SystemClock.elapsedRealtime()
}

fun realtimeDiff(time: Long): Long {
    return realtime() - time
}