package com.transsion.datatracer.webview

import android.graphics.Bitmap
import android.net.http.SslError
import android.os.Build
import android.text.TextUtils
import android.util.Log
import android.webkit.SslErrorHandler
import android.webkit.WebResourceError
import android.webkit.WebResourceRequest
import android.webkit.WebResourceResponse
import android.webkit.WebView
import androidx.annotation.RequiresApi
import com.transsin.networkmonitor.R
import com.transsin.networkmonitor.Utils
import com.transsin.webviewmonitor.WebConstant
import com.transsin.webviewmonitor.WebPageBean
import com.transsin.webviewmonitor.WebViewMonitorInterface
import com.transsin.datatracer.TDataTracer
import org.json.JSONObject
import kotlin.collections.set


object WebViewMonitorHelper {
    const val TAG = "WebViewMonitorHelper"
    private var webViewUrlMap: MutableMap<String, WebPageBean> = mutableMapOf()
    private var webviewBlankMonitorSwitch = false //webview白屏监控开关
    @JvmStatic
    fun setWebviewBlankMonitorSwitch(switch: Boolean) {
        webviewBlankMonitorSwitch = switch
    }
    @JvmStatic
    fun onLoadUrl(webView: WebView, url: String) {
        try {
            webView.getSettings().setJavaScriptEnabled(true)
            val webPageBean = WebPageBean()
            webPageBean.url = url
            webView.setTag(R.id.webview_monitor_id, webPageBean.webId)
            webViewUrlMap[webPageBean.webId] = webPageBean
            // 添加JavaScript接口
            webView.addJavascriptInterface(WebViewMonitorInterface(), WebConstant.WEBVIEW_MONITOR_INTERFACE)
            val jsonObject = JSONObject()
            val extraUrl = webPageBean.url.let {
                if (it.length > 60) it.substring(0, 60) else it
            }
            jsonObject.put(WebConstant.MAIN_URL, extraUrl)
            //jsonObject.put(WebConstant.WEB_ID, webPageBean.webId)
            jsonObject.put(WebConstant.WEB_BLANK_SWITCH, webviewBlankMonitorSwitch)
            TDataTracer.traceCountType(WebConstant.WEB_OPEN_COUNT, jsonObject.toString())
        } catch (e: Throwable) {
            Log.e(TAG, Log.getStackTraceString(e))
        }
    }

    fun onReceivedError(
        view: WebView?, errorCode: Int, description: String?, failingUrl: String?
    ) {
        try {
            val webPageBean = webViewUrlMap[view?.getTag(R.id.webview_monitor_id)] ?: return
            if (!TextUtils.isEmpty(failingUrl) && isUrlMatch(webPageBean.url, failingUrl ?: "")) {
                val jsonObject = JSONObject()
                jsonObject.put(WebConstant.MAIN_URL, webPageBean.url)
                jsonObject.put(WebConstant.ERROR_TYPE,  WebConstant.ERROR)
                //jsonObject.put(WebConstant.WEB_ID,  webPageBean.webId)
                TDataTracer.traceIsSuccess(
                    WebConstant.WEBVIEW_ERROR,
                    WebConstant.STATUS_FAIL,
                    errorCode.toString(),
                    WebConstant.ERROR_MSG[errorCode] ?: "unknown error",
                    "",
                    jsonObject.toString()
                )
            }
        } catch (e: Throwable) {
            Log.e(TAG, Log.getStackTraceString(e))
        }
    }

    @RequiresApi(Build.VERSION_CODES.M)
    fun onReceivedError(view: WebView?, request: WebResourceRequest?, error: WebResourceError?) {
        try {
            val webPageBean = webViewUrlMap[view?.getTag(R.id.webview_monitor_id)] ?: return
            if (!TextUtils.isEmpty(request?.url.toString()) && isUrlMatch(
                    webPageBean.url, request?.url.toString()
                )
            ) {
                val jsonObject = JSONObject()
                val extraUrl = webPageBean.url.let {
                    if (it.length > 60) it.substring(0, 60) else it
                }
                jsonObject.put(WebConstant.MAIN_URL, extraUrl)
                jsonObject.put(WebConstant.ERROR_TYPE,  WebConstant.ERROR)
                //jsonObject.put(WebConstant.WEB_ID,  webPageBean.webId)
                TDataTracer.traceIsSuccess(
                    WebConstant.WEBVIEW_ERROR,
                    WebConstant.STATUS_FAIL,
                    error?.errorCode.toString(),
                    WebConstant.ERROR_MSG[error?.errorCode] ?: "unknown error",
                    "",
                    jsonObject.toString()
                )
            }
        } catch (e: Throwable) {
            Log.e(TAG, Log.getStackTraceString(e))
        }
    }


    @RequiresApi(Build.VERSION_CODES.LOLLIPOP)
    fun onReceivedHttpError(
        view: WebView?, request: WebResourceRequest?, errorResponse: WebResourceResponse?
    ) {
        try {
            val webPageBean = webViewUrlMap[view?.getTag(R.id.webview_monitor_id)] ?: return
            if (!TextUtils.isEmpty(request?.url.toString()) && isUrlMatch(
                    webPageBean.url, request?.url.toString()
                )
            ) {
                val jsonObject = JSONObject()
                val extraUrl = webPageBean.url.let {
                    if (it.length > 60) it.substring(0, 60) else it
                }
                jsonObject.put(WebConstant.MAIN_URL, extraUrl)
                jsonObject.put(WebConstant.ERROR_TYPE,  WebConstant.ERROR)
                //jsonObject.put(WebConstant.WEB_ID,  webPageBean.webId)
                TDataTracer.traceIsSuccess(
                    WebConstant.WEBVIEW_ERROR,
                    WebConstant.STATUS_FAIL,
                    errorResponse?.statusCode.toString(),
                    WebConstant.ERROR_MSG[errorResponse?.statusCode] ?: "unknown error",
                    "",
                    jsonObject.toString()
                )
            }
        } catch (e: Throwable) {
            Log.e(TAG, Log.getStackTraceString(e))
        }
    }


    fun onReceivedSslError(view: WebView?, handler: SslErrorHandler?, error: SslError?) {
        try {
            val webPageBean = webViewUrlMap[view?.getTag(R.id.webview_monitor_id)] ?: return
            if (!TextUtils.isEmpty(error?.url.toString()) && isUrlMatch(
                    webPageBean.url, error?.url.toString()
                )
            ) {
                val jsonObject = JSONObject()
                val extraUrl = webPageBean.url.let {
                    if (it.length > 60) it.substring(0, 60) else it
                }
                jsonObject.put(WebConstant.MAIN_URL, extraUrl)
                jsonObject.put(WebConstant.ERROR_TYPE,  WebConstant.SSL)
                //jsonObject.put(WebConstant.WEB_ID,  webPageBean.webId)
                TDataTracer.traceIsSuccess(
                    WebConstant.WEBVIEW_ERROR,
                    WebConstant.STATUS_FAIL,
                    error?.primaryError.toString(),
                    WebConstant.SSL_ERROE_MSG[error?.primaryError] ?: "unknown ssl error",
                    "",
                    jsonObject.toString()
                )
            }
        } catch (e: Throwable) {
            Log.e(TAG, Log.getStackTraceString(e))
        }
    }

    fun onPageStarted(webView: WebView?, url: String?, favicon: Bitmap?)  {
        try {
            injectJavaScript(webView)
        } catch (e: Throwable) {
            Log.e(TAG, Log.getStackTraceString(e))
        }
    }

    private fun injectJavaScript(webView: WebView?) {
        if(webView == null) return
        val webjsCode = """(function(){"use strict";let s=null,m=null,i=0;const r=e=>{try{const t=[Math.round(window.innerWidth/2),Math.round(window.innerHeight/2)],n=document.elementFromPoint(t[0],t[1]);let a=n==null?void 0:n.tagName.toLocaleLowerCase(),c=!1,l=0;switch(a){case"canvas":l=n.toDataURL().length;break;case"iframe":const o=n.contentDocument.elementFromPoint(t[0],t[1]);a=o.tagName.toLocaleLowerCase(),l=a==="canvas"?o.toDataURL().length:0;break;default:}if(["html","body"].indexOf(a)>-1?c=!0:a==="canvas"&&(i===0&&(i=u()),c=l<=i),c){const o=location.origin+location.pathname;WebViewMonitorInterface.reportBlank(o,e)}else clearTimeout(s),clearTimeout(m)}catch{}};function u(){try{const e=document.createElement("canvas");return e.width=window.innerWidth,e.height=window.innerHeight-55,e.toDataURL().length}catch{return 1e4}}setTimeout(()=>r("5"),5e3),s=setTimeout(()=>r("10"),1e4),m=setTimeout(()=>r("15"),15e3)})();"""
        if (webviewBlankMonitorSwitch) {
            webView.evaluateJavascript(webjsCode, null)
        }
    }

    fun isUrlMatch(loadUrl: String, url: String): Boolean {
        return url.startsWith(loadUrl)
    }
}