/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.os.BundleKt;
import com.transsin.networkmonitor.HostMatcher;
import com.transsin.networkmonitor.NetworkMonitor;
import com.transsin.networkmonitor.config.NetworkConfigManager;
import com.transsin.networkmonitor.stat.DataMonitorHelper;
import com.transsin.util.ExecutorUtils;
import com.transsin.util.GlobalUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0003J/\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u000e\b\u0002\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040+2\b\b\u0002\u0010\u001d\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010,J\u001a\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010\u001d\u001a\u00020\fH\u0007J\u000e\u0010-\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0010\u0010.\u001a\u00020'2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010/\u001a\u00020'2\u0006\u0010$\u001a\u00020%H\u0002J\b\u00100\u001a\u00020'H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010R\u001a\u0010\u001a\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001a\u0010\u001d\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010\u0010R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/transsin/networkmonitor/NetworkMonitor;", "", "()V", "TAG", "", "initStartTime", "", "getInitStartTime$lib_networkmonitor_release", "()J", "setInitStartTime$lib_networkmonitor_release", "(J)V", "isFakeNetwork", "", "isFakeNetwork$lib_networkmonitor_release", "()Z", "setFakeNetwork$lib_networkmonitor_release", "(Z)V", "isInit", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isInit$lib_networkmonitor_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "setInit$lib_networkmonitor_release", "(Ljava/util/concurrent/atomic/AtomicBoolean;)V", "isNetInitDone", "isNetInitDone$lib_networkmonitor_release", "setNetInitDone$lib_networkmonitor_release", "isNetworkConnected", "isNetworkConnected$lib_networkmonitor_release", "setNetworkConnected$lib_networkmonitor_release", "isTest", "isTest$lib_networkmonitor_release", "setTest$lib_networkmonitor_release", "mReceiver", "Landroid/content/BroadcastReceiver;", "getMobileNetworkClass", "", "context", "Landroid/content/Context;", "init", "", "application", "Landroid/app/Application;", "hosts", "", "(Landroid/app/Application;[Ljava/lang/String;Z)V", "parseNetworkType", "registerNetworkCallback", "registerNetworkReceiver", "trackNetworkState", "lib-networkmonitor_release"})
public final class NetworkMonitor {
    @NotNull
    public static final NetworkMonitor INSTANCE = new NetworkMonitor();
    @NotNull
    public static final String TAG = "NetworkMonitor";
    private static boolean isTest;
    private static boolean isNetworkConnected;
    private static boolean isFakeNetwork;
    private static boolean isNetInitDone;
    private static long initStartTime;
    @NotNull
    private static AtomicBoolean isInit;
    @NotNull
    private static final BroadcastReceiver mReceiver;

    private NetworkMonitor() {
    }

    public final boolean isTest$lib_networkmonitor_release() {
        return isTest;
    }

    public final void setTest$lib_networkmonitor_release(boolean bl) {
        isTest = bl;
    }

    public final boolean isNetworkConnected$lib_networkmonitor_release() {
        return isNetworkConnected;
    }

    public final void setNetworkConnected$lib_networkmonitor_release(boolean bl) {
        isNetworkConnected = bl;
    }

    public final boolean isFakeNetwork$lib_networkmonitor_release() {
        return isFakeNetwork;
    }

    public final void setFakeNetwork$lib_networkmonitor_release(boolean bl) {
        isFakeNetwork = bl;
    }

    public final boolean isNetInitDone$lib_networkmonitor_release() {
        return isNetInitDone;
    }

    public final void setNetInitDone$lib_networkmonitor_release(boolean bl) {
        isNetInitDone = bl;
    }

    public final long getInitStartTime$lib_networkmonitor_release() {
        return initStartTime;
    }

    public final void setInitStartTime$lib_networkmonitor_release(long l) {
        initStartTime = l;
    }

    @NotNull
    public final AtomicBoolean isInit$lib_networkmonitor_release() {
        return isInit;
    }

    public final void setInit$lib_networkmonitor_release(@NotNull AtomicBoolean atomicBoolean) {
        Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
        isInit = atomicBoolean;
    }

    @JvmStatic
    public static final void init(@NotNull Application application, @NotNull String[] hosts, boolean isTest) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)hosts, (String)"hosts");
        try {
            Log.d((String)"liuwei", (String)"init start ");
            if (isInit.compareAndSet(false, true)) {
                Log.d((String)"liuwei", (String)"init start ...");
                NetworkMonitor.isTest = isTest;
                NetworkConfigManager.INSTANCE.init((Context)application, isTest);
                DataMonitorHelper.INSTANCE.init((Context)application, "10003");
                HostMatcher.INSTANCE.setHosts$lib_networkmonitor_release(hosts);
                INSTANCE.registerNetworkCallback((Context)application);
                initStartTime = SystemClock.uptimeMillis();
                INSTANCE.trackNetworkState();
                INSTANCE.registerNetworkReceiver((Context)application);
            }
            Log.d((String)"liuwei", (String)"init start end");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static /* synthetic */ void init$default(Application application, String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            stringArray = new String[]{};
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        NetworkMonitor.init(application, stringArray, bl);
    }

    @JvmStatic
    public static final void init(@NotNull Application application, boolean isTest) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        NetworkMonitor.init(application, new String[0], isTest);
    }

    public static /* synthetic */ void init$default(Application application, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        NetworkMonitor.init(application, bl);
    }

    private final void registerNetworkCallback(Context context) {
        try {
            Object object = context.getSystemService("connectivity");
            ConnectivityManager connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
            if (connectivityManager == null) {
                return;
            }
            ConnectivityManager connectivityManager2 = connectivityManager;
            if (Build.VERSION.SDK_INT >= 23) {
                NetworkRequest request = new NetworkRequest.Builder().build();
                connectivityManager2.registerNetworkCallback(request, new ConnectivityManager.NetworkCallback(){

                    public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
                        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                        Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
                        super.onCapabilitiesChanged(network, networkCapabilities);
                        boolean isNetworkValid = networkCapabilities.hasCapability(16);
                        NetworkMonitor.INSTANCE.setNetworkConnected$lib_networkmonitor_release(networkCapabilities.hasCapability(12));
                        NetworkMonitor.INSTANCE.setFakeNetwork$lib_networkmonitor_release(NetworkMonitor.INSTANCE.isNetworkConnected$lib_networkmonitor_release() && !isNetworkValid);
                        NetworkMonitor.INSTANCE.setNetInitDone$lib_networkmonitor_release(true);
                        if (!NetworkMonitor.INSTANCE.isNetworkConnected$lib_networkmonitor_release()) {
                            GlobalUtils.INSTANCE.setCurrentNet(99);
                        }
                        Log.d((String)"NetworkMonitor", (String)("isNetworkConnected : " + NetworkMonitor.INSTANCE.isNetworkConnected$lib_networkmonitor_release() + ",  isFakeNetwork : " + NetworkMonitor.INSTANCE.isFakeNetwork$lib_networkmonitor_release()));
                    }

                    public void onAvailable(@NotNull Network network) {
                        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                        super.onAvailable(network);
                        Log.d((String)"NetworkMonitor", (String)("onAvailable : " + network));
                    }

                    public void onUnavailable() {
                        super.onUnavailable();
                        Log.d((String)"NetworkMonitor", (String)"onUnavailable");
                    }

                    public void onBlockedStatusChanged(@NotNull Network network, boolean blocked) {
                        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                        super.onBlockedStatusChanged(network, blocked);
                        Log.d((String)"NetworkMonitor", (String)"onBlockedStatusChanged");
                    }

                    public void onLost(@NotNull Network network) {
                        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                        super.onLost(network);
                        Log.d((String)"NetworkMonitor", (String)"onLost");
                        NetworkMonitor.INSTANCE.setNetworkConnected$lib_networkmonitor_release(false);
                        GlobalUtils.INSTANCE.setCurrentNet(99);
                    }

                    public void onLosing(@NotNull Network network, int maxMsToLive) {
                        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                        super.onLosing(network, maxMsToLive);
                        Log.d((String)"NetworkMonitor", (String)"onLosing");
                    }
                });
                GlobalUtils.INSTANCE.setCurrentNet(this.parseNetworkType(context));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private final void trackNetworkState() {
        try {
            new Handler(Looper.getMainLooper()).postDelayed(NetworkMonitor::trackNetworkState$lambda$0, 5000L);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    private final void registerNetworkReceiver(Context context) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        try {
            context.registerReceiver(mReceiver, filter);
        }
        catch (Throwable t) {
            String string = t.getMessage();
            if (string == null) {
                string = "";
            }
            Log.e((String)TAG, (String)string);
        }
    }

    public final int parseNetworkType(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Object object = context.getSystemService("connectivity");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
            ConnectivityManager connectivityManager = (ConnectivityManager)object;
            if (Build.VERSION.SDK_INT >= 23) {
                Network network = connectivityManager.getActiveNetwork();
                if (network == null) {
                    return 99;
                }
                Network network2 = network;
                NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network2);
                if (networkCapabilities == null) {
                    return 99;
                }
                NetworkCapabilities capabilities = networkCapabilities;
                if (capabilities.hasTransport(1)) {
                    return 1;
                }
                if (capabilities.hasTransport(0)) {
                    return this.getMobileNetworkClass(context);
                }
                return 99;
            }
            NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            if (activeNetworkInfo != null) {
                if (activeNetworkInfo.getType() == 1) {
                    return 1;
                }
                if (activeNetworkInfo.getType() == 0) {
                    return this.getMobileNetworkClass(context);
                }
                return 99;
            }
        }
        catch (Throwable t) {
            String string = t.getMessage();
            if (string == null) {
                string = "";
            }
            Log.e((String)TAG, (String)string);
        }
        return 0;
    }

    @SuppressLint(value={"MissingPermission"})
    private final int getMobileNetworkClass(Context context) {
        try {
            Object object = context.getSystemService("phone");
            TelephonyManager telephonyManager = object instanceof TelephonyManager ? (TelephonyManager)object : null;
            if (telephonyManager == null) {
                return 0;
            }
            TelephonyManager telephonyManager2 = telephonyManager;
            int networkType = 0;
            String subtypeName = "";
            if (Build.VERSION.SDK_INT < 30) {
                networkType = telephonyManager2.getNetworkType();
            } else if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0 || telephonyManager2.hasCarrierPrivileges()) {
                networkType = telephonyManager2.getDataNetworkType();
            }
            if (networkType == 0) {
                Object object2 = context.getSystemService("connectivity");
                ConnectivityManager connectivityManager = object2 instanceof ConnectivityManager ? (ConnectivityManager)object2 : null;
                if (connectivityManager == null) {
                    return 0;
                }
                ConnectivityManager connectivityManager2 = connectivityManager;
                NetworkInfo networkInfo = connectivityManager2.getActiveNetworkInfo();
                if (networkInfo != null) {
                    networkType = networkInfo.getSubtype();
                    subtypeName = networkInfo.getSubtypeName();
                }
            }
            switch (networkType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: 
                case 16: {
                    return 2;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 17: {
                    return 3;
                }
                case 13: 
                case 18: 
                case 19: {
                    return 4;
                }
                case 20: {
                    return 5;
                }
            }
            CharSequence charSequence = subtypeName;
            if (!(charSequence == null || charSequence.length() == 0)) {
                if (StringsKt.equals((String)subtypeName, (String)"TD-SCDMA", (boolean)true) || StringsKt.equals((String)subtypeName, (String)"WCDMA", (boolean)true) || StringsKt.equals((String)subtypeName, (String)"CDMA2000", (boolean)true)) {
                    return 3;
                }
                return 0;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return 0;
    }

    private static final void trackNetworkState$lambda$0() {
        String netStatus = "1";
        if (isNetworkConnected) {
            netStatus = "0";
        }
        if (isFakeNetwork) {
            netStatus = "2";
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"net_status", (Object)netStatus)};
        DataMonitorHelper.INSTANCE.commitBootStat("monitor_init", BundleKt.bundleOf((Pair[])pairArray));
    }

    static {
        isInit = new AtomicBoolean(false);
        mReceiver = new BroadcastReceiver(){

            public void onReceive(@NotNull Context c, @NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                try {
                    ExecutorUtils.io().execute(() -> mReceiver.1.onReceive$lambda$0(c));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            private static final void onReceive$lambda$0(Context $c) {
                Intrinsics.checkNotNullParameter((Object)$c, (String)"$c");
                GlobalUtils.INSTANCE.setCurrentNet(NetworkMonitor.INSTANCE.parseNetworkType($c));
            }
        };
    }
}

