/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor.config;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.gson.Gson;
import com.shalltry.aisearch.core.utils.LogUtil;
import com.shalltry.aisearch.core.utils.ProcessUtil;
import com.shalltry.aisearch.core.utils.SPUtils;
import com.transsin.networkmonitor.Utils;
import com.transsin.networkmonitor.config.ConfigModel;
import com.transsin.networkmonitor.config.NetworkConfigLoader;
import com.transsin.networkmonitor.config.NetworkConfigModel;
import com.transsin.networkmonitor.config.RateInfo;
import com.transsin.networkmonitor.config.broadcast.NetworkUpdateCDNBroadcastReceiver;
import com.transsin.util.GlobalUtils;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0002J!\u0010\"\u001a\u00020#2\b\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010'\u001a\u00020#H\u0002J\b\u0010(\u001a\u00020#H\u0002J\u0019\u0010)\u001a\u0004\u0018\u00010\u001c2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020\u0004H\u0002J\u0010\u0010/\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0003J\u0018\u00100\u001a\u00020#2\u0006\u0010 \u001a\u00020!2\u0006\u00101\u001a\u00020\u0004H\u0002J\u000e\u00102\u001a\u00020#2\u0006\u00101\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u00063"}, d2={"Lcom/transsin/networkmonitor/config/NetworkConfigManager;", "", "()V", "KEY_CONFIG_DATA", "", "KEY_CONFIG_UPDATE_TIME", "STORE_NAME", "TAG", "isInit", "Ljava/util/concurrent/atomic/AtomicBoolean;", "mHandler", "Landroid/os/Handler;", "mHandlerThread", "Landroid/os/HandlerThread;", "mIsTest", "", "getMIsTest", "()Z", "setMIsTest", "(Z)V", "getBooleanItem", "jsonObject", "Lorg/json/JSONObject;", "key", "defaultValue", "getDoubleItem", "", "getIntItem", "", "getLongItem", "", "getStoreName", "context", "Landroid/content/Context;", "init", "", "isTest", "(Landroid/content/Context;Ljava/lang/Boolean;)V", "initHandlerThread", "loadLocalConfigTask", "loadRemoteConfigTask", "parseRateInfo", "configModel", "Lcom/transsin/networkmonitor/config/ConfigModel;", "(Lcom/transsin/networkmonitor/config/ConfigModel;)Ljava/lang/Integer;", "parseStrToModel", "str", "registerBroadcast", "sendUpdateConfigBroadcast", "configStr", "updateConfig", "lib-networkmonitor_release"})
public final class NetworkConfigManager {
    @NotNull
    public static final NetworkConfigManager INSTANCE = new NetworkConfigManager();
    @NotNull
    public static final String TAG = "netInspect:Config";
    @Nullable
    private static String STORE_NAME;
    @NotNull
    private static String KEY_CONFIG_DATA;
    @NotNull
    private static String KEY_CONFIG_UPDATE_TIME;
    @NotNull
    private static final AtomicBoolean isInit;
    @Nullable
    private static HandlerThread mHandlerThread;
    @Nullable
    private static Handler mHandler;
    private static boolean mIsTest;

    private NetworkConfigManager() {
    }

    public final boolean getMIsTest() {
        return mIsTest;
    }

    public final void setMIsTest(boolean bl) {
        mIsTest = bl;
    }

    public final void init(@Nullable Context context, @Nullable Boolean isTest) {
        try {
            Boolean bl = isTest;
            boolean bl2 = mIsTest = bl != null ? bl : false;
            if (context == null) {
                Log.d((String)TAG, (String)"ConfigManager init fail: context is null!");
                return;
            }
            if (isInit.compareAndSet(false, true)) {
                Log.d((String)TAG, (String)"ConfigManager [init] start");
                this.registerBroadcast(context);
                this.initHandlerThread(context);
                this.loadLocalConfigTask();
            } else {
                Log.d((String)TAG, (String)"NetworkConfigManager already init.");
            }
        }
        catch (Throwable t) {
            LogUtil.e$default((LogUtil)LogUtil.INSTANCE, (String)TAG, (String)("ConfigManager init fail:" + t), null, (int)4, null);
        }
    }

    public static /* synthetic */ void init$default(NetworkConfigManager networkConfigManager, Context context, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        networkConfigManager.init(context, bl);
    }

    private final void initHandlerThread(Context context) {
        block1: {
            HandlerThread handlerThread;
            HandlerThread handlerThread2;
            LogUtil.INSTANCE.d(TAG, "ConfigManager [initHandlerThread] start");
            HandlerThread handlerThread3 = mHandlerThread = new HandlerThread("aisearch-data_HandlerThread");
            if (handlerThread3 != null) {
                handlerThread3.start();
            }
            if ((handlerThread2 = mHandlerThread) == null || (handlerThread2 = handlerThread2.getLooper()) == null) break block1;
            HandlerThread $this$initHandlerThread_u24lambda_u240 = handlerThread = handlerThread2;
            boolean bl = false;
            mHandler = new Handler((Looper)$this$initHandlerThread_u24lambda_u240, context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super($receiver);
                }

                public void handleMessage(@NotNull Message msg) {
                    Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                    super.handleMessage(msg);
                    try {
                        switch (msg.what) {
                            case 1: {
                                LogUtil.INSTANCE.d("netInspect:Config", "ConfigManager [loadLocalConfigTask] run");
                                String storeName = NetworkConfigManager.access$getStoreName(NetworkConfigManager.INSTANCE, this.$context);
                                String configStr = SPUtils.INSTANCE.getStringValue(this.$context, storeName, NetworkConfigManager.access$getKEY_CONFIG_DATA$p());
                                LogUtil.INSTANCE.d("netInspect:Config", "ConfigManager [loadLocalConfigTask] configStr:" + configStr);
                                NetworkConfigManager.access$parseStrToModel(NetworkConfigManager.INSTANCE, configStr);
                                long configUpdateTime = SPUtils.INSTANCE.getLongValue(this.$context, storeName, NetworkConfigManager.access$getKEY_CONFIG_UPDATE_TIME$p());
                                long currentTime = System.currentTimeMillis();
                                long diffTime = currentTime - configUpdateTime;
                                if (GlobalUtils.INSTANCE.getConfigData().getNetworkRate() == -999) {
                                    GlobalUtils.INSTANCE.getConfigData().setNetworkRate(GlobalUtils.INSTANCE.getDefaultRate());
                                    LogUtil.e$default((LogUtil)LogUtil.INSTANCE, (String)"netInspect:Config", (String)("network use default rate = " + GlobalUtils.INSTANCE.getDefaultRate()), null, (int)4, null);
                                }
                                if (GlobalUtils.INSTANCE.getConfigData().getBootRate() == -999) {
                                    GlobalUtils.INSTANCE.getConfigData().setBootRate(GlobalUtils.INSTANCE.getDefaultRate());
                                    LogUtil.e$default((LogUtil)LogUtil.INSTANCE, (String)"netInspect:Config", (String)("boot use default rate = " + GlobalUtils.INSTANCE.getDefaultRate()), null, (int)4, null);
                                }
                                if (GlobalUtils.INSTANCE.getConfigData().getCustomRate() == -999) {
                                    GlobalUtils.INSTANCE.getConfigData().setCustomRate(GlobalUtils.INSTANCE.getDefaultRate());
                                    LogUtil.e$default((LogUtil)LogUtil.INSTANCE, (String)"netInspect:Config", (String)("custom use default rate = " + GlobalUtils.INSTANCE.getDefaultRate()), null, (int)4, null);
                                }
                                LogUtil.INSTANCE.d("netInspect:Config", "ConfigManager [loadLocalConfigTask] currentTime:" + currentTime + ", configUpdateTime:" + configUpdateTime + ", diffTime:" + diffTime);
                                if (Math.abs(diffTime) > 86400000L) {
                                    NetworkConfigManager.access$loadRemoteConfigTask(NetworkConfigManager.INSTANCE);
                                }
                                break;
                            }
                            case 2: {
                                LogUtil.INSTANCE.d("netInspect:Config", "ConfigManager [loadRemoteConfigTask] run");
                                String result = NetworkConfigLoader.INSTANCE.loadConfig();
                                if (((CharSequence)result).length() > 0) {
                                    NetworkConfigManager.access$sendUpdateConfigBroadcast(NetworkConfigManager.INSTANCE, this.$context, result);
                                }
                                break;
                            }
                            case 3: {
                                String configStr = msg.getData().getString("config");
                                LogUtil.INSTANCE.d("netInspect:Config", "ConfigManager [updateConfig] run configStr:" + configStr);
                                String string = configStr;
                                boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
                                if (!bl) break;
                                String storeName = NetworkConfigManager.access$getStoreName(NetworkConfigManager.INSTANCE, this.$context);
                                SPUtils.INSTANCE.setStringValue(this.$context, storeName, NetworkConfigManager.access$getKEY_CONFIG_DATA$p(), configStr);
                                SPUtils.INSTANCE.setLongValue(this.$context, storeName, NetworkConfigManager.access$getKEY_CONFIG_UPDATE_TIME$p(), System.currentTimeMillis());
                                NetworkConfigManager.access$parseStrToModel(NetworkConfigManager.INSTANCE, configStr);
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    catch (Throwable t) {
                        LogUtil.e$default((LogUtil)LogUtil.INSTANCE, (String)"netInspect:Config", (String)("handleMessage fail:" + t), null, (int)4, null);
                    }
                }
            };
        }
    }

    private final void loadLocalConfigTask() {
        block1: {
            Handler handler;
            LogUtil.INSTANCE.d(TAG, "ConfigManager [loadLocalConfigTask]");
            Handler handler2 = mHandler;
            if (handler2 == null || (handler2 = handler2.obtainMessage(1)) == null) break block1;
            Handler $this$loadLocalConfigTask_u24lambda_u241 = handler = handler2;
            boolean bl = false;
            Handler handler3 = mHandler;
            if (handler3 != null) {
                handler3.sendMessage((Message)$this$loadLocalConfigTask_u24lambda_u241);
            }
        }
    }

    private final void loadRemoteConfigTask() {
        block1: {
            Handler handler;
            LogUtil.INSTANCE.d(TAG, "ConfigManager [loadRemoteConfigTask]");
            Handler handler2 = mHandler;
            if (handler2 == null || (handler2 = handler2.obtainMessage(2)) == null) break block1;
            Handler $this$loadRemoteConfigTask_u24lambda_u242 = handler = handler2;
            boolean bl = false;
            Handler handler3 = mHandler;
            if (handler3 != null) {
                handler3.sendMessage((Message)$this$loadRemoteConfigTask_u24lambda_u242);
            }
        }
    }

    private final void sendUpdateConfigBroadcast(Context context, String configStr) {
        LogUtil.INSTANCE.d(TAG, "ConfigManager [sendUpdateConfigBroadcast], " + context.getPackageName());
        Intent intent = new Intent("com.transsin.networkmonitor.config.broadcast.UPDATE_CDN_ACTION");
        intent.putExtra("config", configStr);
        intent.setPackage(context.getPackageName());
        context.sendBroadcast(intent);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateConfig(@NotNull String configStr) {
        block1: {
            void $this$updateConfig_u24lambda_u244_u24lambda_u243;
            Bundle bundle;
            Handler handler;
            Intrinsics.checkNotNullParameter((Object)configStr, (String)"configStr");
            LogUtil.INSTANCE.d(TAG, "ConfigManager [updateConfig] configStr:" + configStr);
            Handler handler2 = mHandler;
            if (handler2 == null || (handler2 = handler2.obtainMessage(3)) == null) break block1;
            Handler $this$updateConfig_u24lambda_u244 = handler = handler2;
            boolean bl = false;
            Bundle bundle2 = bundle = new Bundle();
            Handler handler3 = $this$updateConfig_u24lambda_u244;
            boolean bl2 = false;
            $this$updateConfig_u24lambda_u244_u24lambda_u243.putString("config", configStr);
            handler3.setData(bundle);
            Handler handler4 = mHandler;
            if (handler4 != null) {
                handler4.sendMessage((Message)$this$updateConfig_u24lambda_u244);
            }
        }
    }

    private final void parseStrToModel(String str) {
        try {
            Object object;
            Object object2;
            int it;
            Object object3;
            int it2;
            NetworkConfigModel config;
            CharSequence charSequence;
            CharSequence charSequence2 = str;
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = "{}";
            } else {
                charSequence = charSequence2;
            }
            String parseStr = (String)charSequence;
            LogUtil.INSTANCE.d(TAG, "ConfigManager [parseStrToModel] parseStr:" + parseStr);
            Gson gson = new Gson();
            NetworkConfigModel networkConfigModel = config = (NetworkConfigModel)gson.fromJson(str, NetworkConfigModel.class);
            Integer n = this.parseRateInfo(networkConfigModel != null ? networkConfigModel.getNetwork() : null);
            if (n != null) {
                it2 = ((Number)n).intValue();
                boolean bl = false;
                GlobalUtils.INSTANCE.getConfigData().setNetworkRate(it2);
            }
            if ((object3 = config) != null && (object3 = ((NetworkConfigModel)object3).getNetwork()) != null && (object3 = ((ConfigModel)object3).getChannel()) != null) {
                it = ((Number)object3).intValue();
                boolean bl = false;
                GlobalUtils.INSTANCE.getConfigData().setNetworkChannel(it);
            }
            NetworkConfigModel networkConfigModel2 = config;
            Integer n2 = this.parseRateInfo(networkConfigModel2 != null ? networkConfigModel2.getBoot() : null);
            if (n2 != null) {
                it2 = ((Number)n2).intValue();
                boolean bl = false;
                GlobalUtils.INSTANCE.getConfigData().setBootRate(it2);
            }
            if ((object2 = config) != null && (object2 = ((NetworkConfigModel)object2).getBoot()) != null && (object2 = ((ConfigModel)object2).getChannel()) != null) {
                it = ((Number)object2).intValue();
                boolean bl = false;
                GlobalUtils.INSTANCE.getConfigData().setBootChannel(it);
            }
            NetworkConfigModel networkConfigModel3 = config;
            Integer n3 = this.parseRateInfo(networkConfigModel3 != null ? networkConfigModel3.getCustom() : null);
            if (n3 != null) {
                it2 = ((Number)n3).intValue();
                boolean bl = false;
                GlobalUtils.INSTANCE.getConfigData().setCustomRate(it2);
            }
            if ((object = config) != null && (object = ((NetworkConfigModel)object).getCustom()) != null && (object = ((ConfigModel)object).getChannel()) != null) {
                it = ((Number)object).intValue();
                boolean bl = false;
                GlobalUtils.INSTANCE.getConfigData().setCustomChannel(it);
            }
        }
        catch (Throwable t) {
            LogUtil.e$default((LogUtil)LogUtil.INSTANCE, (String)TAG, (String)("parseStrToModel fail:" + t), null, (int)4, null);
        }
    }

    private final Integer parseRateInfo(ConfigModel configModel) {
        try {
            RateInfo rateInfo;
            RateInfo rateInfo2;
            RateInfo it;
            Iterable iterable;
            if (configModel == null) {
                return null;
            }
            ArrayList<RateInfo> arrayList = configModel.getRate();
            if (arrayList != null) {
                Object v1;
                block19: {
                    iterable = arrayList;
                    for (Object t : iterable) {
                        it = (RateInfo)t;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it.getAppVersion(), (Object)Utils.getVersionName()) && Intrinsics.areEqual((Object)it.getCountry(), (Object)Utils.getMcc()))) continue;
                        v1 = t;
                        break block19;
                    }
                    v1 = null;
                }
                rateInfo2 = v1;
            } else {
                rateInfo2 = rateInfo = null;
            }
            if (rateInfo == null) {
                RateInfo rateInfo3;
                ArrayList<RateInfo> arrayList2 = configModel.getRate();
                if (arrayList2 != null) {
                    Object v4;
                    block20: {
                        iterable = arrayList2;
                        for (Object t : iterable) {
                            it = (RateInfo)t;
                            boolean bl = false;
                            if (!(Intrinsics.areEqual((Object)it.getAppVersion(), (Object)Utils.getVersionName()) && Intrinsics.areEqual((Object)it.getCountry(), (Object)"*"))) continue;
                            v4 = t;
                            break block20;
                        }
                        v4 = null;
                    }
                    rateInfo3 = v4;
                } else {
                    rateInfo3 = rateInfo = null;
                }
            }
            if (rateInfo == null) {
                RateInfo rateInfo4;
                ArrayList<RateInfo> arrayList3 = configModel.getRate();
                if (arrayList3 != null) {
                    Object v7;
                    block21: {
                        iterable = arrayList3;
                        for (Object t : iterable) {
                            it = (RateInfo)t;
                            boolean bl = false;
                            if (!(Intrinsics.areEqual((Object)it.getAppVersion(), (Object)"*") && Intrinsics.areEqual((Object)it.getCountry(), (Object)Utils.getMcc()))) continue;
                            v7 = t;
                            break block21;
                        }
                        v7 = null;
                    }
                    rateInfo4 = v7;
                } else {
                    rateInfo4 = rateInfo = null;
                }
            }
            if (rateInfo == null) {
                RateInfo rateInfo5;
                ArrayList<RateInfo> arrayList4 = configModel.getRate();
                if (arrayList4 != null) {
                    Object v10;
                    block22: {
                        iterable = arrayList4;
                        for (Object t : iterable) {
                            it = (RateInfo)t;
                            boolean bl = false;
                            if (!(Intrinsics.areEqual((Object)it.getAppVersion(), (Object)"*") && Intrinsics.areEqual((Object)it.getCountry(), (Object)"*"))) continue;
                            v10 = t;
                            break block22;
                        }
                        v10 = null;
                    }
                    rateInfo5 = v10;
                } else {
                    rateInfo5 = null;
                }
                rateInfo = rateInfo5;
            }
            RateInfo rateInfo6 = rateInfo;
            return rateInfo6 != null ? rateInfo6.getRate() : null;
        }
        catch (Throwable t) {
            String string = t.getMessage();
            if (string == null) {
                string = "";
            }
            LogUtil.e$default((LogUtil)LogUtil.INSTANCE, (String)TAG, (String)string, null, (int)4, null);
            return null;
        }
    }

    private final long getLongItem(JSONObject jsonObject, String key, long defaultValue) {
        long ret = defaultValue;
        try {
            ret = jsonObject.getLong(key);
            LogUtil.INSTANCE.d(TAG, "[getLongItem] key:" + key + ", value:" + ret);
        }
        catch (Throwable t) {
            LogUtil.e$default((LogUtil)LogUtil.INSTANCE, (String)TAG, (String)("[getLongItem] key:" + key + ", value[defaultValue]:" + ret + ", fail:" + t), null, (int)4, null);
        }
        return ret;
    }

    private final double getDoubleItem(JSONObject jsonObject, String key, double defaultValue) {
        double ret = defaultValue;
        try {
            ret = jsonObject.getDouble(key);
            LogUtil.INSTANCE.d(TAG, "[getLongItem] key:" + key + ", value:" + ret);
        }
        catch (Throwable t) {
            LogUtil.e$default((LogUtil)LogUtil.INSTANCE, (String)TAG, (String)("[getLongItem] key:" + key + ", value[defaultValue]:" + ret + ", fail:" + t), null, (int)4, null);
        }
        return ret;
    }

    private final int getIntItem(JSONObject jsonObject, String key, int defaultValue) {
        int ret = defaultValue;
        try {
            ret = jsonObject.getInt(key);
            LogUtil.INSTANCE.d(TAG, "[getIntItem] key:" + key + ", value:" + ret);
        }
        catch (Throwable t) {
            LogUtil.e$default((LogUtil)LogUtil.INSTANCE, (String)TAG, (String)("[getIntItem] key:" + key + ", value[defaultValue]:" + ret + ", fail:" + t), null, (int)4, null);
        }
        return ret;
    }

    private final boolean getBooleanItem(JSONObject jsonObject, String key, boolean defaultValue) {
        boolean ret = defaultValue;
        try {
            ret = jsonObject.getBoolean(key);
            LogUtil.INSTANCE.d(TAG, "[getBooleanItem] key:" + key + ", value:" + ret);
        }
        catch (Throwable t) {
            LogUtil.e$default((LogUtil)LogUtil.INSTANCE, (String)TAG, (String)("[getBooleanItem] key:" + key + ", value[defaultValue]:" + ret + ", fail:" + t), null, (int)4, null);
        }
        return ret;
    }

    @SuppressLint(value={"UnspecifiedRegisterReceiverFlag"})
    private final void registerBroadcast(Context context) {
        try {
            LogUtil.INSTANCE.d(TAG, "ConfigManager [registerBroadcast] start");
            IntentFilter filter = new IntentFilter("com.transsin.networkmonitor.config.broadcast.UPDATE_CDN_ACTION");
            if (Build.VERSION.SDK_INT >= 26) {
                context.registerReceiver((BroadcastReceiver)new NetworkUpdateCDNBroadcastReceiver(), filter, 4);
            } else {
                context.registerReceiver((BroadcastReceiver)new NetworkUpdateCDNBroadcastReceiver(), filter);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private final String getStoreName(Context context) {
        CharSequence charSequence = STORE_NAME;
        if (charSequence == null || charSequence.length() == 0) {
            STORE_NAME = "network_config_file_" + StringsKt.replace$default((String)ProcessUtil.INSTANCE.getCurrentProcessName(context), (String)":", (String)"_", (boolean)false, (int)4, null);
        }
        LogUtil.INSTANCE.d(TAG, "[getStoreName] STORE_NAME:" + STORE_NAME);
        String string = STORE_NAME;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public static final /* synthetic */ String access$getStoreName(NetworkConfigManager $this, Context context) {
        return $this.getStoreName(context);
    }

    public static final /* synthetic */ String access$getKEY_CONFIG_DATA$p() {
        return KEY_CONFIG_DATA;
    }

    public static final /* synthetic */ void access$parseStrToModel(NetworkConfigManager $this, String str) {
        $this.parseStrToModel(str);
    }

    public static final /* synthetic */ String access$getKEY_CONFIG_UPDATE_TIME$p() {
        return KEY_CONFIG_UPDATE_TIME;
    }

    public static final /* synthetic */ void access$loadRemoteConfigTask(NetworkConfigManager $this) {
        $this.loadRemoteConfigTask();
    }

    public static final /* synthetic */ void access$sendUpdateConfigBroadcast(NetworkConfigManager $this, Context context, String configStr) {
        $this.sendUpdateConfigBroadcast(context, configStr);
    }

    static {
        KEY_CONFIG_DATA = "key_netinspector_config";
        KEY_CONFIG_UPDATE_TIME = "key_netinspector_update_time";
        isInit = new AtomicBoolean(false);
    }
}

