package com.transsin.datatracer

import android.os.Bundle
import com.google.gson.Gson
import com.transsin.datatracer.DataTracerBean
import com.transsin.networkmonitor.Consts
import com.transsin.networkmonitor.Consts.EVENT_GENERAL_DATA_COLLECTION
import com.transsin.networkmonitor.stat.DataMonitorHelper

class TDataTracer {
    companion object {
        /**
         * 上传耗时类型埋点数据
         * @param eventKey 耗时事件key 例如：cold_cost 代表冷启动时长
         * @param eventValue 耗时时长
         * @param extraValue 自定义扩展字段
         * @param eventName 上报事件名称，默认general_data_collection
         */
        @JvmOverloads
        fun traceDurationTime(
            eventKey: String,
            eventValue: String = "",
            extraValue: String = "",
            eventName: String = EVENT_GENERAL_DATA_COLLECTION
        ) {
            val bundle = Bundle()
            bundle.putString("event_type", Consts.EventType.TYPE_DURATION)
            bundle.putString("event_key", eventKey)
            bundle.putString("event_value", eventValue)
            bundle.putString("event_extra", extraValue)
            bundle.putString("event_message", "")
            bundle.putString("event_stack", "")
            bundle.putString("event_code", "")
            DataMonitorHelper.commitCustomStat(eventName, bundle)
        }

        /**
         * 上传判断是否成功类型埋点数据
         *
         * @param eventKey 成功类型事件key 例如：login_successful 代表登录是否成功
         * @param eventValue  是否成功 "0"或者"1"。0代表成功，1代表失败
         * @param eventCode 事件错误code
         * @param eventMessage 事件错误描述
         * @param eventStack 事件错误栈信息
         * @param extraValue 自定义扩展字段
         * @param eventName 上报事件名称，默认general_data_collection
         */
        @JvmOverloads
        fun traceIsSuccess(
            eventKey: String, eventValue: String = "", eventCode: String = "",
            eventMessage: String = "", eventStack: String = "", extraValue: String = "",
            eventName: String = EVENT_GENERAL_DATA_COLLECTION
        ) {
            val bundle = Bundle()
            bundle.putString("event_type", Consts.EventType.TYPE_SUCCESS_RATE)
            bundle.putString("event_key", eventKey)
            bundle.putString("event_value", eventValue)
            bundle.putString("event_extra", extraValue)
            bundle.putString("event_code", eventCode)
            bundle.putString("event_message", eventMessage)
            bundle.putString("event_stack", eventStack)
            DataMonitorHelper.commitCustomStat(eventName, bundle)
        }

        /**
         * 上传计数类埋点数据
         * @param eventKey 计数类型事件key 例如：click_count表示点击次数
         * @param extraValue 自定义扩展字段
         * @param eventName 上报事件名称，默认general_data_collection
         */
        fun traceCountType(
            eventKey: String,
            extraValue: String = "",
            eventName: String = EVENT_GENERAL_DATA_COLLECTION
        ) {
            val bundle = Bundle()
            bundle.putString("event_type", Consts.EventType.TYPE_COUNT)
            bundle.putString("event_key", eventKey)
            bundle.putString("event_value", "")
            bundle.putString("event_extra", extraValue)
            bundle.putString("event_code", "")
            bundle.putString("event_message", "")
            bundle.putString("event_stack", "")
            DataMonitorHelper.commitCustomStat(eventName, bundle)
        }




        //firebase 存在value长度限制，所以
        /**
         * 一次上报多个key，value数据
         */
        /*fun trace(
            list: List<DataTracerBean>,
            totalExtra: String = "",
            eventName: String = EVENT_GENERAL_DATA_COLLECTION
        ) {
            val bundle = Bundle()
            val gson = Gson()
            val json = gson.toJson(list)
            bundle.putString("total_event", json)
            bundle.putString("total_extra", totalExtra)
            DataMonitorHelper.commitCustomStat(eventName, bundle)
        }*/
    }
}