package com.transsin.networkmonitor

/**
 * @Author:huangxiushuo
 * @Date: 2023-05-17 10:37
 * @Description:
 */
object HostMatcher {
    //黑名单域名
    private var matchBlackHosts = arrayOf<String>()
    //白名单域名
    private var matchWhiteHosts = arrayOf<String>()
    //和黑名单域名一起判断是否加入黑名单
    private var hostMatcherListener: IHostMatcherListener? = null
    internal fun setHosts(hosts: Array<String>) {
        matchRules = hosts
    }
    private var matchRules = arrayOf<String>()

    @JvmStatic
    fun match(host: String) = matchRules.contains(host)

    @JvmStatic
    fun noHosts() = matchRules.isEmpty()

    @JvmStatic
    fun matchBlackHost(host: String) = matchBlackHosts.contains(host)

    fun matchBlackListener(usage: Int, host: String, path: String, serverApi: String): Boolean {
        if (hostMatcherListener != null) {
            return hostMatcherListener!!.shouldAddBlack(usage, host, path, serverApi)
        }
        return true
    }
    @JvmStatic
    fun setBlackHosts(hosts: Array<String>, listener: IHostMatcherListener? = null) {
        this.matchBlackHosts = hosts
        this.hostMatcherListener = listener
    }

    fun setWhiteHosts(hosts: Array<String>) {
        matchWhiteHosts = hosts
    }

    @JvmStatic
    fun matchWhiteHost(host: String) = matchWhiteHosts.contains(host)
}