package com.transsin.webviewmonitor


object WebConstant {
    const val WEBVIEW_ERROR = "webview_moniter_error"

    const val WEB_OPEN_COUNT = "webview_moniter_open_count" // 页面打开
    const val WEB_OPEN_BLANK = "webview_moniter_open_blank" // 页面打开白屏

    /**
     * web error type
     */
    const val SSL = "ssl"
    const val ERROR = "error"

    /**
     * web load state
     */
    const val STATUS_SUCCESS = "1"
    const val STATUS_FAIL = "0"
    const val MAIN_URL = "main_url"
    const val ERROR_TYPE = "error_type"
    const val WEB_ID = "web_id"
    const val WEB_BLANK_SWITCH = "web_blank_switch"
    const val WEBVIEW_MONITOR_INTERFACE = "WebViewMonitorInterface"//用于webview白屏监控，接口名称

    const val SSL_ERROR_CODE_SSL_NOTYETVALID = 0 // 证书尚未生效
    const val SSL_ERROR_CODE_SSL_EXPIRED = 1 // 日期过期
    const val SSL_ERROR_CODE_SSL_IDMISMATCH = 2 // 根证书不匹配
    const val SSL_ERROR_CODE_SSL_UNTRUSTED = 3 // 根证书丢失
    const val SSL_ERROR_CODE_SSL_DATE_INVALID = 4 // 日期失效
    const val SSL_ERROR_CODE_SSL_INVALID = 5 // webview BUG

    val SSL_ERROE_MSG = mutableMapOf(
        SSL_ERROR_CODE_SSL_NOTYETVALID to "证书尚未生效",
        SSL_ERROR_CODE_SSL_EXPIRED to "日期过期",
        SSL_ERROR_CODE_SSL_IDMISMATCH to "根证书不匹配",
        SSL_ERROR_CODE_SSL_UNTRUSTED to "根证书丢失",
        SSL_ERROR_CODE_SSL_DATE_INVALID to "日期失效",
        SSL_ERROR_CODE_SSL_INVALID to "webview BUG",
    )

    const val ERROR_UNKNOWN = -1 // 一般错误
    const val ERROR_HOST_LOOKUP = -2 // 服务器或代理主机名查找失败
    const val ERROR_UNSUPPORTED_AUTH_SCHEME = -3 // 不支持的身份验证方案（不是基本或摘要）
    const val ERROR_AUTHENTICATION = -4 // 服务器上的用户身份验证失败
    const val ERROR_PROXY_AUTHENTICATION = -5 // 代理上的用户身份验证失败
    const val ERROR_CONNECT = -6 // 无法连接到服务器
    const val ERROR_IO = -7 // 无法读取或写入服务器
    const val ERROR_TIMEOUT = -8 // 连接超时
    const val ERROR_REDIRECT_LOOP = -9 // 重定向太多
    const val ERROR_UNSUPPORTED_SCHEME = -10 // 不支持的 URI 方案
    const val ERROR_FAILED_SSL_HANDSHAKE = -11 // 无法执行 SSL 握手
    const val ERROR_BAD_URL = -12 // 网址格式错误
    const val ERROR_FILE = -13 // 一般文件错误
    const val ERROR_FILE_NOT_FOUND = -14 // 文件未找到
    const val ERROR_TOO_MANY_REQUESTS = -15 // 在此负载期间请求过多
    const val ERROR_UNSAFE_RESOURCE = -16 // 安全浏览取消了资源加载

    const val SAFE_BROWSING_THREAT_UNKNOWN = 0 // 该资源因未知原因被阻止
    const val SAFE_BROWSING_THREAT_MALWARE = 1 // 该资源因包含恶意软件而被阻止
    const val SAFE_BROWSING_THREAT_PHISHING = 2 // 该资源因包含欺骗性内容而被阻止
    const val SAFE_BROWSING_THREAT_UNWANTED_SOFTWARE = 3 // 该资源被阻止，因为它包含不需要的软件
    const val SAFE_BROWSING_THREAT_BILLING = 4 // 该资源被阻止是因为它可能会欺骗用户签订计费协议 (api >= 29)



    val ERROR_MSG = mutableMapOf(
        ERROR_UNKNOWN to "一般错误",
        ERROR_HOST_LOOKUP to "服务器或代理主机名查找失败",
        ERROR_UNSUPPORTED_AUTH_SCHEME to "不支持的身份验证方案（不是基本或摘要）",
        ERROR_AUTHENTICATION to "服务器上的用户身份验证失败",
        ERROR_PROXY_AUTHENTICATION to "代理上的用户身份验证失败",
        ERROR_CONNECT to "无法连接到服务器",
        ERROR_IO to "无法读取或写入服务器",
        ERROR_TIMEOUT to "连接超时",
        ERROR_REDIRECT_LOOP to "重定向太多",
        ERROR_UNSUPPORTED_SCHEME to "不支持的 URI 方案",
        ERROR_FAILED_SSL_HANDSHAKE to "无法执行 SSL 握手",
        ERROR_BAD_URL to "网址格式错误",
        ERROR_FILE to "一般文件错误",
        ERROR_FILE_NOT_FOUND to "文件未找到",
        ERROR_TOO_MANY_REQUESTS to "在此负载期间请求过多",
        ERROR_UNSAFE_RESOURCE to "安全浏览取消了资源加载",
        SAFE_BROWSING_THREAT_UNKNOWN to "该资源因未知原因被阻止",
        SAFE_BROWSING_THREAT_MALWARE to "该资源因包含恶意软件而被阻止",
        SAFE_BROWSING_THREAT_PHISHING to "该资源因包含欺骗性内容而被阻止",
        SAFE_BROWSING_THREAT_UNWANTED_SOFTWARE to "该资源被阻止，因为它包含不需要的软件",
        SAFE_BROWSING_THREAT_BILLING to "该资源被阻止是因为它可能会欺骗用户签订计费协议 (api >= 29)"
    )

}
