package com.transsin.webviewmonitor

import java.util.UUID

data class WebPageBean(
    var url: String = "", // 落地页原始地址
    var targetUrl: String = "", // 落地页目标地址
    var redirectType: Int = 0, // 重定向类型  默认 0， 1、gp 2、deeplink
    var pageClickTime: Long = 0, // page click time
    var initEndTime: Long = 0, // web init end time
    var loadStartTime: Long = 0, // onpagestart time
    var spendEndTime: Long = 0, // 耗时结束时间
    var jumpTime: Long = 0, // 跳出时间
    var errorType: String? = null, // 错误类型
    var errorCode: Int = 0 // 错误码
) {
    val webId: String = UUID.randomUUID().toString().replace("-", "")

    @JvmName("getUrl1")
    fun getUrl(): String {
        return url ?: ""
    }

    @JvmName("getTargetUrl1")
    fun getTargetUrl(): String {
        return targetUrl ?: ""
    }

    fun getInitTime(): Long {
        return initEndTime - pageClickTime
    }

    fun getLoadTime(): Long {
        return loadStartTime - pageClickTime
    }

    fun getSpendTime(): Long {
        return spendEndTime - loadStartTime
    }

    fun getWaitTime(): Long { // 等待时间
        return jumpTime - pageClickTime
    }
}
