/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.datatracer.webview;

import android.graphics.Bitmap;
import android.net.http.SslError;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import androidx.annotation.RequiresApi;
import com.transsin.datatracer.TDataTracer;
import com.transsin.networkmonitor.R;
import com.transsin.webviewmonitor.WebConstant;
import com.transsin.webviewmonitor.WebPageBean;
import com.transsin.webviewmonitor.WebViewMonitorInterface;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J$\u0010\u0012\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J&\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J,\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004J&\u0010\u001f\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010 \u001a\u0004\u0018\u00010!H\u0007J$\u0010\"\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010\u0019\u001a\u0004\u0018\u00010%J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/transsion/datatracer/webview/WebViewMonitorHelper;", "", "()V", "TAG", "", "webViewUrlMap", "", "Lcom/transsin/webviewmonitor/WebPageBean;", "webviewBlankMonitorSwitch", "", "injectJavaScript", "", "webView", "Landroid/webkit/WebView;", "isUrlMatch", "loadUrl", "url", "onLoadUrl", "onPageStarted", "favicon", "Landroid/graphics/Bitmap;", "onReceivedError", "view", "request", "Landroid/webkit/WebResourceRequest;", "error", "Landroid/webkit/WebResourceError;", "errorCode", "", "description", "failingUrl", "onReceivedHttpError", "errorResponse", "Landroid/webkit/WebResourceResponse;", "onReceivedSslError", "handler", "Landroid/webkit/SslErrorHandler;", "Landroid/net/http/SslError;", "setWebviewBlankMonitorSwitch", "switch", "lib-networkmonitor_release"})
public final class WebViewMonitorHelper {
    @NotNull
    public static final WebViewMonitorHelper INSTANCE = new WebViewMonitorHelper();
    @NotNull
    public static final String TAG = "WebViewMonitorHelper";
    @NotNull
    private static Map<String, WebPageBean> webViewUrlMap = new LinkedHashMap();
    private static boolean webviewBlankMonitorSwitch;

    private WebViewMonitorHelper() {
    }

    @JvmStatic
    public static final void setWebviewBlankMonitorSwitch(boolean bl) {
        webviewBlankMonitorSwitch = bl;
    }

    @JvmStatic
    public static final void onLoadUrl(@NotNull WebView webView, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            String string;
            webView.getSettings().setJavaScriptEnabled(true);
            WebPageBean webPageBean = new WebPageBean(null, null, 0, 0L, 0L, 0L, 0L, 0L, null, 0, 1023, null);
            webPageBean.setUrl(url);
            webView.setTag(R.id.webview_monitor_id, (Object)webPageBean.getWebId());
            webViewUrlMap.put(webPageBean.getWebId(), webPageBean);
            webView.addJavascriptInterface((Object)new WebViewMonitorInterface(), "WebViewMonitorInterface");
            JSONObject jsonObject = new JSONObject();
            String it = webPageBean.getUrl();
            boolean bl = false;
            if (it.length() > 60) {
                String string2 = it.substring(0, 60);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            } else {
                string = it;
            }
            String extraUrl = string;
            jsonObject.put("main_url", (Object)extraUrl);
            jsonObject.put("web_blank_switch", webviewBlankMonitorSwitch);
            String string3 = jsonObject.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jsonObject.toString()");
            TDataTracer.Companion.traceCountType$default(TDataTracer.Companion, "webview_moniter_open_count", string3, null, 4, null);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    public final void onReceivedError(@Nullable WebView view, int errorCode, @Nullable String description, @Nullable String failingUrl) {
        try {
            WebView webView = view;
            WebPageBean webPageBean = webViewUrlMap.get(webView != null ? webView.getTag(R.id.webview_monitor_id) : null);
            if (webPageBean == null) {
                return;
            }
            WebPageBean webPageBean2 = webPageBean;
            if (!TextUtils.isEmpty((CharSequence)failingUrl)) {
                String string = webPageBean2.getUrl();
                String string2 = failingUrl;
                if (string2 == null) {
                    string2 = "";
                }
                if (this.isUrlMatch(string, string2)) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("main_url", (Object)webPageBean2.getUrl());
                    jsonObject.put("error_type", (Object)"error");
                    String string3 = String.valueOf(errorCode);
                    String string4 = WebConstant.INSTANCE.getERROR_MSG().get(errorCode);
                    if (string4 == null) {
                        string4 = "unknown error";
                    }
                    String string5 = jsonObject.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"jsonObject.toString()");
                    TDataTracer.Companion.traceIsSuccess$default(TDataTracer.Companion, "webview_moniter_error", "0", string3, string4, "", string5, null, 64, null);
                }
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    @RequiresApi(value=23)
    public final void onReceivedError(@Nullable WebView view, @Nullable WebResourceRequest request, @Nullable WebResourceError error) {
        try {
            WebView webView = view;
            WebPageBean webPageBean = webViewUrlMap.get(webView != null ? webView.getTag(R.id.webview_monitor_id) : null);
            if (webPageBean == null) {
                return;
            }
            WebPageBean webPageBean2 = webPageBean;
            WebResourceRequest webResourceRequest = request;
            if (!TextUtils.isEmpty((CharSequence)String.valueOf(webResourceRequest != null ? webResourceRequest.getUrl() : null))) {
                WebResourceRequest webResourceRequest2 = request;
                if (this.isUrlMatch(webPageBean2.getUrl(), String.valueOf(webResourceRequest2 != null ? webResourceRequest2.getUrl() : null))) {
                    String string;
                    JSONObject jsonObject = new JSONObject();
                    String it = webPageBean2.getUrl();
                    boolean bl = false;
                    if (it.length() > 60) {
                        String string2 = it.substring(0, 60);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    } else {
                        string = it;
                    }
                    String extraUrl = string;
                    jsonObject.put("main_url", (Object)extraUrl);
                    jsonObject.put("error_type", (Object)"error");
                    WebResourceError webResourceError = error;
                    String string3 = String.valueOf(webResourceError != null ? Integer.valueOf(webResourceError.getErrorCode()) : null);
                    WebResourceError webResourceError2 = error;
                    String string4 = WebConstant.INSTANCE.getERROR_MSG().get(webResourceError2 != null ? Integer.valueOf(webResourceError2.getErrorCode()) : null);
                    if (string4 == null) {
                        string4 = "unknown error";
                    }
                    String string5 = jsonObject.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"jsonObject.toString()");
                    TDataTracer.Companion.traceIsSuccess$default(TDataTracer.Companion, "webview_moniter_error", "0", string3, string4, "", string5, null, 64, null);
                }
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    @RequiresApi(value=21)
    public final void onReceivedHttpError(@Nullable WebView view, @Nullable WebResourceRequest request, @Nullable WebResourceResponse errorResponse) {
        try {
            WebView webView = view;
            WebPageBean webPageBean = webViewUrlMap.get(webView != null ? webView.getTag(R.id.webview_monitor_id) : null);
            if (webPageBean == null) {
                return;
            }
            WebPageBean webPageBean2 = webPageBean;
            WebResourceRequest webResourceRequest = request;
            if (!TextUtils.isEmpty((CharSequence)String.valueOf(webResourceRequest != null ? webResourceRequest.getUrl() : null))) {
                WebResourceRequest webResourceRequest2 = request;
                if (this.isUrlMatch(webPageBean2.getUrl(), String.valueOf(webResourceRequest2 != null ? webResourceRequest2.getUrl() : null))) {
                    String string;
                    JSONObject jsonObject = new JSONObject();
                    String it = webPageBean2.getUrl();
                    boolean bl = false;
                    if (it.length() > 60) {
                        String string2 = it.substring(0, 60);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    } else {
                        string = it;
                    }
                    String extraUrl = string;
                    jsonObject.put("main_url", (Object)extraUrl);
                    jsonObject.put("error_type", (Object)"error");
                    WebResourceResponse webResourceResponse = errorResponse;
                    String string3 = String.valueOf(webResourceResponse != null ? Integer.valueOf(webResourceResponse.getStatusCode()) : null);
                    WebResourceResponse webResourceResponse2 = errorResponse;
                    String string4 = WebConstant.INSTANCE.getERROR_MSG().get(webResourceResponse2 != null ? Integer.valueOf(webResourceResponse2.getStatusCode()) : null);
                    if (string4 == null) {
                        string4 = "unknown error";
                    }
                    String string5 = jsonObject.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"jsonObject.toString()");
                    TDataTracer.Companion.traceIsSuccess$default(TDataTracer.Companion, "webview_moniter_error", "0", string3, string4, "", string5, null, 64, null);
                }
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    public final void onReceivedSslError(@Nullable WebView view, @Nullable SslErrorHandler handler, @Nullable SslError error) {
        try {
            WebView webView = view;
            WebPageBean webPageBean = webViewUrlMap.get(webView != null ? webView.getTag(R.id.webview_monitor_id) : null);
            if (webPageBean == null) {
                return;
            }
            WebPageBean webPageBean2 = webPageBean;
            SslError sslError = error;
            if (!TextUtils.isEmpty((CharSequence)String.valueOf(sslError != null ? sslError.getUrl() : null))) {
                SslError sslError2 = error;
                if (this.isUrlMatch(webPageBean2.getUrl(), String.valueOf(sslError2 != null ? sslError2.getUrl() : null))) {
                    String string;
                    JSONObject jsonObject = new JSONObject();
                    String it = webPageBean2.getUrl();
                    boolean bl = false;
                    if (it.length() > 60) {
                        String string2 = it.substring(0, 60);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    } else {
                        string = it;
                    }
                    String extraUrl = string;
                    jsonObject.put("main_url", (Object)extraUrl);
                    jsonObject.put("error_type", (Object)"ssl");
                    SslError sslError3 = error;
                    String string3 = String.valueOf(sslError3 != null ? Integer.valueOf(sslError3.getPrimaryError()) : null);
                    SslError sslError4 = error;
                    String string4 = WebConstant.INSTANCE.getSSL_ERROE_MSG().get(sslError4 != null ? Integer.valueOf(sslError4.getPrimaryError()) : null);
                    if (string4 == null) {
                        string4 = "unknown ssl error";
                    }
                    String string5 = jsonObject.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"jsonObject.toString()");
                    TDataTracer.Companion.traceIsSuccess$default(TDataTracer.Companion, "webview_moniter_error", "0", string3, string4, "", string5, null, 64, null);
                }
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    public final void onPageStarted(@Nullable WebView webView, @Nullable String url, @Nullable Bitmap favicon) {
        try {
            this.injectJavaScript(webView);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    private final void injectJavaScript(WebView webView) {
        if (webView == null) {
            return;
        }
        String webjsCode = "(function(){\"use strict\";let s=null,m=null,i=0;const r=e=>{try{const t=[Math.round(window.innerWidth/2),Math.round(window.innerHeight/2)],n=document.elementFromPoint(t[0],t[1]);let a=n==null?void 0:n.tagName.toLocaleLowerCase(),c=!1,l=0;switch(a){case\"canvas\":l=n.toDataURL().length;break;case\"iframe\":const o=n.contentDocument.elementFromPoint(t[0],t[1]);a=o.tagName.toLocaleLowerCase(),l=a===\"canvas\"?o.toDataURL().length:0;break;default:}if([\"html\",\"body\"].indexOf(a)>-1?c=!0:a===\"canvas\"&&(i===0&&(i=u()),c=l<=i),c){const o=location.origin+location.pathname;WebViewMonitorInterface.reportBlank(o,e)}else clearTimeout(s),clearTimeout(m)}catch{}};function u(){try{const e=document.createElement(\"canvas\");return e.width=window.innerWidth,e.height=window.innerHeight-55,e.toDataURL().length}catch{return 1e4}}setTimeout(()=>r(\"5\"),5e3),s=setTimeout(()=>r(\"10\"),1e4),m=setTimeout(()=>r(\"15\"),15e3)})();";
        if (webviewBlankMonitorSwitch) {
            webView.evaluateJavascript(webjsCode, null);
        }
    }

    public final boolean isUrlMatch(@NotNull String loadUrl, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)loadUrl, (String)"loadUrl");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return StringsKt.startsWith$default((String)url, (String)loadUrl, (boolean)false, (int)2, null);
    }
}

