package com.transsin.networkmonitor.stat

import android.content.Context
import android.os.Bundle
import com.shalltry.aisearch.core.AIDataLog
import com.shalltry.aisearch.core.AIDataSDK
import com.shalltry.aisearch.core.WorkMode
import com.transsin.networkmonitor.config.NetworkConfigManager

class RealDataMonitor(context: Context, appId: String) : IMonitor {


    init {
        try {
            val mode = if (NetworkConfigManager.mIsTest) WorkMode.MODE_DEV else WorkMode.MODE_ONLINE
            AIDataSDK.initSDK(context, appId, "", mode)
        } catch (t: Throwable) {
            t.printStackTrace()
        }
    }

    override fun commitStat(tag: String, bundle: Bundle?) {
        AIDataLog.I(tag, bundle)
    }
}