package com.transsin.webviewmonitor

import android.text.TextUtils
import android.util.Log
import android.webkit.JavascriptInterface
import com.transsin.networkmonitor.Utils
import com.transsin.webviewmonitor.WebConstant.WEB_OPEN_BLANK
import com.transsion.datatracer.com.transsion.datatracer.TDataTracer

class WebViewMonitorInterface {

    companion object {
        const val TAG = "WebViewMonitorInterface"
    }

    @JavascriptInterface
    fun reportBlank(url: String, checkTime: String) {
        try {
            //回调的url为空，说明是无网打开，不上报白屏事件
            if(url.isEmpty() || TextUtils.equals(url, "null/")) {
                Log.d(Utils.GLOBAL_TAG, "reportBlank--url.isEmpty()")
                return
            }
            TDataTracer.traceCountType("${WEB_OPEN_BLANK}_$checkTime", url)
        } catch (e: Exception) {
            Log.e(TAG, Log.getStackTraceString(e))
        }
    }
}