/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.LocaleList;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.transsin.util.GlobalUtils;
import java.lang.reflect.Method;
import java.util.Locale;

public class Utils {
    public static final String GLOBAL_TAG = "NetworkMonitor";
    private static String mcc = "";
    private static String versionName = "";

    public static String getCountry() {
        String country = "";
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Method get = systemProperties.getMethod("get", String.class, String.class);
            country = (String)get.invoke(systemProperties, "persist.sys.oobe_country", "unknown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TextUtils.isEmpty((CharSequence)country) || "unknown".equals(country)) {
            country = Utils.getLocale().getCountry();
        }
        return country;
    }

    public static String getMcc() {
        try {
            if (!TextUtils.isEmpty((CharSequence)mcc)) {
                return mcc;
            }
            Context context = GlobalUtils.INSTANCE.getContext();
            if (context == null) {
                return mcc;
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String networkOperator = telephonyManager.getNetworkOperator();
            if (networkOperator != null && networkOperator.length() >= 3) {
                mcc = networkOperator.substring(0, 3);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return mcc;
    }

    private static Locale getLocale() {
        Locale locale;
        try {
            locale = Build.VERSION.SDK_INT >= 24 ? LocaleList.getDefault().get(0) : Locale.getDefault();
        }
        catch (Exception e) {
            locale = Locale.getDefault();
            Log.d((String)"Utils", (String)Log.getStackTraceString((Throwable)e));
        }
        return locale;
    }

    public static String getVersionName() {
        try {
            if (!TextUtils.isEmpty((CharSequence)versionName)) {
                return versionName;
            }
            Context context = GlobalUtils.INSTANCE.getContext();
            if (context != null) {
                PackageManager packageManager = context.getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
                versionName = packageInfo.versionName;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            versionName = "";
        }
        return versionName;
    }
}

