/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor.trace;

import android.os.Process;
import android.util.Log;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u0006H\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/transsin/networkmonitor/trace/TraceIdInterceptor;", "Lokhttp3/Interceptor;", "()V", "index", "Ljava/util/concurrent/atomic/AtomicInteger;", "convertIPToHex", "", "clientIp", "genSpanId", "genTraceId", "getClientIpFromChain", "chain", "Lokhttp3/Interceptor$Chain;", "getCurrentProcessID", "getLocalIpAddress", "getNextIndex", "", "intercept", "Lokhttp3/Response;", "Companion", "lib-networkmonitor_release"})
@SourceDebugExtension(value={"SMAP\nTraceIdInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraceIdInterceptor.kt\ncom/transsin/networkmonitor/trace/TraceIdInterceptor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,168:1\n37#2,2:169\n*S KotlinDebug\n*F\n+ 1 TraceIdInterceptor.kt\ncom/transsin/networkmonitor/trace/TraceIdInterceptor\n*L\n129#1:169,2\n*E\n"})
public final class TraceIdInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicInteger index = new AtomicInteger(100000);
    @NotNull
    private static final Random random = new Random();
    @NotNull
    private static final char[] digits;
    private static final int INCR_MIN = 100000;
    private static final int INCR_MAX = 999999;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        String clientIp = this.getClientIpFromChain(chain);
        String traceId = this.genTraceId(clientIp);
        Log.d((String)"TraceIdInterceptor", (String)("generate trace id:" + traceId));
        Request request = chain.request().newBuilder().addHeader("traceparent", traceId).build();
        Response response = chain.proceed(request);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"chain.proceed(request)");
        return response;
    }

    @NotNull
    public final String genTraceId(@NotNull String clientIp) {
        Intrinsics.checkNotNullParameter((Object)clientIp, (String)"clientIp");
        StringBuilder sb = new StringBuilder();
        sb.append("00-");
        sb.append(this.convertIPToHex(clientIp));
        sb.append(System.currentTimeMillis());
        sb.append(this.getCurrentProcessID());
        sb.append(this.getNextIndex());
        sb.append("-");
        sb.append(this.genSpanId());
        sb.append("-01");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final String genSpanId() {
        return Companion.toHexStr(random.nextLong());
    }

    private final String getClientIpFromChain(Interceptor.Chain chain) {
        String string;
        try {
            Route route;
            Connection connection = chain.connection();
            Object object = route = connection != null ? connection.route() : null;
            if (route != null) {
                InetSocketAddress proxyAddress;
                Proxy proxy = route.proxy();
                SocketAddress socketAddress = proxy.address();
                InetSocketAddress inetSocketAddress = proxyAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
                if (proxy.type() != Proxy.Type.DIRECT && proxyAddress != null) {
                    String string2 = proxyAddress.getHostString();
                    if (string2 == null) {
                        string2 = this.getLocalIpAddress();
                    }
                    return string2;
                }
            }
            string = this.getLocalIpAddress();
        }
        catch (Exception e) {
            string = this.getLocalIpAddress();
        }
        return string;
    }

    private final String getLocalIpAddress() {
        Object object;
        try {
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress inetAddress : Collections.list(networkInterface.getInetAddresses())) {
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    String string = ((Inet4Address)inetAddress).getHostAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"inetAddress.hostAddress");
                    return string;
                }
            }
            object = "0.0.0.0";
        }
        catch (Exception e) {
            object = "0.0.0.0";
        }
        return object;
    }

    private final String convertIPToHex(String clientIp) {
        CharSequence charSequence = clientIp;
        Regex regex = new Regex("\\.");
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] items = thisCollection$iv.toArray(new String[0]);
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[i] = (byte)Integer.parseInt(items[i]);
        }
        StringBuilder sb = new StringBuilder(bytes.length / 2);
        for (byte b : bytes) {
            sb.append(Integer.toHexString(b >> 4 & 0xF));
            sb.append(Integer.toHexString(b & 0xF));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    protected final int getNextIndex() {
        int c = 3;
        while (c-- > 0) {
            int num = this.index.incrementAndGet();
            if (num > 999999) {
                if (!this.index.compareAndSet(num, 100000)) continue;
                return 100000;
            }
            return num;
        }
        int lastNum = this.index.incrementAndGet();
        return lastNum > 999999 ? lastNum % 100000 + 100000 : lastNum;
    }

    private final String getCurrentProcessID() {
        return String.valueOf(Process.myPid());
    }

    static {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        digits = cArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/transsin/networkmonitor/trace/TraceIdInterceptor$Companion;", "", "()V", "INCR_MAX", "", "INCR_MIN", "digits", "", "random", "Ljava/util/Random;", "formatUnsignedLong", "val", "", "shift", "buf", "offset", "len", "toHexStr", "", "i", "toUnsignedString0", "lib-networkmonitor_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String toHexStr(long i) {
            return this.toUnsignedString0(i, 4);
        }

        @NotNull
        public final String toUnsignedString0(long val, int shift) {
            int mag = 64 - Long.numberOfLeadingZeros(val);
            int chars = Math.max((mag + shift - 1) / shift, 1);
            char[] buf = new char[16];
            int offset = 16 - chars;
            for (int i = 0; i < offset; ++i) {
                buf[i] = 48;
            }
            this.formatUnsignedLong(val, shift, buf, 16 - chars, chars);
            return new String(buf);
        }

        public final int formatUnsignedLong(long val, int shift, @NotNull char[] buf, int offset, int len) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            int charPos = len;
            long value = val;
            int radix = 1 << shift;
            int mask = radix - 1;
            do {
                buf[offset + --charPos] = digits[(int)value & mask];
            } while ((value >>>= shift) != 0L && charPos > 0);
            return charPos;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

