package com.transsin.networkmonitor

/**
 * @Author:huangxiushuo
 * @Date: 2023-05-23 14:13
 * @Description:
 */
object Consts {
    const val APP_ID = 1814
    const val REPORT_ID = 10003
    const val CHANNEL = "NetworkMonitor"
    const val EVENT = "process"
    const val EVENT_MONITOR_INIT = "monitor_init"
    const val EVENT_BLACK = "process_black"
    const val EVENT_WHITE = "process_white"
    const val MSG_EVENT = "error_message"
    const val EVENT_GENERAL_DATA_COLLECTION = "general_data_collection"
    //异常信息
    const val THROWABLE_EVENT = "throwable"
    const val SUCCESS = 1
    const val FAILURE = 2

    const val NORMAL = 0
    const val DOWNLOAD = 1

    /**
     * 网络状态
     */
    interface NetStatus {
        companion object {
            const val CONNECT_NETWORK  = "0"//有网
            const val NO_NETWORK  = "1"//无网
            const val FAKE_NETWORK = "2"//假网
        }
    }
    /**
     * 事件类型
     */
    interface EventType {
        companion object {
            const val TYPE_DURATION = "0"//耗时类型
            const val TYPE_SUCCESS_RATE = "1"//成功率类型
            const val TYPE_COUNT = "2"//计数类型
        }
    }

    /**
     * 参数类型
     */
    enum class ParamTypes {
        MATCH_HOST, MATCH_PATH, MATCH_SERVERAPI
    }
}
