package com.transsin.networkmonitor

import android.util.Log
import java.lang.Exception

object CustomMatcher {
    private var customMatchParams = listOf<Triple<List<String>, Consts.ParamTypes, String>>()

    /**
     * 自定义匹配
     * 参数为匹配目标，匹配类型，事件名
     */
    @JvmStatic
    fun setCustomMatchParams(params: List<Triple<List<String>, Consts.ParamTypes, String>>) {
        customMatchParams = params
    }

    @JvmStatic
    fun matchCustomParams(host: String, path: String, serverApi: String): String{
        try{
            val iterator = customMatchParams.iterator()

            while (iterator.hasNext()) {
                val param = iterator.next()
                val matchTarget = when (param.second) {
                    Consts.ParamTypes.MATCH_HOST -> host
                    Consts.ParamTypes.MATCH_PATH -> path
                    Consts.ParamTypes.MATCH_SERVERAPI -> serverApi
                }
                if (param.first.contains(matchTarget)) {
                    return param.third.ifEmpty { Consts.EVENT }
                }
            }
        }catch(e: Exception){
            Log.d(Utils.GLOBAL_TAG, Log.getStackTraceString(e))
        }
        return Consts.EVENT
    }
}