package com.transsin.networkmonitor

/**
 * 反射工具类
 */
object ReflectionUtil {
    fun callMethod(instance: Any, methodName: String, vararg args: Any) {
        try {
            val method = instance.javaClass.getDeclaredMethod(
                methodName,
                *args.map { it.javaClass }.toTypedArray()
            )
            method.isAccessible = true
            method.invoke(instance, *args)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    fun getField(instance: Any, fieldName: String): Any? {
        return runCatching {
            val field = instance.javaClass.getDeclaredField(fieldName)
            field.isAccessible = true
            field.get(instance)
        }.getOrNull()
    }

}