/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.sdk.oneid.crypto.crypter;

import android.annotation.SuppressLint;
import android.os.Build;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import javax.crypto.Cipher;
import oneid.a;

public class RsaEcsPKCS1KeystoreCrypter
extends a {
    private Cipher mDecrypter;
    private Cipher mEncrypter;
    private Key mPrivateKey;
    private Key mPublicKey;

    @SuppressLint(value={"TrulyRandom"})
    private void ensureEncrypter() throws Exception {
        RsaEcsPKCS1KeystoreCrypter rsaEcsPKCS1KeystoreCrypter = this;
        rsaEcsPKCS1KeystoreCrypter.getKeyPair();
        if (rsaEcsPKCS1KeystoreCrypter.mEncrypter == null) {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, this.mPublicKey);
            this.mEncrypter = cipher;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureDecrypter() throws Exception {
        try {
            RsaEcsPKCS1KeystoreCrypter rsaEcsPKCS1KeystoreCrypter = this;
            rsaEcsPKCS1KeystoreCrypter.getKeyPair();
            if (rsaEcsPKCS1KeystoreCrypter.mDecrypter != null) return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new Exception("NoClassDefFound...");
        }
        RsaEcsPKCS1KeystoreCrypter rsaEcsPKCS1KeystoreCrypter = this;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        int n = 2;
        cipher.init(n, this.mPrivateKey);
        rsaEcsPKCS1KeystoreCrypter.mDecrypter = cipher;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getKeyPair() throws Exception {
        if (((RsaEcsPKCS1KeystoreCrypter)((Object)privateKeyEntry)).mPrivateKey != null) {
            if (((RsaEcsPKCS1KeystoreCrypter)((Object)privateKeyEntry)).mPublicKey != null) return;
        }
        KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
        keyStore.load(null);
        if (Build.VERSION.SDK_INT >= 28) {
            ((RsaEcsPKCS1KeystoreCrypter)((Object)privateKeyEntry)).mPrivateKey = keyStore.getKey("crypto", null);
            ((RsaEcsPKCS1KeystoreCrypter)((Object)privateKeyEntry)).mPublicKey = keyStore.getCertificate("crypto").getPublicKey();
            return;
        }
        RsaEcsPKCS1KeystoreCrypter rsaEcsPKCS1KeystoreCrypter = privateKeyEntry;
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry("crypto", null);
        rsaEcsPKCS1KeystoreCrypter.mPrivateKey = privateKeyEntry.getPrivateKey();
        rsaEcsPKCS1KeystoreCrypter.mPublicKey = privateKeyEntry.getCertificate().getPublicKey();
    }

    @Override
    public byte[] encrypt(byte[] byArray) throws Exception {
        RsaEcsPKCS1KeystoreCrypter rsaEcsPKCS1KeystoreCrypter = this;
        rsaEcsPKCS1KeystoreCrypter.ensureEncrypter();
        return rsaEcsPKCS1KeystoreCrypter.mEncrypter.doFinal(byArray);
    }

    @Override
    public byte[] encrypt(String string2) throws Exception {
        return this.encrypt(string2.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte[] decrypt(byte[] byArray) throws Exception {
        RsaEcsPKCS1KeystoreCrypter rsaEcsPKCS1KeystoreCrypter = this;
        rsaEcsPKCS1KeystoreCrypter.ensureDecrypter();
        return rsaEcsPKCS1KeystoreCrypter.mDecrypter.doFinal(byArray);
    }

    @Override
    public byte[] decrypt(String string2) throws Exception {
        return this.decrypt(string2.getBytes(StandardCharsets.UTF_8));
    }
}

