/*
 * Decompiled with CFR 0.152.
 */
package tech.palm.lib.remoteconifg;

import android.content.Context;
import android.text.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;
import tech.palm.lib.remoteconifg.RemoteConfigGetter;

public class JsonRemoteConfigGetter {
    private String mConfigName;
    private String mConfigValue;
    private JSONObject mValueJson;
    private Context mContext;

    public JsonRemoteConfigGetter(Context context, String configName) {
        this.mConfigName = configName;
        this.mContext = context;
        this.mConfigValue = RemoteConfigGetter.getStringValue(context, configName);
        if (!TextUtils.isEmpty((CharSequence)this.mConfigValue)) {
            try {
                this.mValueJson = new JSONObject(this.mConfigValue);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public String getValueString() {
        return this.mConfigValue;
    }

    public JSONObject getValueJson() {
        return this.mValueJson;
    }

    public JSONObject getDefaultJson() {
        return null;
    }

    public int getInt(String key) throws JSONException {
        if (this.mValueJson == null) {
            return -1;
        }
        return this.mValueJson.getInt(key);
    }

    public String getString(String key) throws JSONException {
        if (this.mValueJson == null) {
            return null;
        }
        return this.mValueJson.getString(key);
    }
}

