/*
 * Decompiled with CFR 0.152.
 */
package tech.palm.lib.utils;

import android.content.Context;
import android.location.Geocoder;
import android.location.LocationManager;
import android.preference.PreferenceManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.os.UserManagerCompat;
import java.util.Locale;

public class CountryDetector {
    private static final String KEY_PREFERENCE_TIME_UPDATED = "preference_time_updated";
    static final String KEY_PREFERENCE_CURRENT_COUNTRY = "preference_current_country";
    private static final long TIME_BETWEEN_UPDATES_MS = 43200000L;
    private static final long DISTANCE_BETWEEN_UPDATES_METERS = 5000L;
    private static final String DEFAULT_COUNTRY_ISO = "US";
    @VisibleForTesting
    public static CountryDetector instance;
    private final TelephonyManager telephonyManager;
    private final LocaleProvider localeProvider;
    private final Geocoder geocoder;
    private final Context appContext;

    @VisibleForTesting
    public CountryDetector(Context appContext, TelephonyManager telephonyManager, LocationManager locationManager, LocaleProvider localeProvider, Geocoder geocoder) {
        this.telephonyManager = telephonyManager;
        this.localeProvider = localeProvider;
        this.appContext = appContext;
        this.geocoder = geocoder;
    }

    public static synchronized CountryDetector getInstance(Context context) {
        if (instance == null) {
            Context appContext = context.getApplicationContext();
            instance = new CountryDetector(appContext, (TelephonyManager)context.getSystemService("phone"), (LocationManager)context.getSystemService("location"), Locale::getDefault, new Geocoder(appContext));
        }
        return instance;
    }

    public String getCurrentCountryIso() {
        String result = null;
        if (this.isNetworkCountryCodeAvailable()) {
            result = this.getNetworkBasedCountryIso();
        }
        if (TextUtils.isEmpty(result)) {
            result = this.getLocationBasedCountryIso();
        }
        if (TextUtils.isEmpty((CharSequence)result)) {
            result = this.getSimBasedCountryIso();
        }
        if (TextUtils.isEmpty((CharSequence)result)) {
            result = this.getLocaleBasedCountryIso();
        }
        if (TextUtils.isEmpty((CharSequence)result)) {
            result = DEFAULT_COUNTRY_ISO;
        }
        return result.toUpperCase(Locale.US);
    }

    private String getNetworkBasedCountryIso() {
        return this.telephonyManager.getNetworkCountryIso();
    }

    @Nullable
    private String getLocationBasedCountryIso() {
        if (!(Geocoder.isPresent() && CountryDetector.hasLocationPermissions(this.appContext) && UserManagerCompat.isUserUnlocked((Context)this.appContext))) {
            return null;
        }
        return PreferenceManager.getDefaultSharedPreferences((Context)this.appContext).getString(KEY_PREFERENCE_CURRENT_COUNTRY, null);
    }

    private String getSimBasedCountryIso() {
        return this.telephonyManager.getSimCountryIso();
    }

    private String getLocaleBasedCountryIso() {
        Locale defaultLocale = this.localeProvider.getLocale();
        if (defaultLocale != null) {
            return defaultLocale.getCountry();
        }
        return null;
    }

    private boolean isNetworkCountryCodeAvailable() {
        return this.telephonyManager.getPhoneType() == 1;
    }

    private static boolean hasLocationPermissions(Context context) {
        return context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    public static interface LocaleProvider {
        public Locale getLocale();
    }
}

