/*
 * Decompiled with CFR 0.152.
 */
package tech.palm.lib.athena;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.athena.data.TrackData;
import com.transsion.athenacust.AthenaCust;
import com.transsion.ga.AthenaAnalytics;
import java.util.ArrayList;
import java.util.Locale;
import tech.palm.lib.utils.CommonUtils;

public class AthenaImpl {
    public static final int APP_ID = 7710;
    public static final String TRACK_VERSION = "1.0";
    private static AthenaImpl mInstance;
    private Context mContext;
    private boolean mIsUserExperienceOn = false;
    private String mPalmIdVersion;
    private String mOsVersion;
    private String country;
    private String preCountry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AthenaImpl getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<AthenaImpl> clazz = AthenaImpl.class;
        synchronized (AthenaImpl.class) {
            if (mInstance != null) return mInstance;
            mInstance = new AthenaImpl(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public AthenaImpl(Context context) {
        this.mContext = context.getApplicationContext();
        AthenaAnalytics.init((Context)this.mContext, (String)"palmid", (int)7710, (boolean)false, (boolean)false);
        this.mPalmIdVersion = CommonUtils.getBuildVerName();
        this.mOsVersion = CommonUtils.getOsVersion();
    }

    public void enableAthena(boolean isAgree) {
    }

    public boolean isLoggedOrUserExperienceEnable() {
        return true;
    }

    public Bundle getBundleWithCommonParam() {
        Bundle bundle = new Bundle();
        bundle.putString("bp_v", TRACK_VERSION);
        bundle.putString("palm_ver", this.mPalmIdVersion);
        bundle.putString("os_v", this.mOsVersion);
        bundle.putInt("net_work", CommonUtils.isNetworkConnected(this.mContext) ? 1 : 0);
        return bundle;
    }

    public TrackData addCommonParam(TrackData trackData) {
        if (trackData == null) {
            return trackData;
        }
        trackData.add("bp_v", TRACK_VERSION);
        trackData.add("palm_ver", this.mPalmIdVersion);
        trackData.add("os_v", this.mOsVersion);
        trackData.add("net_work", CommonUtils.isNetworkConnected(this.mContext) ? 1 : 0);
        return trackData;
    }

    public void trackCloudMainShow(String source, boolean auth, boolean contactOn, boolean blocknumOn, boolean wlanOn) {
        if (!this.isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.i((String)"palm_id", (String)"trackCloudMainShow");
        TrackData trackData = new TrackData();
        this.addCommonParam(trackData);
        trackData.add("source", source);
        Bundle bundle1 = new Bundle();
        bundle1.putString("module", "Contacts");
        bundle1.putInt("switch_status", contactOn ? 1 : 0);
        bundle1.putInt("author_status", auth ? 1 : 0);
        Bundle bundle2 = new Bundle();
        bundle2.putString("module", "Block");
        bundle2.putInt("switch_status", blocknumOn ? 1 : 0);
        Bundle bundle3 = new Bundle();
        bundle3.putString("module", "WLAN");
        bundle3.putInt("switch_status", wlanOn ? 1 : 0);
        ArrayList<Bundle> statusList = new ArrayList<Bundle>();
        statusList.add(bundle1);
        statusList.add(bundle2);
        statusList.add(bundle3);
        trackData.add("syn_status", statusList);
        AthenaAnalytics.getInstance((int)7710).track("cloud_syn_show", trackData, 7710);
    }

    public void trackCloudPerferenceClick(int type, boolean start, boolean end, String mode) {
        if (!this.isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.i((String)"palm_id", (String)("trackCloudPerferenceClick " + type + " " + start + " " + end + " " + mode));
        String event = "";
        switch (type) {
            case 1: {
                event = "cloud_contacts_cl";
                break;
            }
            case 2: {
                event = "cloud_block_cl";
                break;
            }
            case 3: {
                event = "cloud_wlan_cl";
                break;
            }
        }
        Bundle bundle = this.getBundleWithCommonParam();
        bundle.putInt("bef_status", start ? 1 : 0);
        bundle.putInt("aft_status", end ? 1 : 0);
        bundle.putString("cl_mode", mode);
        new AthenaCust(event, 7710).trackCommon(bundle, null).submit();
    }

    public void trackSyncBtnClick(boolean contactOn, boolean blocknumOn, boolean wlanOn) {
        if (!this.isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.i((String)"palm_id", (String)"trackSyncBtnClick");
        TrackData trackData = new TrackData();
        this.addCommonParam(trackData);
        Bundle bundle1 = new Bundle();
        bundle1.putString("module", "Contacts");
        bundle1.putInt("switch_status", contactOn ? 1 : 0);
        Bundle bundle2 = new Bundle();
        bundle2.putString("module", "Block");
        bundle2.putInt("switch_status", blocknumOn ? 1 : 0);
        Bundle bundle3 = new Bundle();
        bundle3.putString("module", "WLAN");
        bundle3.putInt("switch_status", wlanOn ? 1 : 0);
        ArrayList<Bundle> statusList = new ArrayList<Bundle>();
        statusList.add(bundle1);
        statusList.add(bundle2);
        statusList.add(bundle3);
        trackData.add("syn_status", statusList);
        AthenaAnalytics.getInstance((int)7710).track("cloud_syn_cl", trackData, 7710);
    }

    public void trackSelfUpdate(int status, String md5, String reason) {
        if (!this.isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.i((String)"palm_id", (String)"trackSelfUpdate");
        Bundle bundle = this.getBundleWithCommonParam();
        bundle.putInt("status", status);
        bundle.putString("md5", md5);
        bundle.putString("reason", reason);
        new AthenaCust("palmid_au_in", 7710).trackCommon(bundle, null).submit();
    }

    public void trackCloudSyncStart(int type, int source) {
        if (!this.isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d((String)"palm_id", (String)("trackCloudSyncStart type: " + type + ", source: " + source));
        String module = "";
        switch (type) {
            case 1: {
                module = "Contacts";
                break;
            }
            case 2: {
                module = "Block";
                break;
            }
            case 3: {
                module = "WLAN";
                break;
            }
        }
        Bundle bundle = this.getBundleWithCommonParam();
        bundle.putString("module", module);
        bundle.putInt("source", source);
        new AthenaCust("cloud_syn_start", 7710).trackCommon(bundle, null).submit();
    }

    public void trackCloudDownloadStart(int type) {
        if (!this.isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d((String)"palm_id", (String)("trackCloudDownloadStart type: " + type));
        String module = "";
        switch (type) {
            case 1: {
                module = "Contacts";
                break;
            }
            case 2: {
                module = "Block";
                break;
            }
            case 3: {
                module = "WLAN";
                break;
            }
        }
        Bundle bundle = this.getBundleWithCommonParam();
        bundle.putString("module", module);
        new AthenaCust("cloud_download_start", 7710).trackCommon(bundle, null).submit();
    }

    public void trackCloudDownloadEnd(int type, int result) {
        if (!this.isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d((String)"palm_id", (String)("trackCloudDownloadEnd type: " + type + ", result: " + result));
        String module = "";
        switch (type) {
            case 1: {
                module = "Contacts";
                break;
            }
            case 2: {
                module = "Block";
                break;
            }
            case 3: {
                module = "WLAN";
                break;
            }
        }
        Bundle bundle = this.getBundleWithCommonParam();
        bundle.putString("module", module);
        bundle.putInt("result", result);
        new AthenaCust("cloud_download_end", 7710).trackCommon(bundle, null).submit();
    }

    public void trackCloudUploadStart(int type) {
        if (!this.isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d((String)"palm_id", (String)("trackCloudUploadStart type: " + type));
        String module = "";
        switch (type) {
            case 1: {
                module = "Contacts";
                break;
            }
            case 2: {
                module = "Block";
                break;
            }
            case 3: {
                module = "WLAN";
                break;
            }
        }
        Bundle bundle = this.getBundleWithCommonParam();
        bundle.putString("module", module);
        new AthenaCust("cloud_upload_start", 7710).trackCommon(bundle, null).submit();
    }

    public void trackCloudUploadEnd(int type, int result) {
        if (!this.isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d((String)"palm_id", (String)("trackCloudUploadEnd type: " + type + ", result: " + result));
        String module = "";
        switch (type) {
            case 1: {
                module = "Contacts";
                break;
            }
            case 2: {
                module = "Block";
                break;
            }
            case 3: {
                module = "WLAN";
                break;
            }
        }
        Bundle bundle = this.getBundleWithCommonParam();
        bundle.putString("module", module);
        bundle.putInt("result", result);
        new AthenaCust("cloud_upload_end", 7710).trackCommon(bundle, null).submit();
    }

    public void trackCloudSyncEnd(int type, int result, String reason, int source) {
        if (!this.isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d((String)"palm_id", (String)("trackCloudSyncEnd type: " + type + ", result: " + result + ", reason: " + reason + ", source: " + source));
        String module = "";
        switch (type) {
            case 1: {
                module = "Contacts";
                break;
            }
            case 2: {
                module = "Block";
                break;
            }
            case 3: {
                module = "WLAN";
                break;
            }
        }
        Bundle bundle = this.getBundleWithCommonParam();
        bundle.putString("module", module);
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        bundle.putInt("source", source);
        new AthenaCust("cloud_syn_end", 7710).trackCommon(bundle, null).submit();
    }

    public void trackExceptionLog(String exception) {
        if (!this.isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d((String)"palm_id", (String)("trackExceptionLog exception: " + exception));
        Bundle bundle = this.getBundleWithCommonParam();
        bundle.putString("excp", exception);
        new AthenaCust("palmid_excpt_log", 7710).trackCommon(bundle, null).submit();
    }

    public void trackAccountEvent(String event, Bundle params) {
        if (!this.isLoggedOrUserExperienceEnable()) {
            return;
        }
        Bundle bundle = this.getBundleWithCommonParam();
        if (params != null) {
            bundle.putAll(params);
        }
        Log.i((String)"palm_id", (String)("trackAccount " + event));
        new AthenaCust(event, 7710).trackCommon(bundle, null).submit();
    }

    public void settingEntranceCl() {
        this.trackAccountEvent("setting_entrance_cl", null);
    }

    public void pidIntroduceShow(String source) {
        Bundle bundle = new Bundle();
        bundle.putString("source", source);
        this.trackAccountEvent("pid_introduce_show", bundle);
    }

    public void introduceEntranceCl() {
        this.trackAccountEvent("introduce_entrance_cl", null);
    }

    public void userCenterShow() {
        this.trackAccountEvent("user_center_show", null);
    }

    public void ucPersonalInfoCl() {
        this.trackAccountEvent("uc_personal_info_cl", null);
    }

    public void ucEleInsuranceCl() {
        this.trackAccountEvent("uc_ele_insurance_cl", null);
    }

    public void ucCloudCl() {
        this.trackAccountEvent("uc_cloud_cl", null);
    }

    public void ucAccountSecurityCl() {
        this.trackAccountEvent("uc_account_security_cl", null);
    }

    public void ucPrivacyCl() {
        this.trackAccountEvent("uc_privacy_cl", null);
    }

    public void ucHelpCl() {
        this.trackAccountEvent("uc_help_cl", null);
    }

    public void loginShow(String source) {
        Bundle bundle = new Bundle();
        bundle.putString("source", TextUtils.isEmpty((CharSequence)source) ? "other" : source);
        this.trackAccountEvent("login_show", bundle);
    }

    public void loginShow(String source, String record) {
        Bundle bundle = new Bundle();
        bundle.putString("source", TextUtils.isEmpty((CharSequence)source) ? "other" : source);
        if (!TextUtils.isEmpty((CharSequence)record)) {
            bundle.putString("record", record);
        }
        this.trackAccountEvent("login_show", bundle);
    }

    public void loginByPasswordCl() {
        this.trackAccountEvent("login_by_password_cl", null);
    }

    public void modifyMccCl(String country) {
        Bundle bundle = new Bundle();
        bundle.putString("country", country);
        this.trackAccountEvent("modify_mcc_cl", bundle);
    }

    public void selectMccCl(String country) {
        Bundle bundle = new Bundle();
        bundle.putString("country", country);
        this.trackAccountEvent("select_mcc_cl", bundle);
    }

    public void modifyMccShow() {
        this.trackAccountEvent("modify_mcc_show", null);
    }

    public void accountFillCl(String loginType, int length) {
        Bundle bundle = new Bundle();
        bundle.putString("login_type", loginType);
        bundle.putInt("length", length);
        this.trackAccountEvent("account_fill_cl", bundle);
    }

    public void getSmsCl(String loginType, int smsCnt) {
        Bundle bundle = new Bundle();
        bundle.putString("login_type", loginType);
        bundle.putInt("sms_cnt", smsCnt);
        this.trackAccountEvent("get_sms_cl", bundle);
    }

    public void loginCl(String loginType) {
        Bundle bundle = new Bundle();
        bundle.putString("login_type", loginType);
        this.trackAccountEvent("login_cl", bundle);
    }

    public void authorizeCl(String pv, String uav) {
        Resources res = this.mContext.getResources();
        Bundle bundle = new Bundle();
        bundle.putString("pv", pv);
        bundle.putString("uav", uav);
        bundle.putLong("dt", System.currentTimeMillis());
        if (res != null) {
            bundle.putString("lang", this.getLanguage(this.mContext));
        }
        this.trackAccountEvent("authorize_cl", bundle);
    }

    public void authorizeCl(String pv, String uav, String ext_pv, String ext_uav, String ext_dpv) {
        Resources res = this.mContext.getResources();
        Bundle bundle = new Bundle();
        bundle.putString("pv", pv);
        bundle.putString("uav", uav);
        bundle.putString("ext_pv", ext_pv);
        bundle.putString("ext_uav", ext_uav);
        bundle.putString("ext_dpv", ext_dpv);
        bundle.putLong("dt", System.currentTimeMillis());
        if (res != null) {
            bundle.putString("lang", this.getLanguage(this.mContext));
        }
        this.trackAccountEvent("authorize_cl", bundle);
    }

    public void loginSuccess(String pv, String uav, String ext_pv, String ext_uav, String ext_dpv) {
        Bundle bundle = new Bundle();
        bundle.putString("pv", pv);
        bundle.putString("uav", uav);
        bundle.putString("ext_pv", ext_pv);
        bundle.putString("ext_uav", ext_uav);
        bundle.putString("ext_dpv", ext_dpv);
        this.trackAccountEvent("login_success", bundle);
    }

    public void userAgreementCl() {
        this.trackAccountEvent("user_agreement_cl", null);
    }

    public void privacyPolicyCl() {
        this.trackAccountEvent("privacy_policy_cl", null);
    }

    public void loginByFacebookCl() {
        this.trackAccountEvent("login_by_facebook_cl", null);
    }

    public void loginByGoogleCl() {
        this.trackAccountEvent("login_by_google_cl", null);
    }

    public void loginByLineCl() {
        this.trackAccountEvent("login_by_line_cl", null);
    }

    public void loginByVKCl() {
        this.trackAccountEvent("login_by_vk_cl", null);
    }

    public void smsSentShow(String loginType) {
        Bundle bundle = new Bundle();
        bundle.putString("login_type", loginType);
        this.trackAccountEvent("sms_sent_show", bundle);
    }

    public void smsExceedShow(String loginType) {
        Bundle bundle = new Bundle();
        bundle.putString("login_type", loginType);
        this.trackAccountEvent("sms_exceed_show", bundle);
    }

    public void getSmsResult(int result, String reason, String loginType, int smsCnt) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        bundle.putString("reason", reason);
        bundle.putString("login_type", loginType);
        bundle.putInt("sms_cnt", smsCnt);
        this.trackAccountEvent("get_sms_result", bundle);
    }

    public void smsFillEnd(String loginType, int smsCnt) {
        Bundle bundle = new Bundle();
        bundle.putString("login_type", loginType);
        bundle.putInt("sms_cnt", smsCnt);
        this.trackAccountEvent("sms_fill_end", bundle);
    }

    public void picVerifyShow() {
        this.trackAccountEvent("pic_verify_show", null);
    }

    public void picVerifyWrongShow() {
        this.trackAccountEvent("pic_verify_wrong_show", null);
    }

    public void picVerifyCl() {
        this.trackAccountEvent("pic_verify_cl", null);
    }

    public void networkInvalidShow() {
        this.trackAccountEvent("network_invalid_show", null);
    }

    public void loginBySmsCl() {
        this.trackAccountEvent("login_by_sms_cl", null);
    }

    public void oldUserLoginSuccessShow() {
        this.trackAccountEvent("old_user_login_success_show", null);
    }

    public void loginByTPButtonCl(String button, String account) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        bundle.putString("account", account);
        this.trackAccountEvent("login_by_tp_button_cl", bundle);
    }

    public void loginStart(String loginBy, int picCnt, int smsCnt, int emsCnt) {
        Bundle bundle = new Bundle();
        bundle.putString("login_by", loginBy);
        bundle.putInt("pic_cnt", picCnt);
        bundle.putInt("sms_cnt", smsCnt);
        bundle.putInt("ems_cnt", emsCnt);
        this.trackAccountEvent("login_start", bundle);
    }

    public void loginEnd(String loginBy, int result, String reason, long time) {
        Bundle bundle = new Bundle();
        bundle.putString("login_by", loginBy);
        bundle.putInt("result", result);
        bundle.putString("reason", reason);
        bundle.putLong("time", time);
        this.trackAccountEvent("login_end", bundle);
    }

    public void forgotPasswordCl() {
        this.trackAccountEvent("forgot_password_cl", null);
    }

    public void forgotPasswordShow() {
        this.trackAccountEvent("forgot_password_show", null);
    }

    public void resetByPhoneCl() {
        this.trackAccountEvent("reset_by_phone_cl", null);
    }

    public void resetByPhoneShow() {
        this.trackAccountEvent("reset_by_phone_show", null);
    }

    public void resetByPhoneNextCl() {
        this.trackAccountEvent("reset_by_phone_next_cl", null);
    }

    public void resetByPhoneVerifyNextCl() {
        this.trackAccountEvent("reset_by_phone_verify_next_cl", null);
    }

    public void resetByEmailCl() {
        this.trackAccountEvent("reset_by_email_cl", null);
    }

    public void resetByEmailShow() {
        this.trackAccountEvent("reset_by_email_show", null);
    }

    public void resetByEmailNextCl() {
        this.trackAccountEvent("reset_by_email_next_cl", null);
    }

    public void resetByEmailVerifyNextCl() {
        this.trackAccountEvent("reset_by_email_verify_next_cl", null);
    }

    public void resetPasswordShow() {
        this.trackAccountEvent("reset_password_show", null);
    }

    public void resetPasswordCl() {
        this.trackAccountEvent("reset_password_cl", null);
    }

    public void resetFinish(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        bundle.putString("reason", reason);
        this.trackAccountEvent("reset_finish", bundle);
    }

    public void logoutCl() {
        this.trackAccountEvent("logout_cl", null);
    }

    public void logoutShow() {
        this.trackAccountEvent("logout_show", null);
    }

    public void logoutNextCl(String localData) {
        Bundle bundle = new Bundle();
        bundle.putString("local_data", localData);
        this.trackAccountEvent("logout_next_cl", bundle);
    }

    public void logoutVerifyShow() {
        this.trackAccountEvent("logout_verify_show", null);
    }

    public void logoutVerifyNextCl() {
        this.trackAccountEvent("logout_verify_next_cl", null);
    }

    public void verifyAccountShow() {
        this.trackAccountEvent("verify_account_show", null);
    }

    public void removeDataShow() {
        this.trackAccountEvent("remove_data_show", null);
    }

    public void deleteDataFailShow() {
        this.trackAccountEvent("delete_data_fail_show", null);
    }

    public void deleteDataEnd(String delCnt) {
        Bundle bundle = new Bundle();
        bundle.putString("del_cnt", delCnt);
        this.trackAccountEvent("delete_data_end", bundle);
    }

    public void beyondValidNotiShow() {
        this.trackAccountEvent("beyond_valid_noti_show", null);
    }

    public void beyondValidNotiCl() {
        this.trackAccountEvent("beyond_valid_noti_cl", null);
    }

    public void securityNotiCl(String button) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        this.trackAccountEvent("security_noti_cl", bundle);
    }

    public void deleteDataShow(String source) {
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)source)) {
            bundle.putString("source", source);
        }
        this.trackAccountEvent("delete_data_show", bundle);
    }

    public void deleteDataNextCl() {
        this.trackAccountEvent("delete_data_next_cl", null);
    }

    public void reloginByPasswordShow() {
        this.trackAccountEvent("relogin_by_password_show", null);
    }

    public void reloginBySmsShow() {
        this.trackAccountEvent("relogin_by_sms_show", null);
    }

    public void privacyCenterShow() {
        this.trackAccountEvent("privacy_center_show", null);
    }

    public void pcPrivacyPolicyCl() {
        this.trackAccountEvent("pc_privacy_policy_cl", null);
    }

    public void pcUserAgreementCl() {
        this.trackAccountEvent("pc_user_agreement_cl", null);
    }

    public void pcNetworkInvalidShow() {
        this.trackAccountEvent("pc_network_invalid_show", null);
    }

    public void helpCenterShow() {
        this.trackAccountEvent("help_center_show", null);
    }

    public void hcQuickScanCl() {
        this.trackAccountEvent("hc_quick_scan_cl", null);
    }

    public void hcNormalQuesCl() {
        this.trackAccountEvent("hc_normal_ques_cl", null);
    }

    public void hcNetworkInvalidShow() {
        this.trackAccountEvent("hc_network_invalid_show", null);
    }

    public void myInfoShow(String infoFillStatus) {
        Bundle bundle = new Bundle();
        bundle.putString("info_fill_status", infoFillStatus);
        this.trackAccountEvent("my_info_show", bundle);
    }

    public void dailyInfo(TrackData trackData) {
        if (!this.isLoggedOrUserExperienceEnable()) {
            return;
        }
        this.addCommonParam(trackData);
        Log.i((String)"palm_id", (String)"trackAccount palmid_login_status");
        AthenaAnalytics.getInstance((int)7710).track("palmid_login_status", trackData, 7710);
    }

    public void myPhotoCl() {
        this.trackAccountEvent("my_photo_cl", null);
    }

    public void myNicknameCl() {
        this.trackAccountEvent("my_nickname_cl", null);
    }

    public void myAccountIdCl() {
        this.trackAccountEvent("my_accountid_cl", null);
    }

    public void myNameCl() {
        this.trackAccountEvent("my_name_cl", null);
    }

    public void myGenderCl() {
        this.trackAccountEvent("my_gender_cl", null);
    }

    public void myBirthdayCl() {
        this.trackAccountEvent("my_birthday_cl", null);
    }

    public void myAutographCl() {
        this.trackAccountEvent("my_autograph_cl", null);
    }

    public void myAddressCl() {
        this.trackAccountEvent("my_address_cl", null);
    }

    public void deAddressCl() {
        this.trackAccountEvent("de_address_cl", null);
    }

    public void noPasswordShow(String source) {
        Bundle bundle = new Bundle();
        bundle.putString("source", source);
        this.trackAccountEvent("no_password_show", bundle);
    }

    public void noPasswordCl(String button) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        this.trackAccountEvent("no_password_cl", bundle);
    }

    public void photoFromShow() {
        this.trackAccountEvent("photo_from_show", null);
    }

    public void photoFromCl(String button) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        this.trackAccountEvent("photo_from_cl", bundle);
    }

    public void modifyNicknameCl(String button) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        this.trackAccountEvent("modify_nickname_cl", bundle);
    }

    public void modifyIdCl(String button) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        this.trackAccountEvent("modify_id_cl", bundle);
    }

    public void canNotModifyIdShow() {
        this.trackAccountEvent("cannot_modify_id_show", null);
    }

    public void modifyNameCl(String button) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        this.trackAccountEvent("modify_name_cl", bundle);
    }

    public void modifySexualCl(String button) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        this.trackAccountEvent("modify_sexual_cl", bundle);
    }

    public void modifyBirthdayCl(String button) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        this.trackAccountEvent("modify_birthday_cl", bundle);
    }

    public void modifyAutographCl(String button) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        this.trackAccountEvent("modify_autograph_cl", bundle);
    }

    public void exitMyInfo(String infoFillStatus) {
        Bundle bundle = new Bundle();
        bundle.putString("info_fill_status", infoFillStatus);
        this.trackAccountEvent("exit_my_info", bundle);
    }

    public void oobeEntrenceShow() {
        this.trackAccountEvent("oobe_entrence_show", null);
    }

    public void palmIdEnter(String source, int loginStatus, String synStatus) {
        Bundle bundle = new Bundle();
        bundle.putString("source", source);
        bundle.putInt("login_status", loginStatus);
        bundle.putString("syn_status", synStatus);
        this.trackAccountEvent("palmid_enter", bundle);
    }

    public void bindNotiShow(String source) {
        Bundle bundle = new Bundle();
        bundle.putString("source", source);
        this.trackAccountEvent("bind_noti_show", bundle);
    }

    public void bindNotiCl(String source, String type) {
        Bundle bundle = new Bundle();
        bundle.putString("source", source);
        bundle.putString("type", type);
        this.trackAccountEvent("bind_noti_cl", bundle);
    }

    public void bindShow(String source, String type, int bindStatus) {
        Bundle bundle = new Bundle();
        bundle.putString("source", source);
        bundle.putString("type", type);
        bundle.putInt("bind_status", bindStatus);
        this.trackAccountEvent("bind_show", bundle);
    }

    public void bindStart(String type, int bindStatus) {
        Bundle bundle = new Bundle();
        bundle.putString("type", type);
        bundle.putInt("bind_status", bindStatus);
        this.trackAccountEvent("bind_start", bundle);
    }

    public void bindEnd(String type, int result, int bindStatus) {
        Bundle bundle = new Bundle();
        bundle.putString("type", type);
        bundle.putInt("bind_status", bindStatus);
        bundle.putInt("result", result);
        this.trackAccountEvent("bind_end", bundle);
    }

    public void identityVerifyShow(String source) {
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)source)) {
            bundle.putString("source", source);
        }
        this.trackAccountEvent("identity_verify_show", bundle);
    }

    public void verifyPasswordResult(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("verify_password_result", bundle);
    }

    public void expiredPopShow() {
        this.trackAccountEvent("expired_pop_show", null);
    }

    public void exitSetPwdPopShow() {
        this.trackAccountEvent("exit_set_pwd_pop_show", null);
    }

    public void exitSetPwdPopCl(String button) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        this.trackAccountEvent("exit_set_pwd_pop_cl", bundle);
    }

    public void loginQsCl() {
        this.trackAccountEvent("login_qs_cl", null);
    }

    public void recycleBinPreferenceClick() {
        Bundle bundle = new Bundle();
        this.trackAccountEvent("recycle_bin_menu_cl", bundle);
    }

    public void recycleBinShow() {
        Bundle bundle = new Bundle();
        this.trackAccountEvent("recycle_bin_show", bundle);
    }

    public void recycleBinLoadResult(boolean success, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", success ? 1 : 0);
        bundle.putString("reason", reason);
        this.trackAccountEvent("recycle_bin_load_result", bundle);
    }

    public void conflictBtnClick(String btnName) {
        Bundle bundle = new Bundle();
        bundle.putString("button", btnName);
        this.trackAccountEvent("recycle_bin_sync_pop_cl", bundle);
    }

    public void conflictDialogShow() {
        Bundle bundle = new Bundle();
        this.trackAccountEvent("recycle_bin_sync_pop_show", bundle);
    }

    public void modifyPhotoResult(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("modify_photo_result", bundle);
    }

    public void modifyNicknameResult(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("modify_nickname_result", bundle);
    }

    public void modifyNameResult(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("modify_name_result", bundle);
    }

    public void modifySexualResult(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("modify_sexual_result", bundle);
    }

    public void modifyBirthdayResult(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("modify_birthday_result", bundle);
    }

    public void modifyRegionResult(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("modify_region_result", bundle);
    }

    public void modifyAddresResult(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("modify_addres_result", bundle);
    }

    public void modifyAutographResult(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("modify_autograph_result", bundle);
    }

    public void addressShow(int addressCnt) {
        Bundle bundle = new Bundle();
        bundle.putInt("address_cnt", addressCnt);
        this.trackAccountEvent("address_show", bundle);
    }

    public void addressAddCl() {
        this.trackAccountEvent("address_add_cl", null);
    }

    public void addressEditCl() {
        this.trackAccountEvent("address_edit_cl", null);
    }

    public void addressDetailCl(String button) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        this.trackAccountEvent("address_detail_cl", bundle);
    }

    public void ucModifyPhotoCl() {
        this.trackAccountEvent("uc_modify_photo_cl", null);
    }

    public void ucPhotoDenyPopCl(String button) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        this.trackAccountEvent("uc_photo_deny_pop_cl", bundle);
    }

    public void accountSecurityShow(String bindList) {
        Bundle bundle = new Bundle();
        bundle.putString("bind_list", bindList);
        this.trackAccountEvent("account_security_show", bundle);
    }

    public void bindPhoneCl() {
        this.trackAccountEvent("bind_phone_cl", null);
    }

    public void bindMailCl() {
        this.trackAccountEvent("bind_mail_cl", null);
    }

    public void modifyPasswordCl() {
        this.trackAccountEvent("modify_password_cl", null);
    }

    public void emergencyInformationCl() {
        this.trackAccountEvent("emergency_information_cl", null);
    }

    public void addAccountCl() {
        this.trackAccountEvent("add_account_cl", null);
    }

    public void thirdPartyAccountShow() {
        this.trackAccountEvent("third_party_account_show", null);
    }

    public void bindGoogleCl(int status) {
        Bundle bundle = new Bundle();
        bundle.putInt("status", status);
        this.trackAccountEvent("bind_google_cl", bundle);
    }

    public void bindFacebookCl(int status) {
        Bundle bundle = new Bundle();
        bundle.putInt("status", status);
        this.trackAccountEvent("bind_facebook_cl", bundle);
    }

    public void bindVKCl(int status) {
        Bundle bundle = new Bundle();
        bundle.putInt("status", status);
        this.trackAccountEvent("bind_vk_cl", bundle);
    }

    public void bindLineCl(int status) {
        Bundle bundle = new Bundle();
        bundle.putInt("status", status);
        this.trackAccountEvent("bind_line_cl", bundle);
    }

    public void bingTpResult(int action, String type, int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        bundle.putString("type", type);
        bundle.putInt("action", action);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("bing_tp_result", bundle);
    }

    public void changePwdShow() {
        this.trackAccountEvent("change_pwd_show", null);
    }

    public void changePwdCl() {
        this.trackAccountEvent("change_pwd_cl", null);
    }

    public void changePwdResult(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("change_pwd_result", bundle);
    }

    public void addEmergencyShow() {
        this.trackAccountEvent("add_emergency_show", null);
    }

    public void addEmergencySelectCl() {
        this.trackAccountEvent("add_emergency_select_cl", null);
    }

    public void addEmergencyAddCl() {
        this.trackAccountEvent("add_emergency_add_cl", null);
    }

    public void addEmergencyResult(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("add_emergency_result", bundle);
    }

    public void modifyIdResult(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("modify_id_result", bundle);
    }

    public void logoutResult(int result, String reason) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty((CharSequence)reason)) {
            bundle.putString("reason", reason);
        }
        this.trackAccountEvent("logout_result", bundle);
    }

    public void tudcUpgradeShow() {
        Bundle bundle = new Bundle();
        this.trackAccountEvent("sdk_upgrade_show", bundle);
    }

    public void tudcUpgradePV(String pv) {
        Bundle bundle = new Bundle();
        bundle.putString("pv", pv);
        this.trackAccountEvent("sdk_upgrade_cl", bundle);
    }

    public void tudcUpgradeUAV(String uav) {
        Bundle bundle = new Bundle();
        bundle.putString("uav", uav);
        this.trackAccountEvent("sdk_upgrade_cl", bundle);
    }

    public void tudcUpgradeButton(String button) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        this.trackAccountEvent("sdk_upgrade_cl", bundle);
    }

    public void agreementUpShow(String version) {
        Bundle bundle = new Bundle();
        bundle.putString("version", version);
        this.trackAccountEvent("agreement_up_show", bundle);
    }

    public void agreementUpBtCl(String button, String uav, String pv) {
        Resources res = this.mContext.getResources();
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        bundle.putLong("dt", System.currentTimeMillis());
        if (res != null) {
            bundle.putString("lang", this.getLanguage(this.mContext));
        }
        bundle.putString("uav", uav);
        bundle.putString("pv", pv);
        this.trackAccountEvent("agreement_up_bt_cl", bundle);
    }

    public void agreementUpLnCl(String link) {
        Bundle bundle = new Bundle();
        bundle.putString("link", link);
        this.trackAccountEvent("agreement_up_ln_cl", bundle);
    }

    public void oobePalmidCl(String page, String button) {
        Bundle bundle = new Bundle();
        bundle.putString("page", page);
        bundle.putString("button", button);
        this.trackAccountEvent("oobe_palmid_cl", bundle);
    }

    public void oobeLoginSuccessShow() {
        this.trackAccountEvent("oobe_login_success_show", null);
    }

    public void cloudPermissionResult(int result, String scenario) {
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        bundle.putString("scenario", scenario);
        this.trackAccountEvent("cloud_per_result", bundle);
    }

    public void cloudPermissionCl(String button, String scenario) {
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        bundle.putString("scenario", scenario);
        this.trackAccountEvent("cloud_per_pop_cl", bundle);
    }

    public void settingRequest(int loginStatus, int alaStatus) {
        Bundle bundle = new Bundle();
        bundle.putInt("login_status", loginStatus);
        bundle.putInt("ala_status", alaStatus);
        this.trackAccountEvent("setting_request", bundle);
    }

    public void remoteConfigReceived(String content) {
        Bundle bundle = new Bundle();
        bundle.putString("content", content);
        this.trackAccountEvent("remote_config_received", bundle);
    }

    public void saveSelectCountryCode(String country) {
        this.country = country;
    }

    public String getCurrentCode() {
        return this.country;
    }

    public void savePreCountryCode(String preCountry) {
        this.preCountry = preCountry;
    }

    public String getPreCurrentCode() {
        return this.preCountry;
    }

    public String getLanguage(Context context) {
        Locale locale = Build.VERSION.SDK_INT >= 24 ? context.getResources().getConfiguration().getLocales().get(0) : context.getResources().getConfiguration().locale;
        return locale.getLanguage();
    }

    public void addHeadAccountId(String accountId) {
        AthenaAnalytics.setAccount((short)0, (String)CommonUtils.getSHA256(accountId));
    }
}

