/*
 * Decompiled with CFR 0.152.
 */
package tech.palm.lib.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import tech.palm.commonlib.R;
import tech.palm.lib.widget.CenterImageSpan;

@SuppressLint(value={"AppCompatCustomView"})
public class TagTextView
extends TextView {
    public static int TAGS_INDEX_AT_START = 0;
    public static int TAGS_INDEX_AT_END = 1;
    private int tagsBackgroundStyle = R.drawable.shape_textview_tags_bg;
    private int tagTextSize = 10;
    private int tagTextColor;
    private StringBuffer content_buffer;
    private Context mContext;
    private TextView tv_tag;
    private int tagsIndex = 0;

    public TagTextView(Context context) {
        super(context);
        this.mContext = context;
        this.initColor();
    }

    public TagTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initColor();
    }

    public TagTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initColor();
    }

    private void initColor() {
        this.tagTextColor = Color.parseColor((String)"#FF08B1FF");
    }

    public void setTagTextSize(int tagTextSize) {
        this.tagTextSize = tagTextSize;
    }

    public void setTagTextColor(int tagTextColor) {
        this.tagTextColor = tagTextColor;
    }

    public void setTagsBackgroundStyle(int tagsBackgroundStyle) {
        this.tagsBackgroundStyle = tagsBackgroundStyle;
    }

    public void setTagsIndex(int tagsIndex) {
        this.tagsIndex = tagsIndex;
    }

    public void setSingleTagAndContent(@NonNull String tag, String content) {
        ArrayList<String> tagList = new ArrayList<String>();
        tagList.add(tag);
        this.setMultiTagAndContent(tagList, content);
    }

    public void setMultiTagAndContent(@NonNull List<String> tags, String content) {
        if (this.tagsIndex == TAGS_INDEX_AT_START) {
            this.setTagStart(tags, content);
        } else {
            this.setTagEnd(tags, content);
        }
    }

    public void setTagStart(List<String> tags, String content) {
        int endIndex = 0;
        int startIndex = 1;
        this.content_buffer = new StringBuffer();
        for (String item : tags) {
            this.content_buffer.append(item);
        }
        this.content_buffer.append(content);
        SpannableString spannableString = new SpannableString((CharSequence)this.content_buffer);
        for (int i = 0; i < tags.size(); ++i) {
            String item = tags.get(i);
            endIndex += item.length();
            View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_textview_tags, null);
            this.tv_tag = (TextView)view.findViewById(R.id.tv_tags);
            this.tv_tag.setText((CharSequence)item);
            this.tv_tag.setTextSize((float)this.tagTextSize);
            this.tv_tag.setTextColor(this.tagTextColor);
            this.tv_tag.setBackgroundResource(this.tagsBackgroundStyle);
            Bitmap bitmap = TagTextView.convertViewToBitmap(view);
            BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
            drawable2.setBounds(0, 0, this.tv_tag.getWidth(), this.tv_tag.getHeight());
            CenterImageSpan span = new CenterImageSpan((Drawable)drawable2);
            spannableString.setSpan((Object)span, startIndex - 1, endIndex, 18);
            startIndex += item.length();
        }
        this.setPadding(0, 0, 0, 5);
        this.setText((CharSequence)spannableString);
        this.setGravity(16);
    }

    public void setTagImageStart(Context context, int resID, String content, int width, int height) {
        this.content_buffer = new StringBuffer("**" + content);
        SpannableString spannableString = new SpannableString((CharSequence)this.content_buffer);
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)resID);
        BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
        drawable2.setBounds(0, 0, TagTextView.dp2px(context, width), TagTextView.dp2px(context, height));
        CenterImageSpan span = new CenterImageSpan((Drawable)drawable2);
        spannableString.setSpan((Object)span, 0, 2, 18);
        this.setText((CharSequence)spannableString);
        this.setGravity(16);
    }

    public void setTagEnd(List<String> tags, String content) {
        int startIndex = content.length();
        this.content_buffer = new StringBuffer(content);
        for (String item : tags) {
            this.content_buffer.append(item);
        }
        SpannableString spannableString = new SpannableString((CharSequence)this.content_buffer);
        for (int i = 0; i < tags.size(); ++i) {
            String item = tags.get(i);
            View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_textview_tags, null);
            this.tv_tag = (TextView)view.findViewById(R.id.tv_tags);
            this.tv_tag.setText((CharSequence)item);
            this.tv_tag.setTextSize((float)this.tagTextSize);
            this.tv_tag.setTextColor(this.tagTextColor);
            this.tv_tag.setBackgroundResource(this.tagsBackgroundStyle);
            Bitmap bitmap = TagTextView.convertViewToBitmap(view);
            BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
            drawable2.setBounds(0, 0, this.tv_tag.getWidth(), this.tv_tag.getHeight());
            ImageSpan imageSpan = new ImageSpan(this.getContext(), bitmap);
            spannableString.setSpan((Object)imageSpan, startIndex, startIndex + item.length(), 18);
            startIndex += item.length();
        }
        this.setPadding(0, 0, 0, 5);
        this.setText((CharSequence)spannableString);
        this.setGravity(16);
    }

    public void setTagAnyway(int start, int end, String content) {
        SpannableString spannableString = new SpannableString((CharSequence)content);
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_textview_tags, null);
        String item = content.substring(start, end);
        this.tv_tag = (TextView)view.findViewById(R.id.tv_tags);
        this.tv_tag.setText((CharSequence)item);
        this.tv_tag.setTextSize((float)this.tagTextSize);
        this.tv_tag.setTextColor(this.tagTextColor);
        this.tv_tag.setBackgroundResource(this.tagsBackgroundStyle);
        Bitmap bitmap = TagTextView.convertViewToBitmap(view);
        BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
        drawable2.setBounds(0, 0, this.tv_tag.getWidth(), this.tv_tag.getHeight());
        CenterImageSpan span = new CenterImageSpan((Drawable)drawable2);
        spannableString.setSpan((Object)span, start, end, 18);
        this.setText((CharSequence)spannableString);
        this.setGravity(16);
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private static Bitmap convertViewToBitmap(View view) {
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        return bitmap;
    }
}

