package tech.palm.lib.athena;

import android.content.Context;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;

import com.transsion.athena.data.TrackData;
import com.transsion.athenacust.AthenaCust;
import com.transsion.ga.AthenaAnalytics;

import java.util.ArrayList;
import java.util.Locale;

import tech.palm.lib.CommonConstants;
import tech.palm.lib.account.XNManager;
import tech.palm.lib.utils.CloudUtils;
import tech.palm.lib.utils.CommonUtils;

import static tech.palm.lib.CommonConstants.TAG;

public class AthenaImpl {

    public static final int APP_ID = 7710;
    public static final String TRACK_VERSION = "1.0";

    private static AthenaImpl mInstance;
    private Context mContext;
    private boolean mIsUserExperienceOn = false;
    private String mPalmIdVersion;
    private String mOsVersion;
    /**
     * 国家
     */
    private String country;

    /**
     * 前一次选中的国家
     */
    private String preCountry;

//    final private ContentObserver mUserExperienceObserver = new ContentObserver(new Handler(Looper.getMainLooper())) {
//        @Override
//        public void onChange(boolean selfChange) {
//            mIsUserExperienceOn = (Settings.System.getInt(mContext.getContentResolver(),"user_experience", 0) == 1);
//            enableAthena(false);
//        }
//    };

    public static AthenaImpl getInstance(Context context) {
        if (mInstance == null) {
            synchronized (AthenaImpl.class) {
                if (mInstance == null) {
                    mInstance = new AthenaImpl(context);
                }
            }
        }
        return mInstance;
    }

    public AthenaImpl(Context context) {
        mContext = context.getApplicationContext();
        AthenaAnalytics.init(mContext, "palmid", APP_ID, false, false);
//        AthenaAnalytics.setTest(true);
//        mContext.getContentResolver().registerContentObserver(
//                Settings.System.getUriFor("user_experience"), true,
//                mUserExperienceObserver);
//        mUserExperienceObserver.onChange(false);

        mPalmIdVersion = CommonUtils.getBuildVerName();
        mOsVersion = CommonUtils.getOsVersion();
    }

    public void enableAthena(boolean isAgree) {
//        AthenaAnalytics.enable(mIsUserExperienceOn
//                || isAgree
//                || XNManager.getInstance().isLogged(mContext));
    }

    public boolean isLoggedOrUserExperienceEnable() {
//        return mIsUserExperienceOn || XNManager.getInstance().isLogged(mContext);
        return true;
    }

    public Bundle getBundleWithCommonParam() {
        Bundle bundle = new Bundle();
        bundle.putString("bp_v", TRACK_VERSION);
        bundle.putString("palm_ver", mPalmIdVersion);
        bundle.putString("os_v", mOsVersion);
        bundle.putInt("net_work", CommonUtils.isNetworkConnected(mContext) ? 1 : 0);
        return bundle;
    }

    public TrackData addCommonParam(TrackData trackData) {
        if (trackData == null) {
            return trackData;
        }

        trackData.add("bp_v", TRACK_VERSION);
        trackData.add("palm_ver", mPalmIdVersion);
        trackData.add("os_v", mOsVersion);
        trackData.add("net_work", CommonUtils.isNetworkConnected(mContext) ? 1 : 0);

        return trackData;
    }

    public void trackCloudMainShow(String source, boolean auth, boolean contactOn, boolean blocknumOn, boolean wlanOn) {
        if (!isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.i(TAG, "trackCloudMainShow");
        TrackData trackData = new TrackData();
        addCommonParam(trackData);
        trackData.add("source", source);
        Bundle bundle1 = new Bundle();
        bundle1.putString("module", "Contacts");
        bundle1.putInt("switch_status", contactOn ? 1 : 0);
        bundle1.putInt("author_status", auth ? 1 : 0);
        Bundle bundle2 = new Bundle();
        bundle2.putString("module", "Block");
        bundle2.putInt("switch_status", blocknumOn ? 1 : 0);
        Bundle bundle3 = new Bundle();
        bundle3.putString("module", "WLAN");
        bundle3.putInt("switch_status", wlanOn ? 1 : 0);
        ArrayList<Bundle> statusList = new ArrayList<>();
        statusList.add(bundle1);
        statusList.add(bundle2);
        statusList.add(bundle3);
        trackData.add("syn_status", statusList);
        AthenaAnalytics.getInstance(APP_ID).track("cloud_syn_show", trackData, APP_ID);
    }

    public void trackCloudPerferenceClick(int type, boolean start, boolean end, String mode) {
        if (!isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.i(TAG, "trackCloudPerferenceClick " +type + " " +start + " " + end + " " + mode);
        String event = "";
        switch (type) {
            case CommonConstants.CLOUD.DataType.CONTACT:
                event = "cloud_contacts_cl";
                break;
            case CommonConstants.CLOUD.DataType.BLOCKNUM:
                event = "cloud_block_cl";
                break;
            case CommonConstants.CLOUD.DataType.WLAN:
                event = "cloud_wlan_cl";
                break;
            default:
                break;
        }
        Bundle bundle = getBundleWithCommonParam();
        bundle.putInt("bef_status", start ?  1 : 0);
        bundle.putInt("aft_status", end ?  1 : 0);
        bundle.putString("cl_mode", mode);
        new AthenaCust(event, APP_ID).trackCommon(bundle, null).submit();
    }

    public void trackSyncBtnClick(boolean contactOn, boolean blocknumOn, boolean wlanOn) {
        if (!isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.i(TAG, "trackSyncBtnClick");
        TrackData trackData = new TrackData();
        addCommonParam(trackData);
        Bundle bundle1 = new Bundle();
        bundle1.putString("module", "Contacts");
        bundle1.putInt("switch_status", contactOn ? 1 : 0);
        Bundle bundle2 = new Bundle();
        bundle2.putString("module", "Block");
        bundle2.putInt("switch_status", blocknumOn ? 1 : 0);
        Bundle bundle3 = new Bundle();
        bundle3.putString("module", "WLAN");
        bundle3.putInt("switch_status", wlanOn ? 1 : 0);
        ArrayList<Bundle> statusList = new ArrayList<>();
        statusList.add(bundle1);
        statusList.add(bundle2);
        statusList.add(bundle3);
        trackData.add("syn_status", statusList);
        AthenaAnalytics.getInstance(APP_ID).track("cloud_syn_cl", trackData, APP_ID);
    }

    public void trackSelfUpdate(int status, String md5, String reason) {
        if (!isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.i(TAG, "trackSelfUpdate");
        Bundle bundle = getBundleWithCommonParam();
        bundle.putInt("status", status);
        bundle.putString("md5", md5);
        bundle.putString("reason", reason);
        new AthenaCust("palmid_au_in", APP_ID).trackCommon(bundle, null).submit();
    }

    public void trackCloudSyncStart(int type, int source) {
        if (!isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d(TAG, "trackCloudSyncStart type: " +type + ", source: " + source);
        String module = "";
        switch (type) {
            case CommonConstants.CLOUD.DataType.CONTACT:
                module = "Contacts";
                break;
            case CommonConstants.CLOUD.DataType.BLOCKNUM:
                module = "Block";
                break;
            case CommonConstants.CLOUD.DataType.WLAN:
                module = "WLAN";
                break;
            default:
                break;
        }
        Bundle bundle = getBundleWithCommonParam();
        bundle.putString("module", module);
        bundle.putInt("source", source);
        new AthenaCust("cloud_syn_start", APP_ID).trackCommon(bundle, null).submit();
    }

    public void trackCloudDownloadStart(int type) {
        if (!isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d(TAG, "trackCloudDownloadStart type: " +type);
        String module = "";
        switch (type) {
            case CommonConstants.CLOUD.DataType.CONTACT:
                module = "Contacts";
                break;
            case CommonConstants.CLOUD.DataType.BLOCKNUM:
                module = "Block";
                break;
            case CommonConstants.CLOUD.DataType.WLAN:
                module = "WLAN";
                break;
            default:
                break;
        }
        Bundle bundle = getBundleWithCommonParam();
        bundle.putString("module", module);
        new AthenaCust("cloud_download_start", APP_ID).trackCommon(bundle, null).submit();
    }

    public void trackCloudDownloadEnd(int type, int result) {
        if (!isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d(TAG, "trackCloudDownloadEnd type: " +type + ", result: " + result);
        String module = "";
        switch (type) {
            case CommonConstants.CLOUD.DataType.CONTACT:
                module = "Contacts";
                break;
            case CommonConstants.CLOUD.DataType.BLOCKNUM:
                module = "Block";
                break;
            case CommonConstants.CLOUD.DataType.WLAN:
                module = "WLAN";
                break;
            default:
                break;
        }
        Bundle bundle = getBundleWithCommonParam();
        bundle.putString("module", module);
        bundle.putInt("result", result);
        new AthenaCust("cloud_download_end", APP_ID).trackCommon(bundle, null).submit();
    }

    public void trackCloudUploadStart(int type) {
        if (!isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d(TAG, "trackCloudUploadStart type: " +type);
        String module = "";
        switch (type) {
            case CommonConstants.CLOUD.DataType.CONTACT:
                module = "Contacts";
                break;
            case CommonConstants.CLOUD.DataType.BLOCKNUM:
                module = "Block";
                break;
            case CommonConstants.CLOUD.DataType.WLAN:
                module = "WLAN";
                break;
            default:
                break;
        }
        Bundle bundle = getBundleWithCommonParam();
        bundle.putString("module", module);
        new AthenaCust("cloud_upload_start", APP_ID).trackCommon(bundle, null).submit();
    }

    public void trackCloudUploadEnd(int type, int result) {
        if (!isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d(TAG, "trackCloudUploadEnd type: " +type + ", result: " + result);
        String module = "";
        switch (type) {
            case CommonConstants.CLOUD.DataType.CONTACT:
                module = "Contacts";
                break;
            case CommonConstants.CLOUD.DataType.BLOCKNUM:
                module = "Block";
                break;
            case CommonConstants.CLOUD.DataType.WLAN:
                module = "WLAN";
                break;
            default:
                break;
        }
        Bundle bundle = getBundleWithCommonParam();
        bundle.putString("module", module);
        bundle.putInt("result", result);
        new AthenaCust("cloud_upload_end", APP_ID).trackCommon(bundle, null).submit();
    }

    public void trackCloudSyncEnd(int type, int result, String reason, int source) {
        if (!isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d(TAG, "trackCloudSyncEnd type: " +type + ", result: " + result
                + ", reason: " + reason + ", source: " + source);
        String module = "";
        switch (type) {
            case CommonConstants.CLOUD.DataType.CONTACT:
                module = "Contacts";
                break;
            case CommonConstants.CLOUD.DataType.BLOCKNUM:
                module = "Block";
                break;
            case CommonConstants.CLOUD.DataType.WLAN:
                module = "WLAN";
                break;
            default:
                break;
        }
        Bundle bundle = getBundleWithCommonParam();
        bundle.putString("module", module);
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty(reason)) {
            bundle.putString("reason", reason);
        }
        bundle.putInt("source", source);
        new AthenaCust("cloud_syn_end", APP_ID).trackCommon(bundle, null).submit();
    }

    public void trackExceptionLog(String exception) {
        if (!isLoggedOrUserExperienceEnable()) {
            return;
        }
        Log.d(TAG, "trackExceptionLog exception: " +exception);
        Bundle bundle = getBundleWithCommonParam();
        bundle.putString("excp", exception);
        new AthenaCust("palmid_excpt_log", APP_ID).trackCommon(bundle, null).submit();
    }

    public void trackAccountEvent(String event, Bundle params){
        if (!isLoggedOrUserExperienceEnable()){
            return;
        }
        Bundle bundle = getBundleWithCommonParam();
        if (params != null){
            bundle.putAll(params);
        }
        Log.i(TAG, "trackAccount " + event);
        new AthenaCust(event, APP_ID).trackCommon(bundle,null).submit();
    }

    /**
     * 点击设置入口进入用户中心
     */
    public void settingEntranceCl(){
        trackAccountEvent("setting_entrance_cl", null);
    }

    /**
     * 快速了解页曝光,UC、HC、LG
     */
    public void pidIntroduceShow(String source){
        Bundle bundle = new Bundle();
        bundle.putString("source", source);
        trackAccountEvent("pid_introduce_show", bundle);
    }

    public void introduceEntranceCl(){
        trackAccountEvent("introduce_entrance_cl", null);
    }
    public void userCenterShow(){
        trackAccountEvent("user_center_show", null);
    }
    public void ucPersonalInfoCl(){
        trackAccountEvent("uc_personal_info_cl", null);
    }

    public void ucEleInsuranceCl(){
        trackAccountEvent("uc_ele_insurance_cl", null);
    }

    public void ucCloudCl(){
        trackAccountEvent("uc_cloud_cl", null);
    }

    public void ucAccountSecurityCl(){
        trackAccountEvent("uc_account_security_cl", null);
    }

    public void ucPrivacyCl(){
        trackAccountEvent("uc_privacy_cl", null);
    }

    public void ucHelpCl(){
        trackAccountEvent("uc_help_cl", null);
    }

    public void loginShow(String source){
        Bundle bundle = new Bundle();
        bundle.putString("source", TextUtils.isEmpty(source) ? "other" : source);
        trackAccountEvent("login_show", bundle);
    }

    public void loginShow(String source,String record){
        Bundle bundle = new Bundle();
        bundle.putString("source", TextUtils.isEmpty(source) ? "other" : source);
        if (!TextUtils.isEmpty(record)){
            bundle.putString("record",record);
        }
        trackAccountEvent("login_show", bundle);
    }

    public void loginByPasswordCl(){
        trackAccountEvent("login_by_password_cl", null);
    }

    public void modifyMccCl(String country){
        Bundle bundle = new Bundle();
        bundle.putString("country", country);
        trackAccountEvent("modify_mcc_cl", bundle);
    }

    public void selectMccCl(String country){
        Bundle bundle = new Bundle();
        bundle.putString("country", country);
        trackAccountEvent("select_mcc_cl", bundle);
    }

    public void modifyMccShow(){
        trackAccountEvent("modify_mcc_show", null);
    }

    public void accountFillCl(String loginType,int length){
        Bundle bundle = new Bundle();
        bundle.putString("login_type", loginType);
        bundle.putInt("length", length);
        trackAccountEvent("account_fill_cl", bundle);
    }

    public void getSmsCl(String loginType,int smsCnt){
        Bundle bundle = new Bundle();
        bundle.putString("login_type", loginType);
        bundle.putInt("sms_cnt", smsCnt);
        trackAccountEvent("get_sms_cl", bundle);
    }

    public void loginCl(String loginType){
        Bundle bundle = new Bundle();
        bundle.putString("login_type", loginType);
        trackAccountEvent("login_cl", bundle);
    }

    public void authorizeCl(String pv,String uav){
        Resources res = mContext.getResources();
        Bundle bundle = new Bundle();
        bundle.putString("pv", pv);
        bundle.putString("uav", uav);
        bundle.putLong("dt", System.currentTimeMillis());
        if (res != null) {
            bundle.putString("lang", getLanguage(mContext));
        }
        trackAccountEvent("authorize_cl", bundle);
    }

    public void authorizeCl(String pv,String uav, String ext_pv, String ext_uav, String ext_dpv){
        Resources res = mContext.getResources();
        Bundle bundle = new Bundle();
        bundle.putString("pv", pv);
        bundle.putString("uav", uav);
        bundle.putString("ext_pv", ext_pv);
        bundle.putString("ext_uav", ext_uav);
        bundle.putString("ext_dpv", ext_dpv);
        bundle.putLong("dt", System.currentTimeMillis());
        if (res != null) {
            bundle.putString("lang", getLanguage(mContext));
        }
        trackAccountEvent("authorize_cl", bundle);
    }

    public void loginSuccess(String pv,String uav, String ext_pv, String ext_uav, String ext_dpv){
        Bundle bundle = new Bundle();
        bundle.putString("pv", pv);
        bundle.putString("uav", uav);
        bundle.putString("ext_pv", ext_pv);
        bundle.putString("ext_uav", ext_uav);
        bundle.putString("ext_dpv", ext_dpv);
        trackAccountEvent("login_success", bundle);
    }

    public void userAgreementCl(){
        trackAccountEvent("user_agreement_cl", null);
    }

    public void privacyPolicyCl(){
        trackAccountEvent("privacy_policy_cl", null);
    }
    public void loginByFacebookCl(){
        trackAccountEvent("login_by_facebook_cl", null);
    }
    public void loginByGoogleCl(){
        trackAccountEvent("login_by_google_cl", null);
    }

    public void loginByLineCl(){
        trackAccountEvent("login_by_line_cl", null);
    }

    public void loginByVKCl(){
        trackAccountEvent("login_by_vk_cl", null);
    }

    public void smsSentShow(String loginType){
        Bundle bundle = new Bundle();
        bundle.putString("login_type", loginType);
        trackAccountEvent("sms_sent_show", bundle);
    }

    public void smsExceedShow(String loginType){
        Bundle bundle = new Bundle();
        bundle.putString("login_type", loginType);
        trackAccountEvent("sms_exceed_show", bundle);
    }

    public void getSmsResult(int result,String reason,String loginType,int smsCnt){
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        bundle.putString("reason", reason);
        bundle.putString("login_type", loginType);
        bundle.putInt("sms_cnt", smsCnt);
        trackAccountEvent("get_sms_result", bundle);
    }

    public void smsFillEnd(String loginType,int smsCnt){
        Bundle bundle = new Bundle();
        bundle.putString("login_type", loginType);
        bundle.putInt("sms_cnt", smsCnt);
        trackAccountEvent("sms_fill_end", bundle);
    }

    public void picVerifyShow(){
        trackAccountEvent("pic_verify_show", null);
    }

    public void picVerifyWrongShow(){
        trackAccountEvent("pic_verify_wrong_show", null);
    }

    public void picVerifyCl(){
        trackAccountEvent("pic_verify_cl", null);
    }

    public void networkInvalidShow(){
        trackAccountEvent("network_invalid_show", null);
    }

    public void loginBySmsCl(){
        trackAccountEvent("login_by_sms_cl", null);
    }

//    public void loginResult(int result,String reason,int retryCnt){
//        Bundle bundle = new Bundle();
//        bundle.putInt("result", result);
//        bundle.putString("reason", reason);
//        bundle.putInt("retry_cnt", retryCnt);
//        trackAccountEvent("login_result", bundle);
//    }

    public void oldUserLoginSuccessShow(){
        trackAccountEvent("old_user_login_success_show", null);
    }

    public void loginByTPButtonCl(String button, String account){
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        bundle.putString("account", account);
        trackAccountEvent("login_by_tp_button_cl", bundle);
    }

    public void loginStart(String loginBy,int picCnt,int smsCnt,int emsCnt){
        Bundle bundle = new Bundle();
        bundle.putString("login_by", loginBy);
        bundle.putInt("pic_cnt",picCnt);
        bundle.putInt("sms_cnt",smsCnt);
        bundle.putInt("ems_cnt",emsCnt);
        trackAccountEvent("login_start", bundle);
    }

    public void loginEnd(String loginBy,int result,String reason,long time){
        Bundle bundle = new Bundle();
        bundle.putString("login_by", loginBy);
        bundle.putInt("result",result);
        bundle.putString("reason", reason);
        bundle.putLong("time", time);
        trackAccountEvent("login_end", bundle);
    }

    public void forgotPasswordCl(){
        trackAccountEvent("forgot_password_cl", null);
    }

    public void forgotPasswordShow(){
        trackAccountEvent("forgot_password_show", null);
    }

    public void resetByPhoneCl(){
        trackAccountEvent("reset_by_phone_cl", null);
    }

    public void resetByPhoneShow(){
        trackAccountEvent("reset_by_phone_show", null);
    }

    public void resetByPhoneNextCl(){
        trackAccountEvent("reset_by_phone_next_cl", null);
    }

    public void resetByPhoneVerifyNextCl(){
        trackAccountEvent("reset_by_phone_verify_next_cl", null);
    }

    public void resetByEmailCl(){
        trackAccountEvent("reset_by_email_cl", null);
    }

    public void resetByEmailShow(){
        trackAccountEvent("reset_by_email_show", null);
    }

    public void resetByEmailNextCl(){
        trackAccountEvent("reset_by_email_next_cl", null);
    }

    public void resetByEmailVerifyNextCl(){
        trackAccountEvent("reset_by_email_verify_next_cl", null);
    }
    public void resetPasswordShow(){
        trackAccountEvent("reset_password_show", null);
    }
    public void resetPasswordCl(){
        trackAccountEvent("reset_password_cl", null);
    }
    public void resetFinish(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        bundle.putString("reason", reason);
        trackAccountEvent("reset_finish", bundle);
    }

    public void logoutCl(){
        trackAccountEvent("logout_cl", null);
    }

    public void logoutShow(){
        trackAccountEvent("logout_show", null);
    }

    public void logoutNextCl(String localData){
        Bundle bundle = new Bundle();
        bundle.putString("local_data",localData);
        trackAccountEvent("logout_next_cl", bundle);
    }

    public void logoutVerifyShow(){
        trackAccountEvent("logout_verify_show", null);
    }

    public void logoutVerifyNextCl(){
        trackAccountEvent("logout_verify_next_cl", null);
    }

    public void verifyAccountShow(){
        trackAccountEvent("verify_account_show", null);
    }

    public void removeDataShow(){
        trackAccountEvent("remove_data_show", null);
    }

    public void deleteDataFailShow(){
        trackAccountEvent("delete_data_fail_show", null);
    }

    public void deleteDataEnd(String delCnt){
        Bundle bundle = new Bundle();
        bundle.putString("del_cnt",delCnt);
        trackAccountEvent("delete_data_end", bundle);
    }

    public void beyondValidNotiShow(){
        trackAccountEvent("beyond_valid_noti_show", null);
    }

    public void beyondValidNotiCl(){
        trackAccountEvent("beyond_valid_noti_cl", null);
    }

    public void securityNotiCl(String button){
        Bundle bundle = new Bundle();
        bundle.putString("button",button);
        trackAccountEvent("security_noti_cl", bundle);
    }

    public void deleteDataShow(String source){//UC\EX
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty(source)){
            bundle.putString("source", source);
        }
        trackAccountEvent("delete_data_show", bundle);
    }

    public void deleteDataNextCl(){
        trackAccountEvent("delete_data_next_cl", null);
    }

    public void reloginByPasswordShow(){
        trackAccountEvent("relogin_by_password_show", null);
    }

    public void reloginBySmsShow(){
        trackAccountEvent("relogin_by_sms_show", null);
    }

    public void privacyCenterShow(){
        trackAccountEvent("privacy_center_show", null);
    }

    public void pcPrivacyPolicyCl(){
        trackAccountEvent("pc_privacy_policy_cl", null);
    }
    public void pcUserAgreementCl(){
        trackAccountEvent("pc_user_agreement_cl", null);
    }
    public void pcNetworkInvalidShow(){
        trackAccountEvent("pc_network_invalid_show", null);
    }
    public void helpCenterShow(){
        trackAccountEvent("help_center_show", null);
    }

    public void hcQuickScanCl(){
        trackAccountEvent("hc_quick_scan_cl", null);
    }

    public void hcNormalQuesCl(){
        trackAccountEvent("hc_normal_ques_cl", null);
    }

    public void hcNetworkInvalidShow(){
        trackAccountEvent("hc_network_invalid_show", null);
    }

    public void myInfoShow(String infoFillStatus){
        Bundle bundle = new Bundle();
        bundle.putString("info_fill_status", infoFillStatus);
        trackAccountEvent("my_info_show", bundle);
    }

    public void dailyInfo(TrackData trackData) {
        if (!isLoggedOrUserExperienceEnable()){
            return;
        }
        addCommonParam(trackData);
        Log.i(TAG, "trackAccount palmid_login_status");
        AthenaAnalytics.getInstance(APP_ID).track("palmid_login_status", trackData, APP_ID);
    }

    public void myPhotoCl(){
        trackAccountEvent("my_photo_cl", null);
    }
    public void myNicknameCl(){
        trackAccountEvent("my_nickname_cl", null);
    }
    public void myAccountIdCl(){
        trackAccountEvent("my_accountid_cl", null);
    }
    public void myNameCl(){
        trackAccountEvent("my_name_cl", null);
    }
    public void myGenderCl(){
        trackAccountEvent("my_gender_cl", null);
    }
    public void myBirthdayCl(){
        trackAccountEvent("my_birthday_cl", null);
    }
    public void myAutographCl(){
        trackAccountEvent("my_autograph_cl", null);
    }
    public void myAddressCl(){
        trackAccountEvent("my_address_cl", null);
    }
    public void deAddressCl(){
        trackAccountEvent("de_address_cl", null);
    }

    public void noPasswordShow(String source){
        Bundle bundle = new Bundle();
        bundle.putString("source", source);
        trackAccountEvent("no_password_show", bundle);
    }

    public void noPasswordCl(String button){
        Bundle bundle = new Bundle();
        bundle.putString("button",button);
        trackAccountEvent("no_password_cl", bundle);
    }

    public void photoFromShow(){
        trackAccountEvent("photo_from_show", null);
    }

    public void photoFromCl(String button){
        Bundle bundle = new Bundle();
        bundle.putString("button",button);
        trackAccountEvent("photo_from_cl", bundle);
    }

    public void modifyNicknameCl(String button){
        Bundle bundle = new Bundle();
        bundle.putString("button",button);
        trackAccountEvent("modify_nickname_cl", bundle);
    }

    public void modifyIdCl(String button){
        Bundle bundle = new Bundle();
        bundle.putString("button",button);
        trackAccountEvent("modify_id_cl", bundle);
    }

    public void canNotModifyIdShow(){
        trackAccountEvent("cannot_modify_id_show", null);
    }

    public void modifyNameCl(String button){
        Bundle bundle = new Bundle();
        bundle.putString("button",button);
        trackAccountEvent("modify_name_cl", bundle);
    }

    public void modifySexualCl(String button){
        Bundle bundle = new Bundle();
        bundle.putString("button",button);
        trackAccountEvent("modify_sexual_cl", bundle);
    }

    public void modifyBirthdayCl(String button){
        Bundle bundle = new Bundle();
        bundle.putString("button",button);
        trackAccountEvent("modify_birthday_cl", bundle);
    }

    public void modifyAutographCl(String button){
        Bundle bundle = new Bundle();
        bundle.putString("button",button);
        trackAccountEvent("modify_autograph_cl", bundle);
    }

    public void exitMyInfo(String infoFillStatus){
        Bundle bundle = new Bundle();
        bundle.putString("info_fill_status", infoFillStatus);
        trackAccountEvent("exit_my_info", bundle);
    }

    public void oobeEntrenceShow(){
        trackAccountEvent("oobe_entrence_show", null);
    }

    public void palmIdEnter(String source,int loginStatus,String synStatus){
        Bundle bundle = new Bundle();
        bundle.putString("source", source);
        bundle.putInt("login_status", loginStatus);
        bundle.putString("syn_status", synStatus);
        trackAccountEvent("palmid_enter", bundle);
    }

    public void bindNotiShow(String source){
        Bundle bundle = new Bundle();
        bundle.putString("source", source);
        trackAccountEvent("bind_noti_show", bundle);
    }

    public void bindNotiCl(String source,String type){
        Bundle bundle = new Bundle();
        bundle.putString("source", source);
        bundle.putString("type", type);
        trackAccountEvent("bind_noti_cl", bundle);
    }

    public void bindShow(String source,String type,int bindStatus){
        Bundle bundle = new Bundle();
        bundle.putString("source", source);
        bundle.putString("type", type);
        bundle.putInt("bind_status", bindStatus);
        trackAccountEvent("bind_show", bundle);
    }

    public void bindStart(String type,int bindStatus){
        Bundle bundle = new Bundle();
        bundle.putString("type", type);
        bundle.putInt("bind_status", bindStatus);
        trackAccountEvent("bind_start", bundle);
    }

    public void bindEnd(String type,int result,int bindStatus){
        Bundle bundle = new Bundle();
        bundle.putString("type", type);
        bundle.putInt("bind_status", bindStatus);
        bundle.putInt("result", result);
        trackAccountEvent("bind_end", bundle);
    }

    public void identityVerifyShow(String source){
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty(source)){
            bundle.putString("source", source);
        }
        trackAccountEvent("identity_verify_show", bundle);
    }

    public void verifyPasswordResult(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }
        trackAccountEvent("verify_password_result", bundle);
    }

    public void expiredPopShow(){
        trackAccountEvent("expired_pop_show", null);
    }

    public void exitSetPwdPopShow(){
        trackAccountEvent("exit_set_pwd_pop_show",null);
    }

    public void exitSetPwdPopCl(String button){
        Bundle bundle = new Bundle();
        bundle.putString("button",button);
        trackAccountEvent("exit_set_pwd_pop_cl", bundle);
    }

    public void loginQsCl(){
        trackAccountEvent("login_qs_cl", null);
    }

    public void recycleBinPreferenceClick(){
        Bundle bundle = new Bundle();
        trackAccountEvent("recycle_bin_menu_cl", bundle);
    }

    public void recycleBinShow(){
        Bundle bundle = new Bundle();
        trackAccountEvent("recycle_bin_show", bundle);
    }

    public void recycleBinLoadResult(boolean success, String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result", success ? 1 : 0);
        bundle.putString("reason", reason);
        trackAccountEvent("recycle_bin_load_result", bundle);
    }

    public void conflictBtnClick(String btnName){
        Bundle bundle = new Bundle();
        bundle.putString("button", btnName);
        trackAccountEvent("recycle_bin_sync_pop_cl", bundle);
    }

    public void conflictDialogShow(){
        Bundle bundle = new Bundle();
        trackAccountEvent("recycle_bin_sync_pop_show", bundle);
    }

    public void modifyPhotoResult(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }
        trackAccountEvent("modify_photo_result", bundle);
    }

    public void modifyNicknameResult(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }
        trackAccountEvent("modify_nickname_result", bundle);
    }

    public void modifyNameResult(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }
        trackAccountEvent("modify_name_result", bundle);
    }

    public void modifySexualResult(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }
        trackAccountEvent("modify_sexual_result", bundle);
    }

    public void modifyBirthdayResult(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }
        trackAccountEvent("modify_birthday_result", bundle);
    }

    public void modifyRegionResult(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }
        trackAccountEvent("modify_region_result", bundle);
    }

    public void modifyAddresResult(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }
        trackAccountEvent("modify_addres_result", bundle);
    }

    public void modifyAutographResult(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }
        trackAccountEvent("modify_autograph_result", bundle);
    }

    public void addressShow(int addressCnt){
        Bundle bundle = new Bundle();
        bundle.putInt("address_cnt",addressCnt);
        trackAccountEvent("address_show", bundle);
    }

    public void addressAddCl(){
        trackAccountEvent("address_add_cl", null);
    }
    public void addressEditCl(){
        trackAccountEvent("address_edit_cl", null);
    }

    public void addressDetailCl(String button){
        Bundle bundle = new Bundle();
        bundle.putString("button",button);
        trackAccountEvent("address_detail_cl", bundle);
    }

    public void ucModifyPhotoCl(){
        trackAccountEvent("uc_modify_photo_cl", null);
    }

    public void ucPhotoDenyPopCl(String button){
        Bundle bundle = new Bundle();
        bundle.putString("button",button);
        trackAccountEvent("uc_photo_deny_pop_cl", bundle);
    }

    public void accountSecurityShow(String bindList){
        Bundle bundle = new Bundle();
        bundle.putString("bind_list",bindList);
        trackAccountEvent("account_security_show", bundle);
    }

    public void bindPhoneCl(){
        trackAccountEvent("bind_phone_cl", null);
    }

    public void bindMailCl(){
        trackAccountEvent("bind_mail_cl", null);
    }

    public void modifyPasswordCl(){
        trackAccountEvent("modify_password_cl", null);
    }

    public void emergencyInformationCl(){
        trackAccountEvent("emergency_information_cl", null);
    }
    public void addAccountCl(){
        trackAccountEvent("add_account_cl", null);
    }

    public void thirdPartyAccountShow(){
        trackAccountEvent("third_party_account_show", null);
    }

    public void bindGoogleCl(int status){
        Bundle bundle = new Bundle();
        bundle.putInt("status", status);
        trackAccountEvent("bind_google_cl", bundle);
    }

    public void bindFacebookCl(int status){
        Bundle bundle = new Bundle();
        bundle.putInt("status", status);
        trackAccountEvent("bind_facebook_cl", bundle);
    }

    public void bindVKCl(int status){
        Bundle bundle = new Bundle();
        bundle.putInt("status", status);
        trackAccountEvent("bind_vk_cl", bundle);
    }

    public void bindLineCl(int status){
        Bundle bundle = new Bundle();
        bundle.putInt("status", status);
        trackAccountEvent("bind_line_cl", bundle);
    }

    public void bingTpResult(int action,String type,int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        bundle.putString("type",type);//FB,GG
        bundle.putInt("action",action);//0,解绑，1绑定
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }

        trackAccountEvent("bing_tp_result", bundle);
    }

    public void changePwdShow(){
        trackAccountEvent("change_pwd_show", null);
    }

    public void changePwdCl(){
        trackAccountEvent("change_pwd_cl", null);
    }

    public void changePwdResult(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }
        trackAccountEvent("change_pwd_result", bundle);
    }

    public void addEmergencyShow(){
        trackAccountEvent("add_emergency_show", null);
    }

    public void addEmergencySelectCl(){
        trackAccountEvent("add_emergency_select_cl", null);
    }

    public void addEmergencyAddCl(){
        trackAccountEvent("add_emergency_add_cl", null);
    }

    public void addEmergencyResult(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }
        trackAccountEvent("add_emergency_result", bundle);
    }

    public void modifyIdResult(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }
        trackAccountEvent("modify_id_result", bundle);
    }

    public void logoutResult(int result,String reason){
        Bundle bundle = new Bundle();
        bundle.putInt("result",result);
        if (!TextUtils.isEmpty(reason)){
            bundle.putString("reason", reason);
        }
        trackAccountEvent("logout_result", bundle);
    }

    public void tudcUpgradeShow(){
        Bundle bundle = new Bundle();
        trackAccountEvent("sdk_upgrade_show", bundle);
    }

    public void tudcUpgradePV(String pv){
        Bundle bundle = new Bundle();
        bundle.putString("pv", pv);
        trackAccountEvent("sdk_upgrade_cl", bundle);
    }

    public void tudcUpgradeUAV(String uav){
        Bundle bundle = new Bundle();
        bundle.putString("uav", uav);
        trackAccountEvent("sdk_upgrade_cl", bundle);
    }

    public void tudcUpgradeButton(String button){
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        trackAccountEvent("sdk_upgrade_cl", bundle);
    }

    public void agreementUpShow(String version){
        Bundle bundle = new Bundle();
        bundle.putString("version", version);
        trackAccountEvent("agreement_up_show", bundle);
    }

    public void agreementUpBtCl(String button,String uav,String pv){
        Resources res = mContext.getResources();
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        bundle.putLong("dt", System.currentTimeMillis());
        if (res != null) {
            bundle.putString("lang", getLanguage(mContext));
        }
        bundle.putString("uav", uav);
        bundle.putString("pv", pv);
        trackAccountEvent("agreement_up_bt_cl", bundle);
    }

    public void agreementUpLnCl(String link){
        Bundle bundle = new Bundle();
        bundle.putString("link", link);
        trackAccountEvent("agreement_up_ln_cl", bundle);
    }

    public void oobePalmidCl(String  page,String button){
        Bundle bundle = new Bundle();
        bundle.putString("page", page);
        bundle.putString("button", button);
        trackAccountEvent("oobe_palmid_cl", bundle);
    }

    public void oobeLoginSuccessShow(){
        trackAccountEvent("oobe_login_success_show", null);
    }

    public void cloudPermissionResult(int result, String scenario){
        Bundle bundle = new Bundle();
        bundle.putInt("result", result);
        bundle.putString("scenario", scenario);
        trackAccountEvent("cloud_per_result", bundle);
    }

    public void cloudPermissionCl(String  button, String scenario){
        Bundle bundle = new Bundle();
        bundle.putString("button", button);
        bundle.putString("scenario", scenario);
        trackAccountEvent("cloud_per_pop_cl", bundle);
    }

    public void settingRequest(int  loginStatus, int alaStatus){
        Bundle bundle = new Bundle();
        bundle.putInt("login_status", loginStatus);
        bundle.putInt("ala_status", alaStatus);
        trackAccountEvent("setting_request", bundle);
    }

    public void remoteConfigReceived(String  content){
        Bundle bundle = new Bundle();
        bundle.putString("content", content);
        trackAccountEvent("remote_config_received", bundle);
    }

    /**
     * 保存国家名称
     *
     * @param country 国家名称
     */
    public void saveSelectCountryCode(String country) {
        this.country = country;
    }

    /**
     * 获取国家code
     *
     * @return 国家code
     */
    public String getCurrentCode() {
        return country;
    }

    /**
     * 上次选中的国家名称
     *
     * @param preCountry 上次选中国家名称
     */
    public void savePreCountryCode(String preCountry) {
        this.preCountry = preCountry;
    }

    /**
     * 获取上次国家code
     *
     * @return 国家code
     */
    public String getPreCurrentCode() {
        return preCountry;
    }

    public String getLanguage(Context context) {
        Locale locale;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            locale = context.getResources().getConfiguration().getLocales().get(0);
        } else {
            locale = context.getResources().getConfiguration().locale;
        }

        return locale.getLanguage();
    }

    public void addHeadAccountId(String accountId) {
        AthenaAnalytics.setAccount((short) 0, CommonUtils.getSHA256(accountId));
    }
}
