package tech.palm.lib.remoteconifg;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;

public class RemoteConfigGetter {

    public static final String PROVIDER_NAME = "com.hoffnung.cloudControl.RemoteConfigProvider";

    public static String getStringValue(Context context, String configName) {
        ContentResolver cr = context.getContentResolver();
        Cursor cursor = null;
        Uri uri = Uri.parse("content://" + PROVIDER_NAME + "/config/" + configName);
        try {
            cursor = cr.query(uri, null, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndex(configName);
                String stringValue = cursor.getString(index);
                if (stringValue != null) {
                    return stringValue;
                }
            }
        } catch (Exception e) {
//            Log.i(TAG, "get configName fail, cause" + e.getMessage());
        } finally {
            if (null != cursor && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return "";
    }

    public static int getIntValue(Context context, String configName) throws ValueNameNotFoundException {
        String stringValue = getStringValue(context, configName);
        try {
            int intValue = Integer.valueOf(stringValue);
            return intValue;
        } catch (Exception e) {
            throw new ValueNameNotFoundException();
        }
    }

    public static boolean getBooleanValue(Context context, String configName) throws ValueNameNotFoundException {
        String stringValue = getStringValue(context, configName);
        if ("true".equals(stringValue)) {
            return true;
        } else if ("false".equals(stringValue)) {
            return false;
        } else {
            throw new ValueNameNotFoundException();
        }
    }

    public static class ValueNameNotFoundException extends Exception {}

}
