/*
 * Decompiled with CFR 0.152.
 */
package tech.palm.lib.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.provider.Settings;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class CommonUtils {
    public static final long SECOND_IN_MILLIS = 1000L;
    public static final long MIN_IN_MILLIS = 60000L;
    public static final long HOUR_IN_MILLIS = 3600000L;
    public static final long DAY_IN_MILLIS = 86400000L;
    public static final long WEEK_IN_MILLIS = 604800000L;
    public static final long MONTH_IN_MILLIS = 2592000000L;

    public static String transferMillisToDate(String dateFormat, long millsec) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, Locale.ENGLISH);
        Date date = new Date(millsec);
        return sdf.format(date);
    }

    public static String transferMillisToDate(long millsec) {
        return CommonUtils.transferMillisToDate("yyyy-MM-dd HH:mm:ss", millsec);
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager connectivityManager;
        NetworkInfo networkInfo;
        if (context != null && (networkInfo = (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            return networkInfo.isAvailable();
        }
        return false;
    }

    public static boolean isPalmIdSystemApp(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo pi = packageManager.getPackageInfo(context.getPackageName(), 0);
            return (pi.applicationInfo.flags & 1) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isAutoTimeEnabled(Context context) {
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"auto_time", (int)0) > 0;
    }

    public static String SystemPropertiesGet(String key) {
        try {
            Class<?> cl = Class.forName("android.os.SystemProperties");
            Method method = cl.getMethod("get", String.class);
            String value = (String)method.invoke(null, key);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getOsVersion() {
        String osVersion = CommonUtils.SystemPropertiesGet("ro.tranos.version");
        if (TextUtils.isEmpty((CharSequence)osVersion)) {
            osVersion = CommonUtils.SystemPropertiesGet("ro.os_product.version");
        }
        return osVersion;
    }

    public static String getBuildVerName() {
        try {
            Class<?> clazz = Class.forName("tech.palm.id.BuildConfig");
            Field field = clazz.getField("VERSION_NAME");
            return (String)field.get(null);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static int getBuildVerCode() {
        try {
            Class<?> clazz = Class.forName("tech.palm.id.BuildConfig");
            Field field = clazz.getField("VERSION_CODE");
            return (Integer)field.get(null);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static String getStackTrace(Throwable throwable, int stackCount) {
        try {
            StackTraceElement[] ste = throwable.getStackTrace();
            StringBuilder message = new StringBuilder(throwable.toString());
            int i = 0;
            for (StackTraceElement element : ste) {
                message.append("#" + element.getClassName()).append(".").append(element.getMethodName()).append("[" + element.getLineNumber() + "]");
                if (++i >= stackCount) break;
            }
            return message.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile2List(File file, int startLine, int endLine) {
        if (!CommonUtils.isFileExists(file)) {
            return null;
        }
        if (startLine > endLine) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String lineStr;
            ArrayList<String> listStr = new ArrayList<String>();
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            for (int curLine = 1; (lineStr = reader.readLine()) != null && curLine <= endLine; ++curLine) {
                if (startLine > curLine || curLine > endLine) continue;
                listStr.add(lineStr);
            }
            ArrayList<String> arrayList = listStr;
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeList2File(File file, List<String> strMsg) {
        if (file == null) {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            for (String str : strMsg) {
                writer.write(str);
                writer.newLine();
                writer.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getSHA256(String str) {
        String encodestr = "";
        if (TextUtils.isEmpty((CharSequence)str)) {
            return encodestr;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodestr = CommonUtils.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodestr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }
}

